/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import org.orekit.time.TimeStamped;

public interface ComparableMeasurement
extends TimeStamped,
Comparable<ComparableMeasurement> {
    public double[] getObservedValue();

    @Override
    default public int compareTo(ComparableMeasurement other) {
        if (this == other) {
            return 0;
        }
        int result = this.getDate().compareTo(other.getDate());
        if (result == 0) {
            double[] otherV;
            double[] thisV = this.getObservedValue();
            if (thisV.length > (otherV = other.getObservedValue()).length) {
                result = 1;
            } else if (thisV.length < otherV.length) {
                result = -1;
            } else {
                for (int i = 0; i < thisV.length && result == 0; ++i) {
                    result = Double.compare(thisV[i], otherV[i]);
                }
                if (result == 0) {
                    result = -1;
                }
            }
        }
        return result;
    }
}

