/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class InterSatellitesRange
extends AbstractMeasurement<InterSatellitesRange> {
    private final boolean twoway;

    public InterSatellitesRange(ObservableSatellite local, ObservableSatellite remote, boolean twoWay, AbsoluteDate date, double range, double sigma, double baseWeight) {
        super(date, range, sigma, baseWeight, Arrays.asList(local, remote));
        this.twoway = twoWay;
    }

    public boolean isTwoWay() {
        return this.twoway;
    }

    @Override
    protected EstimatedMeasurement<InterSatellitesRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        DerivativeStructure range;
        EstimatedMeasurement<InterSatellitesRange> estimated;
        int nbParams = 12;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        SpacecraftState local = states[0];
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaL = InterSatellitesRange.getCoordinates(local, 0, factory);
        SpacecraftState remote = states[1];
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaR = InterSatellitesRange.getCoordinates(remote, 6, factory);
        DerivativeStructure dtl = this.getSatellites().get(0).getClockOffsetDriver().getValue(factory, indices);
        FieldAbsoluteDate<DerivativeStructure> arrivalDate = new FieldAbsoluteDate<DerivativeStructure>(this.getDate(), dtl.negate());
        FieldPVCoordinates s1Downlink = pvaL.shiftedBy((RealFieldElement)arrivalDate.durationFrom(pvaL.getDate()));
        DerivativeStructure tauD = InterSatellitesRange.signalTimeOfFlight(pvaR, s1Downlink.getPosition(), arrivalDate);
        double delta = this.getDate().durationFrom(remote.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        if (this.twoway) {
            FieldPVCoordinates transitStateDS = pvaR.shiftedBy((RealFieldElement)deltaMTauD);
            DerivativeStructure tauU = InterSatellitesRange.signalTimeOfFlight(pvaL, transitStateDS.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateDS).getDate());
            estimated = new EstimatedMeasurement<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD.getValue()), remote.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{local.shiftedBy(delta - tauD.getValue() - tauU.getValue()).getPVCoordinates(), remote.shiftedBy(delta - tauD.getValue()).getPVCoordinates(), local.shiftedBy(delta).getPVCoordinates()});
            range = tauD.add(tauU).multiply(1.49896229E8);
        } else {
            estimated = new EstimatedMeasurement<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD.getValue()), remote.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{remote.shiftedBy(delta - tauD.getValue()).getPVCoordinates(), local.shiftedBy(delta).getPVCoordinates()});
            DerivativeStructure dtr = this.getSatellites().get(1).getClockOffsetDriver().getValue(factory, indices);
            range = tauD.add(dtl).subtract(dtr).multiply(2.99792458E8);
        }
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        estimated.setStateDerivatives(1, new double[][]{Arrays.copyOfRange(derivatives, 7, 13)});
        return estimated;
    }
}

