/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.orekit.estimation.measurements.gnss.GRAPHICCombination;
import org.orekit.estimation.measurements.gnss.GeometryFreeCombination;
import org.orekit.estimation.measurements.gnss.IonosphereFreeCombination;
import org.orekit.estimation.measurements.gnss.MelbourneWubbenaCombination;
import org.orekit.estimation.measurements.gnss.NarrowLaneCombination;
import org.orekit.estimation.measurements.gnss.PhaseMinusCodeCombination;
import org.orekit.estimation.measurements.gnss.WideLaneCombination;
import org.orekit.gnss.SatelliteSystem;

public class MeasurementCombinationFactory {
    private MeasurementCombinationFactory() {
    }

    public static WideLaneCombination getWideLaneCombination(SatelliteSystem system) {
        return new WideLaneCombination(system);
    }

    public static NarrowLaneCombination getNarrowLaneCombination(SatelliteSystem system) {
        return new NarrowLaneCombination(system);
    }

    public static IonosphereFreeCombination getIonosphereFreeCombination(SatelliteSystem system) {
        return new IonosphereFreeCombination(system);
    }

    public static GeometryFreeCombination getGeometryFreeCombination(SatelliteSystem system) {
        return new GeometryFreeCombination(system);
    }

    public static MelbourneWubbenaCombination getMelbourneWubbenaCombination(SatelliteSystem system) {
        return new MelbourneWubbenaCombination(system);
    }

    public static PhaseMinusCodeCombination getPhaseMinusCodeCombination(SatelliteSystem system) {
        return new PhaseMinusCodeCombination(system);
    }

    public static GRAPHICCombination getGRAPHICCombination(SatelliteSystem system) {
        return new GRAPHICCombination(system);
    }
}

