/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.util.MathArrays;
import org.orekit.estimation.measurements.gnss.AbstractDualFrequencyCombination;
import org.orekit.estimation.measurements.gnss.CombinationType;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.SatelliteSystem;

public class NarrowLaneCombination
extends AbstractDualFrequencyCombination {
    NarrowLaneCombination(SatelliteSystem system) {
        super(CombinationType.NARROW_LANE, system);
    }

    @Override
    protected double getCombinedValue(double obs1, Frequency f1, double obs2, Frequency f2) {
        double ratioF1 = f1.getRatio();
        double ratioF2 = f2.getRatio();
        return MathArrays.linearCombination(ratioF1, obs1, ratioF2, obs2) / (ratioF1 + ratioF2);
    }

    @Override
    protected double getCombinedFrequency(Frequency f1, Frequency f2) {
        return f1.getMHzFrequency() + f2.getMHzFrequency();
    }
}

