/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Phase
extends AbstractMeasurement<Phase> {
    public static final String AMBIGUITY_NAME = "ambiguity";
    private final ParameterDriver ambiguityDriver = new ParameterDriver("ambiguity", 0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final GroundStation station;
    private final double wavelength;

    public Phase(GroundStation station, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, phase, sigma, baseWeight, Arrays.asList(satellite));
        this.addParameterDriver(this.ambiguityDriver);
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        this.station = station;
        this.wavelength = wavelength;
    }

    public GroundStation getStation() {
        return this.station;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    @Override
    protected EstimatedMeasurement<Phase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites().get(0);
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field<DerivativeStructure> field = factory.getDerivativeField();
        FieldVector3D<DerivativeStructure> zero = FieldVector3D.getZero(field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = Phase.getCoordinates(state, 0, factory);
        FieldTransform<DerivativeStructure> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), this.getDate(), factory, indices);
        FieldAbsoluteDate<DerivativeStructure> downlinkDateDS = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<DerivativeStructure> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(downlinkDateDS, zero, zero, zero));
        DerivativeStructure tauD = Phase.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        DerivativeStructure delta = downlinkDateDS.durationFrom(state.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        EstimatedMeasurement<Phase> estimated = new EstimatedMeasurement<Phase>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        DerivativeStructure ambiguity = this.ambiguityDriver.getValue(factory, indices);
        DerivativeStructure phase = tauD.multiply(cOverLambda).add(ambiguity);
        estimated.setEstimatedValue(phase.getValue());
        double[] derivatives = phase.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index + 1]);
        }
        return estimated;
    }
}

