/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.orekit.estimation.measurements.gnss.AmbiguityAcceptance;
import org.orekit.estimation.measurements.gnss.IntegerLeastSquareSolution;

public class SimpleRatioAmbiguityAcceptance
implements AmbiguityAcceptance {
    private static final int NB_CANDIDATES = 2;
    private final double ratio;

    public SimpleRatioAmbiguityAcceptance(double ratio) {
        this.ratio = ratio;
    }

    @Override
    public int numberOfCandidates() {
        return 2;
    }

    @Override
    public IntegerLeastSquareSolution accept(IntegerLeastSquareSolution[] candidates) {
        if (candidates[0].getSquaredDistance() / candidates[1].getSquaredDistance() <= this.ratio) {
            return candidates[0];
        }
        return null;
    }
}

