/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.frames.Frame;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class WindUp
implements EstimationModifier<Phase> {
    private double angularWindUp = 0.0;

    WindUp() {
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        Vector3D los = ((Vector3D)participants[1].getPosition().subtract((Vector)participants[0].getPosition())).normalize();
        Frame inertial = estimated.getStates()[0].getFrame();
        GroundStation station = estimated.getObservedMeasurement().getStation();
        Rotation offsetToInert = station.getOffsetToInertial(inertial, estimated.getDate()).getRotation();
        Vector3D iGround = offsetToInert.applyTo(Vector3D.PLUS_I);
        Vector3D jGround = offsetToInert.applyTo(Vector3D.PLUS_J);
        Vector dGround = new Vector3D(1.0, iGround, -Vector3D.dotProduct(iGround, los), los).add((Vector)Vector3D.crossProduct(los, jGround));
        Rotation satToInert = estimated.getStates()[0].toTransform().getRotation().revert();
        Vector3D iSat = satToInert.applyTo(Vector3D.PLUS_I);
        Vector3D jSat = satToInert.applyTo(Vector3D.PLUS_J);
        Vector dSat = new Vector3D(1.0, iSat, -Vector3D.dotProduct(iSat, los), los).subtract((Vector)Vector3D.crossProduct(los, jSat));
        double correction = FastMath.copySign(Vector3D.angle((Vector3D)dSat, (Vector3D)dGround), Vector3D.dotProduct(los, Vector3D.crossProduct((Vector3D)dSat, (Vector3D)dGround)));
        this.angularWindUp = MathUtils.normalizeAngle(correction, this.angularWindUp);
        estimated.setEstimatedValue(estimated.getEstimatedValue()[0] + this.angularWindUp / (Math.PI * 2));
    }
}

