/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.estimation.measurements.modifiers.IonosphericDSConverter;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class TurnAroundRangeIonosphericDelayModifier
implements EstimationModifier<TurnAroundRange> {
    private final IonosphericModel ionoModel;
    private final double frequency;

    public TurnAroundRangeIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    private double rangeErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        double delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters());
        return delay;
    }

    private <T extends RealFieldElement<T>> T rangeErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        RealFieldElement delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (RealFieldElement[])parameters);
        return (T)delay;
    }

    private double[][] rangeErrorJacobianState(double[] derivatives, int freeStateParameters) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        for (int i = 0; i < freeStateParameters; ++i) {
            finiteDifferencesJacobian[0][i] = derivatives[i + 1];
        }
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return TurnAroundRangeIonosphericDelayModifier.this.rangeErrorIonosphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - 1 - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[1 + freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<TurnAroundRange> estimated) {
        double parameterDerivative;
        TurnAroundRange measurement = estimated.getObservedMeasurement();
        GroundStation masterStation = measurement.getMasterStation();
        GroundStation slaveStation = measurement.getSlaveStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        IonosphericDSConverter converter = new IonosphericDSConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<DerivativeStructure> dsState = converter.getState(this.ionoModel);
        RealFieldElement[] dsParameters = converter.getParameters(dsState, this.ionoModel);
        DerivativeStructure masterDSDelay = (DerivativeStructure)this.rangeErrorIonosphericModel(masterStation, dsState, dsParameters);
        DerivativeStructure slaveDSDelay = (DerivativeStructure)this.rangeErrorIonosphericModel(slaveStation, dsState, dsParameters);
        double[] masterDerivatives = masterDSDelay.getAllDerivatives();
        double[] slaveDerivatives = masterDSDelay.getAllDerivatives();
        double[][] masterDjac = this.rangeErrorJacobianState(masterDerivatives, converter.getFreeStateParameters());
        double[][] slaveDjac = this.rangeErrorJacobianState(slaveDerivatives, converter.getFreeStateParameters());
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + (masterDjac[irow][jcol] + slaveDjac[irow][jcol]);
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int indexMaster = 0;
        for (ParameterDriver parameterDriver : this.getParametersDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            double parameterDerivative2 = estimated.getParameterDerivatives(parameterDriver)[0];
            double[] derivatives = this.rangeErrorParameterDerivative(masterDerivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(parameterDriver, parameterDerivative2 += derivatives[indexMaster]);
            ++indexMaster;
        }
        int indexSlave = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] derivatives = this.rangeErrorParameterDerivative(slaveDerivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += derivatives[indexSlave]);
            ++indexSlave;
        }
        for (ParameterDriver driver : Arrays.asList(masterStation.getClockOffsetDriver(), masterStation.getEastOffsetDriver(), masterStation.getNorthOffsetDriver(), masterStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(masterStation, driver, state));
        }
        for (ParameterDriver driver : Arrays.asList(slaveStation.getEastOffsetDriver(), slaveStation.getNorthOffsetDriver(), slaveStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(slaveStation, driver, state));
        }
        double[] dArray = (double[])oldValue.clone();
        dArray[0] = dArray[0] + masterDSDelay.getReal() + slaveDSDelay.getReal();
        estimated.setEstimatedValue(dArray);
    }
}

