/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.NonLinearEvolution;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.DynamicOutlierFilter;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.estimation.sequential.KalmanODModel;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.IntegratedPropagatorBuilder;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.PartialDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class KalmanModel
implements KalmanODModel {
    private final List<IntegratedPropagatorBuilder> builders;
    private final ParameterDriversList allEstimatedOrbitalParameters;
    private final ParameterDriversList allEstimatedPropagationParameters;
    private final ParameterDriversList[] estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final int[] orbitsStartColumns;
    private final int[] orbitsEndColumns;
    private final Map<String, Integer> measurementParameterColumns;
    private final List<CovarianceMatrixProvider> covarianceMatricesProviders;
    private final int[][] covarianceIndirection;
    private final double[] scale;
    private final JacobiansMapper[] mappers;
    private NumericalPropagator[] referenceTrajectories;
    private ProcessEstimate correctedEstimate;
    private int currentMeasurementNumber;
    private AbsoluteDate referenceDate;
    private AbsoluteDate currentDate;
    private SpacecraftState[] predictedSpacecraftStates;
    private SpacecraftState[] correctedSpacecraftStates;
    private EstimatedMeasurement<?> predictedMeasurement;
    private EstimatedMeasurement<?> correctedMeasurement;

    /*
     * WARNING - void declaration
     */
    public KalmanModel(List<IntegratedPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters) {
        void var12_53;
        void var9_26;
        this.builders = propagatorBuilders;
        this.estimatedMeasurementsParameters = estimatedMeasurementParameters;
        this.measurementParameterColumns = new HashMap<String, Integer>(this.estimatedMeasurementsParameters.getDrivers().size());
        this.currentMeasurementNumber = 0;
        this.currentDate = this.referenceDate = propagatorBuilders.get(0).getInitialOrbitDate();
        HashMap<String, Integer> orbitalParameterColumns = new HashMap<String, Integer>(6 * this.builders.size());
        this.orbitsStartColumns = new int[this.builders.size()];
        this.orbitsEndColumns = new int[this.builders.size()];
        int columns = 0;
        this.allEstimatedOrbitalParameters = new ParameterDriversList();
        for (int k = 0; k < this.builders.size(); ++k) {
            this.orbitsStartColumns[k] = columns;
            String suffix = propagatorBuilders.size() > 1 ? "[" + k + "]" : null;
            for (ParameterDriver parameterDriver : this.builders.get(k).getOrbitalParametersDrivers().getDrivers()) {
                if (parameterDriver.getReferenceDate() == null) {
                    parameterDriver.setReferenceDate(this.currentDate);
                }
                if (suffix != null && !parameterDriver.getName().endsWith(suffix)) {
                    parameterDriver.setName(parameterDriver.getName() + suffix);
                }
                if (!parameterDriver.isSelected()) continue;
                this.allEstimatedOrbitalParameters.add(parameterDriver);
                orbitalParameterColumns.put(parameterDriver.getName(), columns++);
            }
            this.orbitsEndColumns[k] = columns;
        }
        this.allEstimatedPropagationParameters = new ParameterDriversList();
        this.estimatedPropagationParameters = new ParameterDriversList[this.builders.size()];
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (int k = 0; k < this.builders.size(); ++k) {
            this.estimatedPropagationParameters[k] = new ParameterDriversList();
            for (ParameterDriver parameterDriver : this.builders.get(k).getPropagationParametersDrivers().getDrivers()) {
                if (parameterDriver.getReferenceDate() == null) {
                    parameterDriver.setReferenceDate(this.currentDate);
                }
                if (!parameterDriver.isSelected()) continue;
                this.allEstimatedPropagationParameters.add(parameterDriver);
                this.estimatedPropagationParameters[k].add(parameterDriver);
                String string = parameterDriver.getName();
                if (estimatedPropagationParametersNames.contains(string)) continue;
                estimatedPropagationParametersNames.add(string);
            }
        }
        estimatedPropagationParametersNames.sort(Comparator.naturalOrder());
        HashMap<String, Integer> propagationParameterColumns = new HashMap<String, Integer>(estimatedPropagationParametersNames.size());
        for (String string : estimatedPropagationParametersNames) {
            propagationParameterColumns.put(string, columns);
            ++columns;
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            this.measurementParameterColumns.put(parameterDriver.getName(), columns);
            ++columns;
        }
        this.covarianceMatricesProviders = covarianceMatricesProviders;
        this.covarianceIndirection = new int[covarianceMatricesProviders.size()][columns];
        for (int k = 0; k < this.covarianceIndirection.length; ++k) {
            Integer c;
            ParameterDriversList parameterDriversList = this.builders.get(k).getOrbitalParametersDrivers();
            ParameterDriversList parameterDriversList2 = this.builders.get(k).getPropagationParametersDrivers();
            Arrays.fill(this.covarianceIndirection[k], -1);
            int i = 0;
            for (ParameterDriver parameterDriver : parameterDriversList.getDrivers()) {
                c = (Integer)orbitalParameterColumns.get(parameterDriver.getName());
                this.covarianceIndirection[k][i++] = c == null ? -1 : c;
            }
            for (ParameterDriver parameterDriver : parameterDriversList2.getDrivers()) {
                c = (Integer)propagationParameterColumns.get(parameterDriver.getName());
                if (c == null) continue;
                this.covarianceIndirection[k][i++] = c;
            }
            for (ParameterDriver parameterDriver : estimatedMeasurementParameters.getDrivers()) {
                c = this.measurementParameterColumns.get(parameterDriver.getName());
                if (c == null) continue;
                this.covarianceIndirection[k][i++] = c;
            }
        }
        this.scale = new double[columns];
        int index = 0;
        for (ParameterDriver parameterDriver : this.allEstimatedOrbitalParameters.getDrivers()) {
            this.scale[index++] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.allEstimatedPropagationParameters.getDrivers()) {
            this.scale[index++] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            this.scale[index++] = parameterDriver.getScale();
        }
        this.mappers = new JacobiansMapper[this.builders.size()];
        this.updateReferenceTrajectories(this.getEstimatedPropagators());
        this.predictedSpacecraftStates = new SpacecraftState[this.referenceTrajectories.length];
        boolean bl = false;
        while (var9_26 < this.predictedSpacecraftStates.length) {
            this.predictedSpacecraftStates[var9_26] = this.referenceTrajectories[var9_26].getInitialState();
            ++var9_26;
        }
        this.correctedSpacecraftStates = (SpacecraftState[])this.predictedSpacecraftStates.clone();
        RealVector realVector = MatrixUtils.createRealVector(columns);
        boolean bl2 = false;
        for (ParameterDriver parameterDriver : this.allEstimatedOrbitalParameters.getDrivers()) {
            void var10_38;
            realVector.setEntry((int)(++var10_38), parameterDriver.getNormalizedValue());
        }
        for (ParameterDriver parameterDriver : this.allEstimatedPropagationParameters.getDrivers()) {
            void var10_39;
            realVector.setEntry((int)(++var10_39), parameterDriver.getNormalizedValue());
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            void var10_40;
            realVector.setEntry((int)(++var10_40), parameterDriver.getNormalizedValue());
        }
        RealMatrix physicalProcessNoise = MatrixUtils.createRealMatrix(columns, columns);
        boolean bl3 = false;
        while (var12_53 < covarianceMatricesProviders.size()) {
            RealMatrix realMatrix = covarianceMatricesProviders.get((int)var12_53).getInitialCovarianceMatrix(this.correctedSpacecraftStates[var12_53]);
            this.checkDimension(realMatrix.getRowDimension(), this.builders.get((int)var12_53).getOrbitalParametersDrivers(), this.builders.get((int)var12_53).getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
            int[] indK = this.covarianceIndirection[var12_53];
            for (int i = 0; i < indK.length; ++i) {
                if (indK[i] < 0) continue;
                for (int j = 0; j < indK.length; ++j) {
                    if (indK[j] < 0) continue;
                    physicalProcessNoise.setEntry(indK[i], indK[j], realMatrix.getEntry(i, j));
                }
            }
            ++var12_53;
        }
        RealMatrix realMatrix = this.normalizeCovarianceMatrix(physicalProcessNoise);
        this.correctedEstimate = new ProcessEstimate(0.0, realVector, realMatrix);
    }

    private void checkDimension(int dimension, ParameterDriversList orbitalParameters, ParameterDriversList propagationParameters, ParameterDriversList measurementParameters) {
        int requiredDimension = orbitalParameters.getNbParams();
        for (ParameterDriver parameterDriver : propagationParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        for (ParameterDriver parameterDriver : measurementParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        if (dimension != requiredDimension) {
            StringBuilder builder = new StringBuilder();
            for (ParameterDriver parameterDriver : orbitalParameters.getDrivers()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(parameterDriver.getName());
            }
            for (ParameterDriver parameterDriver : propagationParameters.getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                builder.append(parameterDriver.getName());
            }
            for (ParameterDriver parameterDriver : measurementParameters.getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                builder.append(parameterDriver.getName());
            }
            throw new OrekitException((Localizable)OrekitMessages.DIMENSION_INCONSISTENT_WITH_PARAMETERS, dimension, builder.toString());
        }
    }

    @Override
    public SpacecraftState[] getPredictedSpacecraftStates() {
        return (SpacecraftState[])this.predictedSpacecraftStates.clone();
    }

    @Override
    public SpacecraftState[] getCorrectedSpacecraftStates() {
        return (SpacecraftState[])this.correctedSpacecraftStates.clone();
    }

    @Override
    public RealMatrix getPhysicalStateTransitionMatrix() {
        RealMatrix normalizedSTM = this.correctedEstimate.getStateTransitionMatrix();
        if (normalizedSTM == null) {
            return null;
        }
        int nbParams = normalizedSTM.getRowDimension();
        RealMatrix physicalSTM = MatrixUtils.createRealMatrix(nbParams, nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                physicalSTM.setEntry(i, j, normalizedSTM.getEntry(i, j) * this.scale[i] / this.scale[j]);
            }
        }
        return physicalSTM;
    }

    @Override
    public RealMatrix getPhysicalMeasurementJacobian() {
        RealMatrix normalizedH = this.correctedEstimate.getMeasurementJacobian();
        if (normalizedH == null) {
            return null;
        }
        double[] sigmas = this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        int nbLine = normalizedH.getRowDimension();
        int nbCol = normalizedH.getColumnDimension();
        RealMatrix physicalH = MatrixUtils.createRealMatrix(nbLine, nbCol);
        for (int i = 0; i < nbLine; ++i) {
            for (int j = 0; j < nbCol; ++j) {
                physicalH.setEntry(i, j, normalizedH.getEntry(i, j) * sigmas[i] / this.scale[j]);
            }
        }
        return physicalH;
    }

    @Override
    public RealMatrix getPhysicalInnovationCovarianceMatrix() {
        RealMatrix normalizedS = this.correctedEstimate.getInnovationCovariance();
        if (normalizedS == null) {
            return null;
        }
        double[] sigmas = this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        int nbMeas = sigmas.length;
        RealMatrix physicalS = MatrixUtils.createRealMatrix(nbMeas, nbMeas);
        for (int i = 0; i < nbMeas; ++i) {
            for (int j = 0; j < nbMeas; ++j) {
                physicalS.setEntry(i, j, normalizedS.getEntry(i, j) * sigmas[i] * sigmas[j]);
            }
        }
        return physicalS;
    }

    @Override
    public RealMatrix getPhysicalKalmanGain() {
        RealMatrix normalizedK = this.correctedEstimate.getKalmanGain();
        if (normalizedK == null) {
            return null;
        }
        double[] sigmas = this.correctedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        int nbLine = normalizedK.getRowDimension();
        int nbCol = normalizedK.getColumnDimension();
        RealMatrix physicalK = MatrixUtils.createRealMatrix(nbLine, nbCol);
        for (int i = 0; i < nbLine; ++i) {
            for (int j = 0; j < nbCol; ++j) {
                physicalK.setEntry(i, j, normalizedK.getEntry(i, j) * this.scale[i] / sigmas[j]);
            }
        }
        return physicalK;
    }

    @Override
    public int getCurrentMeasurementNumber() {
        return this.currentMeasurementNumber;
    }

    @Override
    public AbsoluteDate getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public EstimatedMeasurement<?> getPredictedMeasurement() {
        return this.predictedMeasurement;
    }

    @Override
    public EstimatedMeasurement<?> getCorrectedMeasurement() {
        return this.correctedMeasurement;
    }

    @Override
    public RealVector getPhysicalEstimatedState() {
        ArrayRealVector physicalEstimatedState = new ArrayRealVector(this.scale.length);
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            ((RealVector)physicalEstimatedState).setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            ((RealVector)physicalEstimatedState).setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            ((RealVector)physicalEstimatedState).setEntry(i++, driver.getValue());
        }
        return physicalEstimatedState;
    }

    @Override
    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        RealMatrix normalizedP = this.correctedEstimate.getCovariance();
        int nbParams = normalizedP.getRowDimension();
        RealMatrix physicalP = MatrixUtils.createRealMatrix(nbParams, nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                physicalP.setEntry(i, j, normalizedP.getEntry(i, j) * this.scale[i] * this.scale[j]);
            }
        }
        return physicalP;
    }

    @Override
    public ParameterDriversList getEstimatedOrbitalParameters() {
        return this.allEstimatedOrbitalParameters;
    }

    @Override
    public ParameterDriversList getEstimatedPropagationParameters() {
        return this.allEstimatedPropagationParameters;
    }

    @Override
    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.estimatedMeasurementsParameters;
    }

    @Override
    public ProcessEstimate getEstimate() {
        return this.correctedEstimate;
    }

    public NumericalPropagator[] getEstimatedPropagators() {
        NumericalPropagator[] propagators = new NumericalPropagator[this.builders.size()];
        for (int k = 0; k < this.builders.size(); ++k) {
            propagators[k] = (NumericalPropagator)this.builders.get(k).buildPropagator(this.builders.get(k).getSelectedNormalizedParameters());
        }
        return propagators;
    }

    private RealMatrix getErrorStateTransitionMatrix() {
        RealMatrix stm = MatrixUtils.createRealIdentityMatrix(this.correctedEstimate.getState().getDimension());
        for (int k = 0; k < this.predictedSpacecraftStates.length; ++k) {
            double[][] dYdY0 = new double[6][6];
            this.mappers[k].getStateJacobian(this.predictedSpacecraftStates[k], dYdY0);
            List<ParameterDriversList.DelegatingDriver> drivers = this.builders.get(k).getOrbitalParametersDrivers().getDrivers();
            for (int i = 0; i < dYdY0.length; ++i) {
                if (!drivers.get(i).isSelected()) continue;
                int jOrb = this.orbitsStartColumns[k];
                for (int j = 0; j < dYdY0[i].length; ++j) {
                    if (!drivers.get(j).isSelected()) continue;
                    stm.setEntry(i, jOrb++, dYdY0[i][j]);
                }
            }
            int nbParams = this.estimatedPropagationParameters[k].getNbParams();
            if (nbParams <= 0) continue;
            double[][] dYdPp = new double[6][nbParams];
            this.mappers[k].getParametersJacobian(this.predictedSpacecraftStates[k], dYdPp);
            for (int i = 0; i < dYdPp.length; ++i) {
                for (int j = 0; j < nbParams; ++j) {
                    stm.setEntry(i, this.orbitsEndColumns[k] + j, dYdPp[i][j]);
                }
            }
        }
        for (int i = 0; i < this.scale.length; ++i) {
            for (int j = 0; j < this.scale.length; ++j) {
                stm.setEntry(i, j, stm.getEntry(i, j) * this.scale[j] / this.scale[i]);
            }
        }
        return stm;
    }

    private RealMatrix getMeasurementMatrix() {
        SpacecraftState[] evaluationStates = this.predictedMeasurement.getStates();
        Object observedMeasurement = this.predictedMeasurement.getObservedMeasurement();
        double[] sigma = observedMeasurement.getTheoreticalStandardDeviation();
        RealMatrix measurementMatrix = MatrixUtils.createRealMatrix(observedMeasurement.getDimension(), this.correctedEstimate.getState().getDimension());
        for (int k = 0; k < evaluationStates.length; ++k) {
            int p = observedMeasurement.getSatellites().get(k).getPropagatorIndex();
            Orbit predictedOrbit = evaluationStates[k].getOrbit();
            double[][] aCY = new double[6][6];
            predictedOrbit.getJacobianWrtParameters(this.builders.get(p).getPositionAngle(), aCY);
            Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
            Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(this.predictedMeasurement.getStateDerivatives(k), false);
            RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
            for (int i = 0; i < dMdY.getRowDimension(); ++i) {
                int jOrb = this.orbitsStartColumns[p];
                for (int j = 0; j < dMdY.getColumnDimension(); ++j) {
                    ParameterDriver driver = this.builders.get(p).getOrbitalParametersDrivers().getDrivers().get(j);
                    if (!driver.isSelected()) continue;
                    measurementMatrix.setEntry(i, jOrb++, dMdY.getEntry(i, j) / sigma[i] * driver.getScale());
                }
            }
            int nbParams = this.estimatedPropagationParameters[p].getNbParams();
            if (nbParams > 0) {
                double[][] aYPp = new double[6][nbParams];
                this.mappers[p].getParametersJacobian(evaluationStates[k], aYPp);
                Array2DRowRealMatrix dYdPp = new Array2DRowRealMatrix(aYPp, false);
                RealMatrix dMdPp = dMdY.multiply(dYdPp);
                for (int i = 0; i < dMdPp.getRowDimension(); ++i) {
                    for (int j = 0; j < nbParams; ++j) {
                        ParameterDriver delegating = this.allEstimatedPropagationParameters.getDrivers().get(j);
                        measurementMatrix.setEntry(i, this.orbitsEndColumns[p] + j, dMdPp.getEntry(i, j) / sigma[i] * delegating.getScale());
                    }
                }
            }
            for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                double[] aMPm = this.predictedMeasurement.getParameterDerivatives(driver);
                if (this.measurementParameterColumns.get(driver.getName()) == null) continue;
                int driverColumn = this.measurementParameterColumns.get(driver.getName());
                for (int i = 0; i < aMPm.length; ++i) {
                    measurementMatrix.setEntry(i, driverColumn, aMPm[i] / sigma[i] * driver.getScale());
                }
            }
        }
        return measurementMatrix;
    }

    private void updateReferenceTrajectories(NumericalPropagator[] propagators) {
        this.referenceTrajectories = propagators;
        for (int k = 0; k < propagators.length; ++k) {
            String equationName = KalmanEstimator.class.getName() + "-derivatives-" + k;
            PartialDerivativesEquations pde = new PartialDerivativesEquations(equationName, this.referenceTrajectories[k]);
            SpacecraftState rawState = this.referenceTrajectories[k].getInitialState();
            SpacecraftState stateWithDerivatives = pde.setInitialJacobians(rawState);
            this.referenceTrajectories[k].resetInitialState(stateWithDerivatives);
            this.mappers[k] = pde.getMapper();
        }
    }

    private RealMatrix normalizeCovarianceMatrix(RealMatrix physicalCovarianceMatrix) {
        int nbParams = physicalCovarianceMatrix.getRowDimension();
        RealMatrix normalizedCovarianceMatrix = MatrixUtils.createRealMatrix(nbParams, nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                normalizedCovarianceMatrix.setEntry(i, j, physicalCovarianceMatrix.getEntry(i, j) / (this.scale[i] * this.scale[j]));
            }
        }
        return normalizedCovarianceMatrix;
    }

    private <T extends ObservedMeasurement<T>> void applyDynamicOutlierFilter(EstimatedMeasurement<T> measurement, RealMatrix innovationCovarianceMatrix) {
        T observedMeasurement = measurement.getObservedMeasurement();
        for (EstimationModifier<T> modifier : observedMeasurement.getModifiers()) {
            if (!(modifier instanceof DynamicOutlierFilter)) continue;
            DynamicOutlierFilter dynamicOutlierFilter = (DynamicOutlierFilter)modifier;
            double[] sigmaDynamic = new double[innovationCovarianceMatrix.getColumnDimension()];
            double[] sigmaMeasurement = observedMeasurement.getTheoreticalStandardDeviation();
            for (int i = 0; i < sigmaDynamic.length; ++i) {
                sigmaDynamic[i] = FastMath.sqrt(innovationCovarianceMatrix.getEntry(i, i)) * sigmaMeasurement[i];
            }
            dynamicOutlierFilter.setSigma(sigmaDynamic);
            modifier.modify(measurement);
            dynamicOutlierFilter.setSigma(null);
        }
    }

    @Override
    public NonLinearEvolution getEvolution(double previousTime, RealVector previousState, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (driver.getReferenceDate() != null) continue;
            driver.setReferenceDate(this.builders.get(0).getInitialOrbitDate());
        }
        ++this.currentMeasurementNumber;
        this.currentDate = measurement.getObservedMeasurement().getDate();
        RealVector predictedState = this.predictState(observedMeasurement.getDate());
        RealMatrix stateTransitionMatrix = this.getErrorStateTransitionMatrix();
        this.predictedMeasurement = observedMeasurement.estimate(this.currentMeasurementNumber, this.currentMeasurementNumber, this.filterRelevant(observedMeasurement, this.predictedSpacecraftStates));
        RealMatrix measurementMatrix = this.getMeasurementMatrix();
        RealMatrix physicalProcessNoise = MatrixUtils.createRealMatrix(previousState.getDimension(), previousState.getDimension());
        for (int k = 0; k < this.covarianceMatricesProviders.size(); ++k) {
            RealMatrix noiseK = this.covarianceMatricesProviders.get(k).getProcessNoiseMatrix(this.correctedSpacecraftStates[k], this.predictedSpacecraftStates[k]);
            this.checkDimension(noiseK.getRowDimension(), this.builders.get(k).getOrbitalParametersDrivers(), this.builders.get(k).getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
            int[] indK = this.covarianceIndirection[k];
            for (int i = 0; i < indK.length; ++i) {
                if (indK[i] < 0) continue;
                for (int j = 0; j < indK.length; ++j) {
                    if (indK[j] < 0) continue;
                    physicalProcessNoise.setEntry(indK[i], indK[j], noiseK.getEntry(i, j));
                }
            }
        }
        RealMatrix normalizedProcessNoise = this.normalizeCovarianceMatrix(physicalProcessNoise);
        return new NonLinearEvolution(measurement.getTime(), predictedState, stateTransitionMatrix, normalizedProcessNoise, measurementMatrix);
    }

    @Override
    public RealVector getInnovation(MeasurementDecorator measurement, NonLinearEvolution evolution, RealMatrix innovationCovarianceMatrix) {
        this.applyDynamicOutlierFilter(this.predictedMeasurement, innovationCovarianceMatrix);
        if (this.predictedMeasurement.getStatus() == EstimatedMeasurement.Status.REJECTED) {
            return null;
        }
        double[] observed = this.predictedMeasurement.getObservedMeasurement().getObservedValue();
        double[] estimated = this.predictedMeasurement.getEstimatedValue();
        double[] sigma = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        double[] residuals = new double[observed.length];
        for (int i = 0; i < observed.length; ++i) {
            residuals[i] = (observed[i] - estimated[i]) / sigma[i];
        }
        return MatrixUtils.createRealVector(residuals);
    }

    @Override
    public void finalizeEstimation(ObservedMeasurement<?> observedMeasurement, ProcessEstimate estimate) {
        this.correctedEstimate = estimate;
        this.updateParameters();
        NumericalPropagator[] estimatedPropagators = this.getEstimatedPropagators();
        for (int k = 0; k < estimatedPropagators.length; ++k) {
            this.correctedSpacecraftStates[k] = estimatedPropagators[k].getInitialState();
        }
        this.correctedMeasurement = observedMeasurement.estimate(this.currentMeasurementNumber, this.currentMeasurementNumber, this.filterRelevant(observedMeasurement, this.correctedSpacecraftStates));
        this.updateReferenceTrajectories(estimatedPropagators);
    }

    private SpacecraftState[] filterRelevant(ObservedMeasurement<?> observedMeasurement, SpacecraftState[] allStates) {
        List<ObservableSatellite> satellites = observedMeasurement.getSatellites();
        SpacecraftState[] relevantStates = new SpacecraftState[satellites.size()];
        for (int i = 0; i < relevantStates.length; ++i) {
            relevantStates[i] = allStates[satellites.get(i).getPropagatorIndex()];
        }
        return relevantStates;
    }

    private RealVector predictState(AbsoluteDate date) {
        RealVector predictedState = this.correctedEstimate.getState().copy();
        int jOrb = 0;
        for (int k = 0; k < this.predictedSpacecraftStates.length; ++k) {
            this.predictedSpacecraftStates[k] = this.referenceTrajectories[k].propagate(date);
            this.builders.get(k).resetOrbit(this.predictedSpacecraftStates[k].getOrbit());
            for (ParameterDriversList.DelegatingDriver orbitalDriver : this.builders.get(k).getOrbitalParametersDrivers().getDrivers()) {
                if (!orbitalDriver.isSelected()) continue;
                predictedState.setEntry(jOrb++, orbitalDriver.getNormalizedValue());
            }
        }
        return predictedState;
    }

    private void updateParameters() {
        RealVector correctedState = this.correctedEstimate.getState();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            driver.setNormalizedValue(correctedState.getEntry(i));
            correctedState.setEntry(i++, driver.getNormalizedValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            driver.setNormalizedValue(correctedState.getEntry(i));
            correctedState.setEntry(i++, driver.getNormalizedValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            driver.setNormalizedValue(correctedState.getEntry(i));
            correctedState.setEntry(i++, driver.getNormalizedValue());
        }
    }
}

