/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.utils.IERSConventions;

public enum CcsdsTimeScale {
    GMST{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getGMST(conventions, false);
        }
    }
    ,
    GPS{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getGPS();
        }
    }
    ,
    MET{

        @Override
        public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate, TimeScales timeScales) {
            DateTimeComponents clock = DateTimeComponents.parseDateTime(date);
            double offset = (double)clock.getDate().getYear() * 3.15576E7 + (double)clock.getDate().getDayOfYear() * 86400.0 + clock.getTime().getSecondsInUTCDay();
            return missionReferenceDate.shiftedBy(offset);
        }

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_NO_CORRESPONDING_TIME_SCALE, "MET");
        }
    }
    ,
    MRT{

        @Override
        public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate, TimeScales timeScales) {
            DateTimeComponents clock = DateTimeComponents.parseDateTime(date);
            double offset = (double)clock.getDate().getYear() * 3.15576E7 + (double)clock.getDate().getDayOfYear() * 86400.0 + clock.getTime().getSecondsInUTCDay();
            return missionReferenceDate.shiftedBy(offset);
        }

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_NO_CORRESPONDING_TIME_SCALE, "MRT");
        }
    }
    ,
    SCLK{

        @Override
        public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate, TimeScales timeScales) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_TIME_SYSTEM_NOT_IMPLEMENTED, this.name());
        }

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_NO_CORRESPONDING_TIME_SCALE, this.name());
        }
    }
    ,
    TAI{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getTAI();
        }
    }
    ,
    TCB{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getTCB();
        }
    }
    ,
    TDB{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getTDB();
        }
    }
    ,
    TCG{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getTCG();
        }
    }
    ,
    TT{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getTT();
        }
    }
    ,
    UT1{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getUT1(conventions, false);
        }
    }
    ,
    UTC{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions, TimeScales timeScales) {
            return timeScales.getUTC();
        }
    };


    @DefaultDataContext
    public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate) {
        return this.parseDate(date, conventions, missionReferenceDate, DataContext.getDefault().getTimeScales());
    }

    public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate, TimeScales timeScales) {
        return new AbsoluteDate(date, this.getTimeScale(conventions, timeScales));
    }

    @DefaultDataContext
    public TimeScale getTimeScale(IERSConventions conventions) {
        return this.getTimeScale(conventions, DataContext.getDefault().getTimeScales());
    }

    public abstract TimeScale getTimeScale(IERSConventions var1, TimeScales var2);

    public static boolean contains(String timeScale) {
        for (CcsdsTimeScale scale : CcsdsTimeScale.values()) {
            if (!scale.name().equals(timeScale)) continue;
            return true;
        }
        return false;
    }
}

