/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public abstract class ODMFile {
    private double formatVersion;
    private List<String> headerComment;
    private AbsoluteDate creationDate;
    private String originator;
    private double muSet = Double.NaN;
    private double muParsed = Double.NaN;
    private double muCreated = Double.NaN;
    private IERSConventions conventions;
    private double muUsed = Double.NaN;
    private AbsoluteDate missionReferenceDate;
    private DataContext dataContext;

    public double getMuSet() {
        return this.muSet;
    }

    void setMuSet(double muSet) {
        this.muSet = muSet;
    }

    public double getMuParsed() {
        return this.muParsed;
    }

    void setMuParsed(double muParsed) {
        this.muParsed = muParsed;
    }

    public double getMuCreated() {
        return this.muCreated;
    }

    void setMuCreated(double muCreated) {
        this.muCreated = muCreated;
    }

    public double getMuUsed() {
        return this.muUsed;
    }

    protected void setMuUsed() {
        if (!Double.isNaN(this.muParsed)) {
            this.muUsed = this.muParsed;
        } else if (!Double.isNaN(this.muSet)) {
            this.muUsed = this.muSet;
        } else if (!Double.isNaN(this.muCreated)) {
            this.muUsed = this.muCreated;
        } else {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_GM, new Object[0]);
        }
    }

    public IERSConventions getConventions() {
        if (this.conventions != null) {
            return this.conventions;
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
    }

    void setConventions(IERSConventions conventions) {
        this.conventions = conventions;
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    void setMissionReferenceDate(AbsoluteDate missionReferenceDate) {
        this.missionReferenceDate = missionReferenceDate;
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public List<String> getHeaderComment() {
        return this.headerComment;
    }

    void setHeaderComment(List<String> headerComment) {
        this.headerComment = new ArrayList<String>(headerComment);
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    void setCreationDate(AbsoluteDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getOriginator() {
        return this.originator;
    }

    void setOriginator(String originator) {
        this.originator = originator;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }
}

