/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.CcsdsModifiedFrame;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.files.ccsds.ODMFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;

public class ODMMetaData {
    private final ODMFile odmFile;
    private CcsdsTimeScale timeSystem;
    private String objectName;
    private String objectID;
    private int launchYear;
    private int launchNumber;
    private String launchPiece;
    private String centerName;
    private CelestialBody centerBody;
    private boolean hasCreatableBody;
    private Frame refFrame;
    private String refFrameString;
    private String frameEpochString;
    private AbsoluteDate frameEpoch;
    private List<String> comment;

    ODMMetaData(ODMFile odmFile) {
        this.odmFile = odmFile;
        this.comment = new ArrayList<String>();
    }

    public ODMFile getODMFile() {
        return this.odmFile;
    }

    public CcsdsTimeScale getTimeSystem() {
        return this.timeSystem;
    }

    void setTimeSystem(CcsdsTimeScale timeSystem) {
        this.timeSystem = timeSystem;
    }

    TimeScale getTimeScale() {
        return this.getTimeSystem().getTimeScale(this.odmFile.getConventions(), this.odmFile.getDataContext().getTimeScales());
    }

    public String getObjectName() {
        return this.objectName;
    }

    void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectID() {
        return this.objectID;
    }

    void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    void setLaunchYear(int launchYear) {
        this.launchYear = launchYear;
    }

    public int getLaunchYear() {
        return this.launchYear;
    }

    void setLaunchNumber(int launchNumber) {
        this.launchNumber = launchNumber;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    void setLaunchPiece(String launchPiece) {
        this.launchPiece = launchPiece;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public String getCenterName() {
        return this.centerName;
    }

    void setCenterName(String centerName) {
        this.centerName = centerName;
    }

    public CelestialBody getCenterBody() {
        return this.centerBody;
    }

    void setCenterBody(CelestialBody centerBody) {
        this.centerBody = centerBody;
    }

    public boolean getHasCreatableBody() {
        return this.hasCreatableBody;
    }

    void setHasCreatableBody(boolean hasCreatableBody) {
        this.hasCreatableBody = hasCreatableBody;
    }

    public Frame getFrame() {
        Frame frame = this.getRefFrame();
        CelestialBody body = this.getCenterBody();
        if (body == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_DATA_LOADED_FOR_CELESTIAL_BODY, this.getCenterName());
        }
        String frameString = this.getFrameString();
        boolean isMci = "MCI".equals(frameString);
        boolean isIcrf = "ICRF".equals(frameString);
        boolean isSolarSystemBarycenter = "solar system barycenter".equals(body.getName());
        if (!isMci && !isIcrf && "Earth".equals(body.getName()) || isMci && "Mars".equals(body.getName()) || isIcrf && isSolarSystemBarycenter) {
            return frame;
        }
        return new CcsdsModifiedFrame(frame, frameString, body, this.getCenterName());
    }

    public Frame getRefFrame() {
        return this.refFrame;
    }

    void setRefFrame(Frame refFrame) {
        this.refFrame = refFrame;
    }

    public String getFrameString() {
        return this.refFrameString;
    }

    void setFrameString(String frame) {
        this.refFrameString = frame;
    }

    public String getFrameEpochString() {
        return this.frameEpochString;
    }

    void setFrameEpochString(String frameEpochString) {
        this.frameEpochString = frameEpochString;
    }

    public AbsoluteDate getFrameEpoch() {
        return this.frameEpoch;
    }

    void setFrameEpoch(AbsoluteDate frameEpoch) {
        this.frameEpoch = frameEpoch;
    }

    public List<String> getComment() {
        return Collections.unmodifiableList(this.comment);
    }

    void setComment(List<String> comment) {
        this.comment = new ArrayList<String>(comment);
    }
}

