/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.CCSDSFrame;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.files.ccsds.ODMParser;
import org.orekit.files.ccsds.OPMFile;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class OPMParser
extends ODMParser {
    @DefaultDataContext
    public OPMParser() {
        this(DataContext.getDefault());
    }

    public OPMParser(DataContext dataContext) {
        this(AbsoluteDate.FUTURE_INFINITY, Double.NaN, null, true, 0, 0, "", dataContext);
    }

    private OPMParser(AbsoluteDate missionReferenceDate, double mu, IERSConventions conventions, boolean simpleEOP, int launchYear, int launchNumber, String launchPiece, DataContext dataContext) {
        super(missionReferenceDate, mu, conventions, simpleEOP, launchYear, launchNumber, launchPiece, dataContext);
    }

    @Override
    public OPMParser withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return new OPMParser(newMissionReferenceDate, this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OPMParser withMu(double newMu) {
        return new OPMParser(this.getMissionReferenceDate(), newMu, this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OPMParser withConventions(IERSConventions newConventions) {
        return new OPMParser(this.getMissionReferenceDate(), this.getMu(), newConventions, this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OPMParser withSimpleEOP(boolean newSimpleEOP) {
        return new OPMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), newSimpleEOP, this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OPMParser withInternationalDesignator(int newLaunchYear, int newLaunchNumber, String newLaunchPiece) {
        return new OPMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), newLaunchYear, newLaunchNumber, newLaunchPiece, this.getDataContext());
    }

    @Override
    public OPMParser withDataContext(DataContext newDataContext) {
        return new OPMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), newDataContext);
    }

    @Override
    public OPMFile parse(String fileName) {
        return (OPMFile)super.parse(fileName);
    }

    @Override
    public OPMFile parse(InputStream stream) {
        return (OPMFile)super.parse(stream);
    }

    @Override
    public OPMFile parse(InputStream stream, String fileName) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            ParseInfo pi = new ParseInfo();
            pi.fileName = fileName;
            OPMFile file = pi.file;
            pi.file.setMissionReferenceDate(this.getMissionReferenceDate());
            pi.file.setMuSet(this.getMu());
            pi.file.setConventions(this.getConventions());
            pi.file.setDataContext(this.getDataContext());
            pi.file.getMetaData().setLaunchYear(this.getLaunchYear());
            pi.file.getMetaData().setLaunchNumber(this.getLaunchNumber());
            pi.file.getMetaData().setLaunchPiece(this.getLaunchPiece());
            String line = reader.readLine();
            while (line != null) {
                ++pi.lineNumber;
                if (line.trim().length() != 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case CCSDS_OPM_VERS: {
                            file.setFormatVersion(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case X: {
                            pi.x = pi.keyValue.getDoubleValue() * 1000.0;
                            break;
                        }
                        case Y: {
                            pi.y = pi.keyValue.getDoubleValue() * 1000.0;
                            break;
                        }
                        case Z: {
                            pi.z = pi.keyValue.getDoubleValue() * 1000.0;
                            break;
                        }
                        case X_DOT: {
                            pi.x_dot = pi.keyValue.getDoubleValue() * 1000.0;
                            break;
                        }
                        case Y_DOT: {
                            pi.y_dot = pi.keyValue.getDoubleValue() * 1000.0;
                            break;
                        }
                        case Z_DOT: {
                            pi.z_dot = pi.keyValue.getDoubleValue() * 1000.0;
                            break;
                        }
                        case MAN_EPOCH_IGNITION: {
                            if (pi.maneuver != null) {
                                file.addManeuver(pi.maneuver);
                            }
                            pi.maneuver = new OPMFile.Maneuver();
                            pi.maneuver.setEpochIgnition(this.parseDate(pi.keyValue.getValue(), file.getMetaData().getTimeSystem()));
                            if (pi.commentTmp.isEmpty()) break;
                            pi.maneuver.setComment(pi.commentTmp);
                            pi.commentTmp.clear();
                            break;
                        }
                        case MAN_DURATION: {
                            pi.maneuver.setDuration(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case MAN_DELTA_MASS: {
                            pi.maneuver.setDeltaMass(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case MAN_REF_FRAME: {
                            CCSDSFrame manFrame = this.parseCCSDSFrame(pi.keyValue.getValue());
                            if (manFrame.isLof()) {
                                pi.maneuver.setRefLofType(manFrame.getLofType());
                                break;
                            }
                            pi.maneuver.setRefFrame(manFrame.getFrame(this.getConventions(), this.isSimpleEOP(), this.getDataContext()));
                            break;
                        }
                        case MAN_DV_1: {
                            pi.maneuver.setdV(new Vector3D(pi.keyValue.getDoubleValue() * 1000.0, pi.maneuver.getDV().getY(), pi.maneuver.getDV().getZ()));
                            break;
                        }
                        case MAN_DV_2: {
                            pi.maneuver.setdV(new Vector3D(pi.maneuver.getDV().getX(), pi.keyValue.getDoubleValue() * 1000.0, pi.maneuver.getDV().getZ()));
                            break;
                        }
                        case MAN_DV_3: {
                            pi.maneuver.setdV(new Vector3D(pi.maneuver.getDV().getX(), pi.maneuver.getDV().getY(), pi.keyValue.getDoubleValue() * 1000.0));
                            break;
                        }
                        default: {
                            boolean parsed = false;
                            parsed = parsed || this.parseComment(pi.keyValue, pi.commentTmp);
                            parsed = parsed || this.parseHeaderEntry(pi.keyValue, file, pi.commentTmp);
                            parsed = parsed || this.parseMetaDataEntry(pi.keyValue, file.getMetaData(), pi.commentTmp);
                            boolean bl = parsed = parsed || this.parseGeneralStateDataEntry(pi.keyValue, file, pi.commentTmp);
                            if (parsed) break;
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
                line = reader.readLine();
            }
            file.setPosition(new Vector3D(pi.x, pi.y, pi.z));
            file.setVelocity(new Vector3D(pi.x_dot, pi.y_dot, pi.z_dot));
            if (pi.maneuver != null) {
                file.addManeuver(pi.maneuver);
            }
            reader.close();
            return file;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private static class ParseInfo {
        private OPMFile file = new OPMFile();
        private String fileName;
        private int lineNumber = 0;
        private KeyValue keyValue;
        private List<String> commentTmp = new ArrayList<String>();
        private double x;
        private double y;
        private double z;
        private double x_dot;
        private double y_dot;
        private double z_dot;
        private OPMFile.Maneuver maneuver = null;

        protected ParseInfo() {
        }
    }
}

