/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SP3File
implements EphemerisFile {
    public static final String SP3_FRAME_CENTER_STRING = "EARTH";
    private SP3FileType type;
    private TimeSystem timeSystem;
    private AbsoluteDate epoch;
    private int gpsWeek;
    private double secondsOfWeek;
    private int julianDay;
    private double dayFraction;
    private double epochInterval;
    private int numberOfEpochs;
    private String coordinateSystem;
    private String dataUsed;
    private SP3OrbitType orbitType;
    private String orbitTypeKey;
    private String agency;
    private CartesianDerivativesFilter filter;
    private TimeScale timeScale;
    private String timeScaleString;
    private final double mu;
    private final int interpolationSamples;
    private final Function<? super String, ? extends Frame> frameBuilder;
    private Map<String, SP3Ephemeris> satellites;

    SP3File(double mu, int interpolationSamples, Function<? super String, ? extends Frame> frameBuilder) {
        this.mu = mu;
        this.interpolationSamples = interpolationSamples;
        this.frameBuilder = frameBuilder;
        this.satellites = new LinkedHashMap<String, SP3Ephemeris>();
    }

    void setFilter(CartesianDerivativesFilter filter) {
        this.filter = filter;
    }

    void setTimeScale(TimeScale timeScale) {
        this.timeScale = timeScale;
    }

    void setTimeScaleString(String timeScaleString) {
        this.timeScaleString = timeScaleString;
    }

    public SP3FileType getType() {
        return this.type;
    }

    void setType(SP3FileType fileType) {
        this.type = fileType;
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    void setTimeSystem(TimeSystem system) {
        this.timeSystem = system;
    }

    public String getDataUsed() {
        return this.dataUsed;
    }

    void setDataUsed(String data) {
        this.dataUsed = data;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    void setEpoch(AbsoluteDate time) {
        this.epoch = time;
    }

    public int getGpsWeek() {
        return this.gpsWeek;
    }

    void setGpsWeek(int week) {
        this.gpsWeek = week;
    }

    public double getSecondsOfWeek() {
        return this.secondsOfWeek;
    }

    void setSecondsOfWeek(double seconds) {
        this.secondsOfWeek = seconds;
    }

    public int getJulianDay() {
        return this.julianDay;
    }

    void setJulianDay(int day) {
        this.julianDay = day;
    }

    public double getDayFraction() {
        return this.dayFraction;
    }

    void setDayFraction(double fraction) {
        this.dayFraction = fraction;
    }

    public double getEpochInterval() {
        return this.epochInterval;
    }

    void setEpochInterval(double interval) {
        this.epochInterval = interval;
    }

    public int getNumberOfEpochs() {
        return this.numberOfEpochs;
    }

    void setNumberOfEpochs(int epochCount) {
        this.numberOfEpochs = epochCount;
    }

    public String getCoordinateSystem() {
        return this.coordinateSystem;
    }

    void setCoordinateSystem(String system) {
        this.coordinateSystem = system;
    }

    public SP3OrbitType getOrbitType() {
        return this.orbitType;
    }

    public String getOrbitTypeKey() {
        return this.orbitTypeKey;
    }

    void setOrbitTypeKey(String oTypeKey) {
        this.orbitTypeKey = oTypeKey;
        this.orbitType = SP3OrbitType.parseType(oTypeKey);
    }

    public String getAgency() {
        return this.agency;
    }

    void setAgency(String agencyStr) {
        this.agency = agencyStr;
    }

    public void addSatellite(String satId) {
        this.satellites.putIfAbsent(satId, new SP3Ephemeris(satId));
    }

    public Map<String, SP3Ephemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public int getSatelliteCount() {
        return this.satellites.size();
    }

    void setAccuracy(int index, double accuracy) {
        int n = index;
        for (SP3Ephemeris ephemeris : this.satellites.values()) {
            if (n == 0) {
                ephemeris.setAccuracy(accuracy);
                return;
            }
            --n;
        }
    }

    double getAccuracy(int index) {
        int n = index;
        for (SP3Ephemeris ephemeris : this.satellites.values()) {
            if (n == 0) {
                return ephemeris.getAccuracy();
            }
            --n;
        }
        return Double.NaN;
    }

    public boolean containsSatellite(String satId) {
        return this.satellites.containsKey(satId);
    }

    void addSatelliteCoordinate(String satId, SP3Coordinate coord) {
        this.satellites.get(satId).coordinates.add(coord);
    }

    public static class SP3Coordinate
    extends TimeStampedPVCoordinates {
        private static final long serialVersionUID = 20161116L;
        private final double clock;
        private final double clockRate;

        SP3Coordinate(AbsoluteDate date, Vector3D position, double clock) {
            this(date, position, Vector3D.ZERO, clock, 0.0);
        }

        SP3Coordinate(AbsoluteDate date, Vector3D position, Vector3D velocity, double clock, double clockRate) {
            super(date, position, velocity, Vector3D.ZERO);
            this.clock = clock;
            this.clockRate = clockRate;
        }

        public double getClockCorrection() {
            return this.clock;
        }

        public double getClockRateChange() {
            return this.clockRate;
        }
    }

    public class SP3Ephemeris
    implements EphemerisFile.SatelliteEphemeris,
    EphemerisFile.EphemerisSegment {
        private final String id;
        private final List<SP3Coordinate> coordinates;
        private double accuracy;

        SP3Ephemeris(String id) {
            this.id = id;
            this.coordinates = new ArrayList<SP3Coordinate>();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getMu() {
            return SP3File.this.mu;
        }

        @Override
        public String getFrameCenterString() {
            return SP3File.SP3_FRAME_CENTER_STRING;
        }

        @Override
        public String getFrameString() {
            return SP3File.this.getCoordinateSystem();
        }

        @Override
        public Frame getFrame() {
            return (Frame)SP3File.this.frameBuilder.apply(this.getFrameString());
        }

        @Override
        public String getTimeScaleString() {
            return SP3File.this.timeScaleString;
        }

        @Override
        public TimeScale getTimeScale() {
            return SP3File.this.timeScale;
        }

        @Override
        public int getInterpolationSamples() {
            return SP3File.this.interpolationSamples;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return SP3File.this.filter;
        }

        public List<SP3Coordinate> getCoordinates() {
            return Collections.unmodifiableList(this.coordinates);
        }

        public List<SP3Ephemeris> getSegments() {
            return Collections.singletonList(this);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.coordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.coordinates.get(this.coordinates.size() - 1).getDate();
        }

        @Override
        public BoundedPropagator getPropagator() {
            return EphemerisFile.EphemerisSegment.super.getPropagator();
        }

        void setAccuracy(double accuracy) {
            this.accuracy = accuracy;
        }

        public double getAccuracy() {
            return this.accuracy;
        }
    }

    public static enum TimeSystem {
        GPS,
        GLO,
        GAL,
        TAI,
        UTC,
        QZS;

    }

    public static enum SP3OrbitType {
        FIT,
        EXT,
        BCT,
        HLM,
        OTHER;


        public static SP3OrbitType parseType(String s) {
            String normalizedString = s.trim().toUpperCase(Locale.US);
            if ("EST".equals(normalizedString)) {
                return FIT;
            }
            if ("BHN".equals(normalizedString)) {
                return FIT;
            }
            if ("PRO".equals(normalizedString)) {
                return EXT;
            }
            try {
                return SP3OrbitType.valueOf(normalizedString);
            }
            catch (IllegalArgumentException iae) {
                return OTHER;
            }
        }
    }

    public static enum SP3FileType {
        GPS,
        MIXED,
        GLONASS,
        LEO,
        GALILEO,
        COMPASS,
        QZSS,
        UNDEFINED;

    }
}

