/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.utils.ParameterDriver;

public abstract class AbstractForceModel
implements ForceModel {
    @Override
    public ParameterDriver getParameterDriver(String name) {
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!name.equals(driver.getName())) continue;
            return driver;
        }
        throw this.notSupportedException(name);
    }

    @Override
    public boolean isSupported(String name) {
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!name.equals(driver.getName())) continue;
            return true;
        }
        return false;
    }

    protected void complainIfNotSupported(String name) {
        if (!this.isSupported(name)) {
            throw this.notSupportedException(name);
        }
    }

    private OrekitException notSupportedException(String name) {
        StringBuilder builder = new StringBuilder();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(driver.getName());
        }
        if (builder.length() == 0) {
            builder.append("<none>");
        }
        return new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, name, builder.toString());
    }
}

