/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.AbstractParametricAcceleration;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class HarmonicParametricAcceleration
extends AbstractParametricAcceleration {
    private static final double AMPLITUDE_SCALE = FastMath.scalb(1.0, -20);
    private static final double PHASE_SCALE = FastMath.scalb(1.0, -23);
    private final ParameterDriver[] drivers;
    private AbsoluteDate referenceDate;
    private final double omega;

    public HarmonicParametricAcceleration(Vector3D direction, boolean isInertial, String prefix, AbsoluteDate referenceDate, double fundamentalPeriod, int harmonicMultiplier) {
        this(direction, isInertial, null, prefix, referenceDate, fundamentalPeriod, harmonicMultiplier);
    }

    public HarmonicParametricAcceleration(Vector3D direction, AttitudeProvider attitudeOverride, String prefix, AbsoluteDate referenceDate, double fundamentalPeriod, int harmonicMultiplier) {
        this(direction, false, attitudeOverride, prefix, referenceDate, fundamentalPeriod, harmonicMultiplier);
    }

    private HarmonicParametricAcceleration(Vector3D direction, boolean isInertial, AttitudeProvider attitudeOverride, String prefix, AbsoluteDate referenceDate, double fundamentalPeriod, int harmonicMultiplier) {
        super(direction, isInertial, attitudeOverride);
        this.referenceDate = referenceDate;
        this.omega = (double)harmonicMultiplier * (Math.PI * 2) / fundamentalPeriod;
        try {
            this.drivers = new ParameterDriver[]{new ParameterDriver(prefix + " \u03b3", 0.0, AMPLITUDE_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterDriver(prefix + " \u03c6", 0.0, PHASE_SCALE, Math.PI * -2, Math.PI * 2)};
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.isInertial();
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        if (this.referenceDate == null) {
            this.referenceDate = initialState.getDate();
        }
    }

    @Override
    protected double signedAmplitude(SpacecraftState state, double[] parameters) {
        double dt = state.getDate().durationFrom(this.referenceDate);
        return parameters[0] * FastMath.sin(dt * this.omega + parameters[1]);
    }

    @Override
    protected <T extends RealFieldElement<T>> T signedAmplitude(FieldSpacecraftState<T> state, T[] parameters) {
        T dt = state.getDate().durationFrom(this.referenceDate);
        return (T)((RealFieldElement)parameters[0].multiply(((RealFieldElement)((RealFieldElement)dt.multiply(this.omega)).add(parameters[1])).sin()));
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return (ParameterDriver[])this.drivers.clone();
    }
}

