/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.data.BodiesElements;
import org.orekit.data.FundamentalNutationArguments;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeVectorFunction;

class OceanTidesField
implements NormalizedSphericalHarmonicsProvider {
    private final int degree;
    private final int order;
    private final double ae;
    private final double mu;
    private final List<OceanTidesWave> waves;
    private final FundamentalNutationArguments arguments;
    private final TimeVectorFunction poleTideFunction;

    OceanTidesField(double ae, double mu, List<OceanTidesWave> waves, FundamentalNutationArguments arguments, TimeVectorFunction poleTideFunction) {
        this.ae = ae;
        this.mu = mu;
        this.waves = waves;
        int m = 0;
        int n = 0;
        for (OceanTidesWave wave : waves) {
            m = FastMath.max(m, wave.getMaxDegree());
            n = FastMath.max(n, wave.getMaxOrder());
        }
        this.degree = m;
        this.order = n;
        this.arguments = arguments;
        this.poleTideFunction = poleTideFunction;
    }

    @Override
    public int getMaxDegree() {
        return this.degree;
    }

    @Override
    public int getMaxOrder() {
        return this.order;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public double getAe() {
        return this.ae;
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return AbsoluteDate.ARBITRARY_EPOCH;
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return date.durationFrom(this.getReferenceDate());
    }

    @Override
    public TideSystem getTideSystem() {
        return TideSystem.ZERO_TIDE;
    }

    @Override
    public NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics onDate(AbsoluteDate date) {
        int rows = this.degree + 1;
        double[][] cnm = new double[rows][];
        double[][] snm = new double[rows][];
        for (int i = 0; i <= this.degree; ++i) {
            int m = FastMath.min(i, this.order) + 1;
            cnm[i] = new double[m];
            snm[i] = new double[m];
        }
        BodiesElements bodiesElements = this.arguments.evaluateAll(date);
        for (OceanTidesWave wave : this.waves) {
            wave.addContribution(bodiesElements, cnm, snm);
        }
        if (this.poleTideFunction != null && this.degree > 1 && this.order > 0) {
            this.poleTide(date, cnm, snm);
        }
        return new TideHarmonics(date, cnm, snm);
    }

    private void poleTide(AbsoluteDate date, double[][] cnm, double[][] snm) {
        double[] deltaCS = this.poleTideFunction.value(date);
        double[] dArray = cnm[2];
        dArray[1] = dArray[1] + deltaCS[0];
        double[] dArray2 = snm[2];
        dArray2[1] = dArray2[1] + deltaCS[1];
    }

    private static class TideHarmonics
    implements NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics {
        private final AbsoluteDate date;
        private final double[][] cnm;
        private final double[][] snm;

        private TideHarmonics(AbsoluteDate date, double[][] cnm, double[][] snm) {
            this.date = date;
            this.cnm = cnm;
            this.snm = snm;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        @Override
        public double getNormalizedCnm(int n, int m) {
            return this.cnm[n][m];
        }

        @Override
        public double getNormalizedSnm(int n, int m) {
            return this.snm[n][m];
        }
    }
}

