/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;

public class ThirdBodyAttraction
extends AbstractForceModel {
    public static final String ATTRACTION_COEFFICIENT_SUFFIX = " attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb(1.0, 32);
    private final ParameterDriver gmParameterDriver;
    private final CelestialBody body;

    public ThirdBodyAttraction(CelestialBody body) {
        try {
            this.gmParameterDriver = new ParameterDriver(body.getName() + ATTRACTION_COEFFICIENT_SUFFIX, body.getGM(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.body = body;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double gm = parameters[0];
        Vector3D centralToBody = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        double r2Central = centralToBody.getNormSq();
        Vector satToBody = centralToBody.subtract((Vector)s.getPVCoordinates().getPosition());
        double r2Sat = ((Vector3D)satToBody).getNormSq();
        return new Vector3D(gm / (r2Sat * FastMath.sqrt(r2Sat)), (Vector3D)satToBody, -gm / (r2Central * FastMath.sqrt(r2Central)), centralToBody);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T gm = parameters[0];
        FieldVector3D centralToBody = new FieldVector3D(s.getA().getField(), this.body.getPVCoordinates(s.getDate().toAbsoluteDate(), s.getFrame()).getPosition());
        T r2Central = centralToBody.getNormSq();
        FieldVector3D satToBody = centralToBody.subtract(s.getPVCoordinates().getPosition());
        T r2Sat = satToBody.getNormSq();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r2Sat.multiply(r2Sat.sqrt())).reciprocal()).multiply(gm), satToBody, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r2Central.multiply(r2Central.sqrt())).reciprocal()).multiply(gm)).negate(), centralToBody);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }
}

