/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;

public class EGMFormatReader
extends PotentialCoefficientsReader {
    private final boolean useWgs84Coefficients;

    public EGMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, false);
    }

    public EGMFormatReader(String supportedNames, boolean missingCoefficientsAllowed, boolean useWgs84Coefficients) {
        super(supportedNames, missingCoefficientsAllowed, null);
        this.useWgs84Coefficients = useWgs84Coefficients;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        if (this.useWgs84Coefficients) {
            this.setAe(6378137.0);
            this.setMu(3.986004418E14);
        } else {
            this.setAe(6378136.3);
            this.setMu(3.986004415E14);
        }
        String lowerCaseName = name.toLowerCase(Locale.US);
        if (lowerCaseName.contains("2008") || lowerCaseName.contains("zerotide")) {
            this.setTideSystem(TideSystem.ZERO_TIDE);
        } else {
            this.setTideSystem(TideSystem.TIDE_FREE);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        ArrayList<List<Double>> c = new ArrayList<List<Double>>();
        ArrayList<List<Double>> s = new ArrayList<List<Double>>();
        boolean okFields = true;
        String line = r.readLine();
        while (okFields && line != null) {
            if (line.length() >= 15) {
                String[] tab = line.trim().split("\\s+");
                if (tab.length != 6) {
                    okFields = false;
                }
                int i = Integer.parseInt(tab[0]);
                int j = Integer.parseInt(tab[1]);
                if (i <= this.getMaxParseDegree() && j <= this.getMaxParseOrder()) {
                    for (int k = 0; k <= i; ++k) {
                        this.extendListOfLists(c, k, FastMath.min(k, this.getMaxParseOrder()), this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                        this.extendListOfLists(s, k, FastMath.min(k, this.getMaxParseOrder()), this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                    }
                    this.parseCoefficient(tab[2], c, i, j, "C", name);
                    this.parseCoefficient(tab[3], s, i, j, "S", name);
                }
            }
            line = r.readLine();
        }
        if (this.missingCoefficientsAllowed() && this.getMaxParseDegree() > 0 && this.getMaxParseOrder() > 0) {
            this.extendListOfLists(c, 0, 0, 0.0);
            this.extendListOfLists(s, 0, 0, 0.0);
            if (Precision.equals((double)((Double)((List)c.get(0)).get(0)), 0.0, 0)) {
                ((List)c.get(0)).set(0, 1.0);
            }
        }
        if (!okFields || c.size() < 1) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        this.setRawCoefficients(true, this.toArray(c), this.toArray(s), name);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        return this.getConstantProvider(wantNormalized, degree, order);
    }
}

