/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.AstronomicalAmplitudeReader;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.EGMFormatReader;
import org.orekit.forces.gravity.potential.FESCHatEpsilonReader;
import org.orekit.forces.gravity.potential.FESCnmSnmReader;
import org.orekit.forces.gravity.potential.GRGSFormatReader;
import org.orekit.forces.gravity.potential.GravityFields;
import org.orekit.forces.gravity.potential.ICGEMFormatReader;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.OceanLoadDeformationCoefficients;
import org.orekit.forces.gravity.potential.OceanTidesReader;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SHMFormatReader;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.WrappingNormalizedProvider;
import org.orekit.forces.gravity.potential.WrappingUnnormalizedProvider;
import org.orekit.time.TimeScale;

public class LazyLoadedGravityFields
implements GravityFields {
    private final List<PotentialCoefficientsReader> readers = new ArrayList<PotentialCoefficientsReader>();
    private final List<OceanTidesReader> oceanTidesReaders = new ArrayList<OceanTidesReader>();
    private OceanLoadDeformationCoefficients oceanLoadDeformationCoefficients = OceanLoadDeformationCoefficients.IERS_2010;
    private final DataProvidersManager dataProvidersManager;
    private final TimeScale timeScale;

    public LazyLoadedGravityFields(DataProvidersManager dataProvidersManager, TimeScale timeScale) {
        this.dataProvidersManager = dataProvidersManager;
        this.timeScale = timeScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPotentialCoefficientsReader(PotentialCoefficientsReader reader) {
        List<PotentialCoefficientsReader> list = this.readers;
        synchronized (list) {
            this.readers.add(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultPotentialCoefficientsReaders() {
        List<PotentialCoefficientsReader> list = this.readers;
        synchronized (list) {
            this.readers.add(new ICGEMFormatReader("^(.*\\.gfc)|(g(\\d)+_eigen[-_](\\w)+_coef)$", false, this.timeScale));
            this.readers.add(new SHMFormatReader("^eigen[-_](\\w)+_coef$", false, this.timeScale));
            this.readers.add(new EGMFormatReader("^egm\\d\\d_to\\d.*$", false));
            this.readers.add(new GRGSFormatReader("^grim\\d_.*$", false, this.timeScale));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPotentialCoefficientsReaders() {
        List<PotentialCoefficientsReader> list = this.readers;
        synchronized (list) {
            this.readers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOceanTidesReader(OceanTidesReader reader) {
        List<OceanTidesReader> list = this.oceanTidesReaders;
        synchronized (list) {
            this.oceanTidesReaders.add(reader);
        }
    }

    public void configureOceanLoadDeformationCoefficients(OceanLoadDeformationCoefficients oldc) {
        this.oceanLoadDeformationCoefficients = oldc;
    }

    public OceanLoadDeformationCoefficients getOceanLoadDeformationCoefficients() {
        return this.oceanLoadDeformationCoefficients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultOceanTidesReaders() {
        List<OceanTidesReader> list = this.oceanTidesReaders;
        synchronized (list) {
            this.oceanTidesReaders.add(new FESCnmSnmReader("^fes(\\d)+_Cnm-Snm.dat$", 1.0E-11));
            AstronomicalAmplitudeReader aaReader = new AstronomicalAmplitudeReader("^hf-fes(\\d)+.dat$", 5, 2, 3, 1.0);
            this.dataProvidersManager.feed(aaReader.getSupportedNames(), aaReader);
            Map<Integer, Double> map = aaReader.getAstronomicalAmplitudesMap();
            this.oceanTidesReaders.add(new FESCHatEpsilonReader("^fes(\\d)+.dat$", 0.01, FastMath.toRadians(1.0), this.getOceanLoadDeformationCoefficients(), map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOceanTidesReaders() {
        List<OceanTidesReader> list = this.oceanTidesReaders;
        synchronized (list) {
            this.oceanTidesReaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PotentialCoefficientsReader readGravityField(int maxParseDegree, int maxParseOrder) {
        List<PotentialCoefficientsReader> list = this.readers;
        synchronized (list) {
            if (this.readers.isEmpty()) {
                this.addDefaultPotentialCoefficientsReaders();
            }
            for (PotentialCoefficientsReader reader : this.readers) {
                reader.setMaxParseDegree(maxParseDegree);
                reader.setMaxParseOrder(maxParseOrder);
                this.dataProvidersManager.feed(reader.getSupportedNames(), reader);
                if (reader.stillAcceptsData()) continue;
                return reader;
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_GRAVITY_FIELD_DATA_LOADED, new Object[0]);
    }

    @Override
    public NormalizedSphericalHarmonicsProvider getConstantNormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = this.readGravityField(degree, order);
        ConstantSphericalHarmonics provider = reader.getConstantProvider(true, degree, order);
        return new WrappingNormalizedProvider(provider);
    }

    @Override
    public NormalizedSphericalHarmonicsProvider getNormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = this.readGravityField(degree, order);
        RawSphericalHarmonicsProvider provider = reader.getProvider(true, degree, order);
        return new WrappingNormalizedProvider(provider);
    }

    @Override
    public UnnormalizedSphericalHarmonicsProvider getConstantUnnormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = this.readGravityField(degree, order);
        ConstantSphericalHarmonics provider = reader.getConstantProvider(false, degree, order);
        return new WrappingUnnormalizedProvider(provider);
    }

    @Override
    public UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = this.readGravityField(degree, order);
        RawSphericalHarmonicsProvider provider = reader.getProvider(false, degree, order);
        return new WrappingUnnormalizedProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OceanTidesWave> getOceanTidesWaves(int degree, int order) {
        List<OceanTidesReader> list = this.oceanTidesReaders;
        synchronized (list) {
            if (this.oceanTidesReaders.isEmpty()) {
                this.addDefaultOceanTidesReaders();
            }
            for (OceanTidesReader reader : this.oceanTidesReaders) {
                reader.setMaxParseDegree(degree);
                reader.setMaxParseOrder(order);
                this.dataProvidersManager.feed(reader.getSupportedNames(), reader);
                if (reader.stillAcceptsData()) continue;
                return reader.getWaves();
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_OCEAN_TIDE_DATA_LOADED, new Object[0]);
    }
}

