/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldDateDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class ConstantThrustManeuver
extends AbstractForceModel {
    public static final String THRUST = "thrust";
    public static final String FLOW_RATE = "flow rate";
    private static final double THRUST_SCALE = FastMath.scalb(1.0, -5);
    private static final double FLOW_RATE_SCALE = FastMath.scalb(1.0, -12);
    private final ParameterDriver thrustDriver;
    private final ParameterDriver flowRateDriver;
    private final AbsoluteDate startDate;
    private final AbsoluteDate endDate;
    private final AttitudeProvider attitudeOverride;
    private final Vector3D direction;
    private final String name;
    private AbsoluteDate triggeredStart;
    private AbsoluteDate triggeredEnd;
    private boolean forward;

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction) {
        this(date, duration, thrust, isp, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction) {
        this(date, duration, thrust, isp, attitudeOverride, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction, String name) {
        this(date, duration, thrust, isp, null, direction, name);
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction, String name) {
        if (duration >= 0.0) {
            this.startDate = date;
            this.endDate = date.shiftedBy(duration);
        } else {
            this.endDate = date;
            this.startDate = this.endDate.shiftedBy(duration);
        }
        double flowRate = -thrust / (9.80665 * isp);
        this.attitudeOverride = attitudeOverride;
        this.direction = direction.normalize();
        this.name = name;
        this.triggeredStart = null;
        this.triggeredEnd = null;
        ParameterDriver tpd = null;
        ParameterDriver fpd = null;
        try {
            tpd = new ParameterDriver(name + THRUST, thrust, THRUST_SCALE, 0.0, Double.POSITIVE_INFINITY);
            fpd = new ParameterDriver(name + FLOW_RATE, flowRate, FLOW_RATE_SCALE, Double.NEGATIVE_INFINITY, 0.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.thrustDriver = tpd;
        this.flowRateDriver = fpd;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        AbsoluteDate sDate = s0.getDate();
        this.forward = sDate.compareTo(t) < 0;
        boolean isBetween = sDate.isBetween(this.startDate, this.endDate);
        boolean isOnStart = this.startDate.compareTo(sDate) == 0;
        boolean isOnEnd = this.endDate.compareTo(sDate) == 0;
        this.triggeredStart = null;
        this.triggeredEnd = null;
        if (this.forward) {
            if (isBetween || isOnStart) {
                this.triggeredStart = this.startDate;
            }
        } else if (isBetween || isOnEnd) {
            this.triggeredEnd = this.endDate;
        }
    }

    public double getThrust() {
        return this.thrustDriver.getValue();
    }

    public double getISP() {
        double thrust = this.getThrust();
        double flowRate = this.getFlowRate();
        return -thrust / (9.80665 * flowRate);
    }

    public double getFlowRate() {
        return this.flowRateDriver.getValue();
    }

    public Vector3D getDirection() {
        return this.direction;
    }

    public String getName() {
        return this.name;
    }

    public AbsoluteDate getStartDate() {
        return this.startDate;
    }

    public AbsoluteDate getEndDate() {
        return this.endDate;
    }

    public double getDuration() {
        return this.endDate.durationFrom(this.startDate);
    }

    public AttitudeProvider getAttitudeOverride() {
        return this.attitudeOverride;
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        if (this.isFiring(s)) {
            double[] parameters = this.getParameters();
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(parameters[1]);
        }
    }

    @Override
    public <T extends RealFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        if (this.isFiring(s)) {
            RealFieldElement[] parameters = this.getParameters(s.getDate().getField());
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(parameters[1]);
        }
    }

    @Override
    public Vector3D acceleration(SpacecraftState state, double[] parameters) {
        if (this.isFiring(state)) {
            double thrust = parameters[0];
            Attitude attitude = this.attitudeOverride == null ? state.getAttitude() : this.attitudeOverride.getAttitude(state.getOrbit(), state.getDate(), state.getFrame());
            return new Vector3D(thrust / state.getMass(), attitude.getRotation().applyInverseTo(this.direction));
        }
        return Vector3D.ZERO;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        if (this.isFiring(s)) {
            T thrust = parameters[0];
            FieldAttitude<T> attitude = this.attitudeOverride == null ? s.getAttitude() : this.attitudeOverride.getAttitude(s.getOrbit(), s.getDate(), s.getFrame());
            return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)s.getMass().reciprocal()).multiply(thrust), attitude.getRotation().applyInverseTo(this.direction));
        }
        return FieldVector3D.getZero(s.getMass().getField());
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        DateDetector startDetector = new DateDetector(this.startDate).withHandler((state, d, increasing) -> {
            this.triggeredStart = state.getDate();
            return Action.RESET_DERIVATIVES;
        });
        DateDetector endDetector = new DateDetector(this.endDate).withHandler((state, d, increasing) -> {
            this.triggeredEnd = state.getDate();
            return Action.RESET_DERIVATIVES;
        });
        return Stream.of(startDetector, endDetector);
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.thrustDriver, this.flowRateDriver};
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        FieldDateDetector startDetector = new FieldDateDetector(new FieldAbsoluteDate<T>(field, this.startDate)).withHandler((state, d, increasing) -> {
            this.triggeredStart = state.getDate().toAbsoluteDate();
            return Action.RESET_DERIVATIVES;
        });
        FieldDateDetector endDetector = new FieldDateDetector(new FieldAbsoluteDate<T>(field, this.endDate)).withHandler((state, d, increasing) -> {
            this.triggeredEnd = state.getDate().toAbsoluteDate();
            return Action.RESET_DERIVATIVES;
        });
        return Stream.of(startDetector, endDetector);
    }

    public boolean isFiring(SpacecraftState s) {
        return this.isFiring(s.getDate());
    }

    public <T extends RealFieldElement<T>> boolean isFiring(FieldSpacecraftState<T> s) {
        return this.isFiring(s.getDate().toAbsoluteDate());
    }

    public boolean isFiring(AbsoluteDate date) {
        if (this.forward) {
            if (this.triggeredStart == null) {
                return false;
            }
            if (date.durationFrom(this.triggeredStart) < 0.0) {
                return false;
            }
            if (this.triggeredEnd == null) {
                return true;
            }
            return date.durationFrom(this.triggeredEnd) < 0.0;
        }
        if (this.triggeredEnd == null) {
            return false;
        }
        if (date.durationFrom(this.triggeredEnd) > 0.0) {
            return false;
        }
        if (this.triggeredStart == null) {
            return true;
        }
        return date.durationFrom(this.triggeredStart) > 0.0;
    }
}

