/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class IsotropicRadiationSingleCoefficient
implements RadiationSensitive {
    private final double SCALE = FastMath.scalb(1.0, -3);
    private final ParameterDriver reflectionParameterDriver;
    private final double crossSection;

    public IsotropicRadiationSingleCoefficient(double crossSection, double cr) {
        this(crossSection, cr, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public IsotropicRadiationSingleCoefficient(double crossSection, double cr, double crMin, double crMax) {
        try {
            this.reflectionParameterDriver = new ParameterDriver("reflection coefficient", cr, this.SCALE, crMin, crMax);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.crossSection = crossSection;
    }

    @Override
    public ParameterDriver[] getRadiationParametersDrivers() {
        return new ParameterDriver[]{this.reflectionParameterDriver};
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters) {
        double cr = parameters[0];
        return new Vector3D(this.crossSection * cr / mass, flux);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, FieldVector3D<T> flux, T[] parameters) {
        T cr = parameters[0];
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)mass.reciprocal()).multiply(this.crossSection)).multiply(cr), flux);
    }
}

