/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.RealFieldElement;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.InterpolatingTransformProvider;
import org.orekit.frames.LazyLoadedFrames;
import org.orekit.frames.Predefined;
import org.orekit.frames.ShiftingTransformProvider;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.frames.VersionedITRF;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.IERSConventions;

public class FramesFactory {
    public static final String RAPID_DATA_PREDICTION_COLUMNS_1980_FILENAME = "^finals\\.[^.]*$";
    public static final String RAPID_DATA_PREDICTION_XML_1980_FILENAME = "^finals\\..*\\.xml$";
    public static final String EOPC04_1980_FILENAME = "^eopc04_\\d\\d\\.(\\d\\d)$";
    public static final String BULLETINB_1980_FILENAME = "^bulletinb(_IAU1980)?((-\\d\\d\\d\\.txt)|(\\.\\d\\d\\d))$";
    public static final String RAPID_DATA_PREDICITON_COLUMNS_2000_FILENAME = "^finals2000A\\.[^.]*$";
    public static final String RAPID_DATA_PREDICITON_XML_2000_FILENAME = "^finals2000A\\..*\\.xml$";
    public static final String EOPC04_2000_FILENAME = "^eopc04_\\d\\d_IAU2000\\.(\\d\\d)$";
    public static final String BULLETINB_2000_FILENAME = "^bulletinb(_IAU2000)?((-\\d\\d\\d\\.txt)|(\\.\\d\\d\\d))$";
    public static final String BULLETINA_FILENAME = "^bulletina-[ivxlcdm]+-\\d\\d\\d\\.txt$";

    private FramesFactory() {
    }

    @DefaultDataContext
    public static LazyLoadedFrames getFrames() {
        return DataContext.getDefault().getFrames();
    }

    @DefaultDataContext
    public static void addDefaultEOP1980HistoryLoaders(String rapidDataColumnsSupportedNames, String rapidDataXMLSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames) {
        FramesFactory.getFrames().addDefaultEOP1980HistoryLoaders(rapidDataColumnsSupportedNames, rapidDataXMLSupportedNames, eopC04SupportedNames, bulletinBSupportedNames, bulletinASupportedNames);
    }

    @DefaultDataContext
    public static void addDefaultEOP2000HistoryLoaders(String rapidDataColumnsSupportedNames, String rapidDataXMLSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames) {
        FramesFactory.getFrames().addDefaultEOP2000HistoryLoaders(rapidDataColumnsSupportedNames, rapidDataXMLSupportedNames, eopC04SupportedNames, bulletinBSupportedNames, bulletinASupportedNames);
    }

    @DefaultDataContext
    public static void addEOPHistoryLoader(IERSConventions conventions, EOPHistoryLoader loader) {
        FramesFactory.getFrames().addEOPHistoryLoader(conventions, loader);
    }

    @DefaultDataContext
    public static void clearEOPHistoryLoaders() {
        FramesFactory.getFrames().clearEOPHistoryLoaders();
    }

    @DefaultDataContext
    public static void setEOPContinuityThreshold(double threshold) {
        FramesFactory.getFrames().setEOPContinuityThreshold(threshold);
    }

    @DefaultDataContext
    public static EOPHistory getEOPHistory(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getEOPHistory(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static Frame getFrame(Predefined factoryKey) {
        return FramesFactory.getFrames().getFrame(factoryKey);
    }

    @DefaultDataContext
    public static Frame getGCRF() {
        return FramesFactory.getFrames().getGCRF();
    }

    @DefaultDataContext
    public static Frame getICRF() {
        return FramesFactory.getFrames().getICRF();
    }

    @DefaultDataContext
    public static Frame getEcliptic(IERSConventions conventions) {
        return FramesFactory.getFrames().getEcliptic(conventions);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getEME2000() {
        return FramesFactory.getFrames().getEME2000();
    }

    @DefaultDataContext
    public static FactoryManagedFrame getITRF(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getITRF(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getTIRF(IERSConventions conventions) {
        return FramesFactory.getFrames().getTIRF(conventions);
    }

    @DefaultDataContext
    public static VersionedITRF getITRF(ITRFVersion version, IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getITRF(version, conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getTIRF(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getTIRF(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getCIRF(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getCIRF(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getVeis1950() {
        return FramesFactory.getFrames().getVeis1950();
    }

    @DefaultDataContext
    public static FactoryManagedFrame getITRFEquinox(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getITRFEquinox(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getGTOD(boolean applyEOPCorr) {
        return FramesFactory.getFrames().getGTOD(applyEOPCorr);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getGTOD(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getGTOD(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getTOD(boolean applyEOPCorr) {
        return FramesFactory.getFrames().getTOD(applyEOPCorr);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getTOD(IERSConventions conventions, boolean simpleEOP) {
        return FramesFactory.getFrames().getTOD(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getMOD(boolean applyEOPCorr) {
        return FramesFactory.getFrames().getMOD(applyEOPCorr);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getMOD(IERSConventions conventions) {
        return FramesFactory.getFrames().getMOD(conventions);
    }

    @DefaultDataContext
    public static FactoryManagedFrame getTEME() {
        return FramesFactory.getFrames().getTEME();
    }

    @DefaultDataContext
    public static FactoryManagedFrame getPZ9011(IERSConventions convention, boolean simpleEOP) {
        return FramesFactory.getFrames().getPZ9011(convention, simpleEOP);
    }

    public static Transform getNonInterpolatingTransform(Frame from, Frame to, AbsoluteDate date) {
        Frame currentF;
        Frame currentT;
        Frame frame = currentT = from.getDepth() > to.getDepth() ? to : to.getAncestor(to.getDepth() - from.getDepth());
        for (currentF = from.getDepth() > to.getDepth() ? from.getAncestor(from.getDepth() - to.getDepth()) : from; currentF != currentT; currentF = currentF.getParent(), currentT = currentT.getParent()) {
        }
        Frame common = currentF;
        Transform commonToOrigin = Transform.IDENTITY;
        for (Frame frame2 = from; frame2 != common; frame2 = frame2.getParent()) {
            commonToOrigin = new Transform(date, FramesFactory.peel(frame2.getTransformProvider()).getTransform(date), commonToOrigin);
        }
        Transform commonToDestination = Transform.IDENTITY;
        for (Frame frame3 = to; frame3 != common; frame3 = frame3.getParent()) {
            commonToDestination = new Transform(date, FramesFactory.peel(frame3.getTransformProvider()).getTransform(date), commonToDestination);
        }
        return new Transform(date, commonToOrigin.getInverse(), commonToDestination);
    }

    public static <T extends RealFieldElement<T>> FieldTransform<T> getNonInterpolatingTransform(Frame from, Frame to, FieldAbsoluteDate<T> date) {
        Frame currentF;
        Frame currentT;
        Frame frame = currentT = from.getDepth() > to.getDepth() ? to : to.getAncestor(to.getDepth() - from.getDepth());
        for (currentF = from.getDepth() > to.getDepth() ? from.getAncestor(from.getDepth() - to.getDepth()) : from; currentF != currentT; currentF = currentF.getParent(), currentT = currentT.getParent()) {
        }
        Frame common = currentF;
        FieldTransform<T> commonToOrigin = FieldTransform.getIdentity(date.getField());
        for (Frame frame2 = from; frame2 != common; frame2 = frame2.getParent()) {
            commonToOrigin = new FieldTransform<T>(date, FramesFactory.peel(frame2.getTransformProvider()).getTransform(date), commonToOrigin);
        }
        FieldTransform<T> commonToDestination = FieldTransform.getIdentity(date.getField());
        for (Frame frame3 = to; frame3 != common; frame3 = frame3.getParent()) {
            commonToDestination = new FieldTransform<T>(date, FramesFactory.peel(frame3.getTransformProvider()).getTransform(date), commonToDestination);
        }
        return new FieldTransform<T>(date, commonToOrigin.getInverse(), commonToDestination);
    }

    public static EOPHistory findEOP(Frame start) {
        for (Frame frame = start; frame != null; frame = frame.getParent()) {
            TransformProvider peeled = frame.getTransformProvider();
            boolean peeling = true;
            while (peeling) {
                if (peeled instanceof InterpolatingTransformProvider) {
                    peeled = ((InterpolatingTransformProvider)peeled).getRawProvider();
                    continue;
                }
                if (peeled instanceof ShiftingTransformProvider) {
                    peeled = ((ShiftingTransformProvider)peeled).getRawProvider();
                    continue;
                }
                if (peeled instanceof EOPBasedTransformProvider && ((EOPBasedTransformProvider)peeled).getEOPHistory() != null) {
                    return ((EOPBasedTransformProvider)peeled).getEOPHistory();
                }
                peeling = false;
            }
        }
        return null;
    }

    private static TransformProvider peel(TransformProvider provider) {
        TransformProvider peeled = provider;
        boolean peeling = true;
        while (peeling) {
            if (peeled instanceof InterpolatingTransformProvider) {
                peeled = ((InterpolatingTransformProvider)peeled).getRawProvider();
                continue;
            }
            if (peeled instanceof ShiftingTransformProvider) {
                peeled = ((ShiftingTransformProvider)peeled).getRawProvider();
                continue;
            }
            if (peeled instanceof EOPBasedTransformProvider && ((EOPBasedTransformProvider)peeled).getEOPHistory() != null && ((EOPBasedTransformProvider)peeled).getEOPHistory().usesInterpolation()) {
                peeled = ((EOPBasedTransformProvider)peeled).getNonInterpolatingProvider();
                continue;
            }
            peeling = false;
        }
        return peeled;
    }
}

