/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScales;
import org.orekit.time.UTCScale;
import org.orekit.utils.IERSConventions;

public class GTODProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20141228L;
    private static final double AVE = 7.292115146706979E-5;
    private final IERSConventions conventions;
    private final EOPHistory eopHistory;
    private final transient TimeScalarFunction gastFunction;

    @Deprecated
    @DefaultDataContext
    protected GTODProvider(IERSConventions conventions, EOPHistory eopHistory) {
        this(conventions, eopHistory, eopHistory == null ? DataContext.getDefault().getTimeScales() : eopHistory.getTimeScales());
    }

    protected GTODProvider(IERSConventions conventions, EOPHistory eopHistory, TimeScales timeScales) {
        UTCScale ut1 = eopHistory == null ? timeScales.getUTC() : timeScales.getUT1(eopHistory.getConventions(), eopHistory.isSimpleEop());
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.gastFunction = conventions.getGASTFunction(ut1, eopHistory, timeScales);
    }

    private GTODProvider(IERSConventions conventions, EOPHistory eopHistory, TimeScalarFunction gastFunction) {
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.gastFunction = gastFunction;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public GTODProvider getNonInterpolatingProvider() {
        return new GTODProvider(this.conventions, this.eopHistory.getNonInterpolatingEOPHistory(), this.gastFunction);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double gast = this.gastFunction.value(date);
        double lod = this.eopHistory == null ? 0.0 : this.eopHistory.getLOD(date);
        double omp = 7.292115146706979E-5 * (1.0 - lod / 86400.0);
        Vector3D rotationRate = new Vector3D(omp, Vector3D.PLUS_K);
        return new Transform(date, new Rotation(Vector3D.PLUS_K, gast, RotationConvention.FRAME_TRANSFORM), rotationRate);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T gast = this.gastFunction.value(date);
        RealFieldElement lod = this.eopHistory == null ? (RealFieldElement)date.getField().getZero() : this.eopHistory.getLOD(date);
        RealFieldElement omp = (RealFieldElement)((RealFieldElement)((RealFieldElement)lod.multiply(-1.1574074074074073E-5)).add(1.0)).multiply(7.292115146706979E-5);
        FieldVector3D<RealFieldElement> rotationRate = new FieldVector3D<RealFieldElement>((RealFieldElement)date.getField().getZero(), (RealFieldElement)date.getField().getZero(), ((RealFieldElement)date.getField().getZero()).add(omp));
        return new FieldTransform<RealFieldElement>(date, new FieldRotation<T>(FieldVector3D.getPlusK(date.getField()), gast, RotationConvention.FRAME_TRANSFORM), rotationRate);
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.eopHistory);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final EOPHistory eopHistory;

        DataTransferObject(IERSConventions conventions, EOPHistory eopHistory) {
            this.conventions = conventions;
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new GTODProvider(this.conventions, this.eopHistory, DataContext.getDefault().getTimeScales());
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

