/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public class HelmertTransformation
implements TransformProvider {
    private static final long serialVersionUID = -1900615992141291146L;
    private final PVCoordinates cartesian;
    private final Vector3D rotationVector;
    private final Vector3D rotationRate;
    private final AbsoluteDate epoch;

    public HelmertTransformation(AbsoluteDate epoch, double t1, double t2, double t3, double r1, double r2, double r3, double t1Dot, double t2Dot, double t3Dot, double r1Dot, double r2Dot, double r3Dot) {
        double mmToM = 0.001;
        double masToRad = 4.84813681109536E-9;
        this.epoch = epoch;
        this.cartesian = new PVCoordinates(new Vector3D(t1 * 0.001, t2 * 0.001, t3 * 0.001), new Vector3D(t1Dot * 0.001 / 3.15576E7, t2Dot * 0.001 / 3.15576E7, t3Dot * 0.001 / 3.15576E7));
        this.rotationVector = new Vector3D(r1 * 4.84813681109536E-9, r2 * 4.84813681109536E-9, r3 * 4.84813681109536E-9);
        this.rotationRate = new Vector3D(r1Dot * 4.84813681109536E-9 / 3.15576E7, r2Dot * 4.84813681109536E-9 / 3.15576E7, r3Dot * 4.84813681109536E-9 / 3.15576E7);
    }

    private HelmertTransformation(PVCoordinates cartesian, Vector3D rotationVector, Vector3D rotationRate, AbsoluteDate epoch) {
        this.cartesian = cartesian;
        this.rotationVector = rotationVector;
        this.rotationRate = rotationRate;
        this.epoch = epoch;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double dt = date.durationFrom(this.epoch);
        Vector3D dR = new Vector3D(1.0, this.rotationVector, dt, this.rotationRate);
        Transform translationTransform = new Transform(date, this.cartesian.shiftedBy(dt));
        double angle = dR.getNorm();
        Transform rotationTransform = new Transform(date, angle < Precision.SAFE_MIN ? Rotation.IDENTITY : new Rotation(dR, angle, RotationConvention.VECTOR_OPERATOR), this.rotationRate);
        return new Transform(date, translationTransform, rotationTransform);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T dt = date.durationFrom(this.epoch);
        FieldVector3D<RealFieldElement> dR = new FieldVector3D<RealFieldElement>((RealFieldElement)date.getField().getOne(), this.rotationVector, (RealFieldElement)dt, this.rotationRate);
        FieldTransform<Field<T>> translationTransform = new FieldTransform<Field<T>>(date, new FieldPVCoordinates<Field<T>>(date.getField(), this.cartesian).shiftedBy((Field<T>)dt));
        RealFieldElement angle = dR.getNorm();
        FieldTransform<T> rotationTransform = new FieldTransform<T>(date, angle.getReal() < Precision.SAFE_MIN ? FieldRotation.getIdentity(date.getField()) : new FieldRotation<T>(dR, (RealFieldElement)angle, RotationConvention.VECTOR_OPERATOR), new FieldVector3D<T>(date.getField(), this.rotationRate));
        return new FieldTransform<Field<T>>(date, translationTransform, rotationTransform);
    }

    private static class HelmertTransformationWithoutTimeScale {
        private final PVCoordinates cartesian;
        private final Vector3D rotationVector;
        private final Vector3D rotationRate;
        private final DateTimeComponents epoch;

        HelmertTransformationWithoutTimeScale(DateTimeComponents epoch, double t1, double t2, double t3, double r1, double r2, double r3, double t1Dot, double t2Dot, double t3Dot, double r1Dot, double r2Dot, double r3Dot) {
            double mmToM = 0.001;
            double masToRad = 4.84813681109536E-9;
            this.epoch = epoch;
            this.cartesian = new PVCoordinates(new Vector3D(t1 * 0.001, t2 * 0.001, t3 * 0.001), new Vector3D(t1Dot * 0.001 / 3.15576E7, t2Dot * 0.001 / 3.15576E7, t3Dot * 0.001 / 3.15576E7));
            this.rotationVector = new Vector3D(r1 * 4.84813681109536E-9, r2 * 4.84813681109536E-9, r3 * 4.84813681109536E-9);
            this.rotationRate = new Vector3D(r1Dot * 4.84813681109536E-9 / 3.15576E7, r2Dot * 4.84813681109536E-9 / 3.15576E7, r3Dot * 4.84813681109536E-9 / 3.15576E7);
        }

        public HelmertTransformation withTimeScale(TimeScale tt) {
            return new HelmertTransformation(this.cartesian, this.rotationVector, this.rotationRate, new AbsoluteDate(this.epoch, tt));
        }
    }

    public static enum Predefined {
        ITRF_2014_TO_ITRF_2008(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_2008, 2010, 1.6, 1.9, 2.4, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0),
        ITRF_2014_TO_ITRF_2005(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_2005, 2010, 2.6, 1.0, -2.3, 0.0, 0.0, 0.0, 0.3, 0.0, -0.1, 0.0, 0.0, 0.0),
        ITRF_2014_TO_ITRF_2000(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_2000, 2010, 0.7, 1.2, -26.1, 0.0, 0.0, 0.0, 0.1, 0.1, -1.9, 0.0, 0.0, 0.0),
        ITRF_2014_TO_ITRF_97(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_97, 2010, 7.4, -0.5, -62.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_96(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_96, 2010, 7.4, -0.5, -62.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_94(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_94, 2010, 7.4, -0.5, -62.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_93(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_93, 2010, -50.4, 3.3, -60.2, -2.81, -3.38, 0.4, -2.8, -0.1, -2.5, -0.11, -0.19, 0.07),
        ITRF_2014_TO_ITRF_92(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_92, 2010, 15.4, 1.5, -70.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_91(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_91, 2010, 27.4, 15.5, -76.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_90(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_90, 2010, 25.4, 11.5, -92.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_89(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_89, 2010, 30.4, 35.5, -130.8, 0.0, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2014_TO_ITRF_88(ITRFVersion.ITRF_2014, ITRFVersion.ITRF_88, 2010, 25.4, -0.5, -154.8, 0.1, 0.0, 0.26, 0.1, -0.5, -3.3, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_2005(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_2005, 2000, -2.0, -0.9, -4.7, 0.0, 0.0, 0.0, 0.3, 0.0, 0.0, 0.0, 0.0, 0.0),
        ITRF_2008_TO_ITRF_2000(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_2000, 2000, -1.9, -1.7, -10.5, 0.0, 0.0, 0.0, 0.1, 0.1, -1.8, 0.0, 0.0, 0.0),
        ITRF_2008_TO_ITRF_97(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_97, 2000, 4.8, 2.6, -33.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_96(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_96, 2000, 4.8, 2.6, -33.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_94(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_94, 2000, 4.8, 2.6, -33.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_93(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_93, 2000, -24.0, 2.4, -38.6, -1.71, -1.48, -0.3, -2.8, -0.1, -2.4, -0.11, -0.19, 0.07),
        ITRF_2008_TO_ITRF_92(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_92, 2000, 12.8, 4.6, -41.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_91(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_91, 2000, 24.8, 18.6, -47.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_90(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_90, 2000, 22.8, 14.6, -63.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_89(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_89, 2000, 27.8, 38.6, -101.2, 0.0, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02),
        ITRF_2008_TO_ITRF_88(ITRFVersion.ITRF_2008, ITRFVersion.ITRF_88, 2000, 22.8, 2.6, -125.2, 0.1, 0.0, 0.06, 0.1, -0.5, -3.2, 0.0, 0.0, 0.02);

        private final ITRFVersion origin;
        private final ITRFVersion destination;
        private final transient HelmertTransformationWithoutTimeScale transformation;

        private Predefined(ITRFVersion origin, ITRFVersion destination, int refYear, double t1, double t2, double t3, double r1, double r2, double r3, double t1Dot, double t2Dot, double t3Dot, double r1Dot, double r2Dot, double r3Dot) {
            this.origin = origin;
            this.destination = destination;
            this.transformation = new HelmertTransformationWithoutTimeScale(new DateTimeComponents(refYear, 1, 1, 12, 0, 0.0), t1, t2, t3, r1, r2, r3, t1Dot, t2Dot, t3Dot, r1Dot, r2Dot, r3Dot);
        }

        public ITRFVersion getOrigin() {
            return this.origin;
        }

        public ITRFVersion getDestination() {
            return this.destination;
        }

        @DefaultDataContext
        public HelmertTransformation getTransformation() {
            return this.getTransformation(DataContext.getDefault().getTimeScales().getTT());
        }

        public HelmertTransformation getTransformation(TimeScale tt) {
            return this.transformation.withTimeScale(tt);
        }

        @DefaultDataContext
        public Frame createTransformedITRF(Frame parent, String name) {
            return this.createTransformedITRF(parent, name, DataContext.getDefault().getTimeScales().getTT());
        }

        public Frame createTransformedITRF(Frame parent, String name, TimeScale tt) {
            return new Frame(parent, this.getTransformation(tt), name);
        }
    }
}

