/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeVectorFunction;
import org.orekit.utils.IERSConventions;

class MODProvider
implements TransformProvider {
    private static final long serialVersionUID = 20130920L;
    private final IERSConventions conventions;
    private final transient TimeVectorFunction precessionFunction;
    private final Rotation r4;
    private final transient Map<Field<? extends RealFieldElement<?>>, FieldRotation<? extends RealFieldElement<?>>> fieldR4;

    MODProvider(IERSConventions conventions, TimeScales timeScales) {
        this.conventions = conventions;
        this.precessionFunction = conventions.getPrecessionFunction(timeScales);
        TimeScalarFunction epsilonAFunction = conventions.getMeanObliquityFunction(timeScales);
        AbsoluteDate date0 = conventions.getNutationReferenceEpoch(timeScales);
        double epsilon0 = epsilonAFunction.value(date0);
        this.r4 = new Rotation(Vector3D.PLUS_I, epsilon0, RotationConvention.FRAME_TRANSFORM);
        this.fieldR4 = new HashMap();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double[] angles = this.precessionFunction.value(date);
        Rotation precession = this.r4.compose(new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, -angles[0], -angles[1], angles[2]), RotationConvention.FRAME_TRANSFORM);
        return new Transform(date, precession);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        RealFieldElement[] angles = this.precessionFunction.value(date);
        FieldRotation<RealFieldElement<Object>> fR4 = this.fieldR4.get(date.getField());
        if (fR4 == null) {
            fR4 = new FieldRotation<T>(date.getField(), this.r4);
            this.fieldR4.put(date.getField(), fR4);
        }
        FieldRotation<RealFieldElement> precession = fR4.compose(new FieldRotation<RealFieldElement>(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, (RealFieldElement)angles[0].negate(), (RealFieldElement)angles[1].negate(), angles[2]), RotationConvention.FRAME_TRANSFORM);
        return new FieldTransform<RealFieldElement>(date, precession);
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.conventions);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;

        DataTransferObject(IERSConventions conventions) {
            this.conventions = conventions;
        }

        private Object readResolve() {
            try {
                return new MODProvider(this.conventions, DataContext.getDefault().getTimeScales());
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

