/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FixedTransformProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;

public class OrphanFrame
implements Serializable {
    private static final long serialVersionUID = 20130409L;
    private final String name;
    private final List<OrphanFrame> children = new ArrayList<OrphanFrame>();
    private OrphanFrame orphanParent;
    private TransformProvider provider;
    private boolean pseudoInertial;
    private Frame frame;

    public OrphanFrame(String name) {
        this.name = name;
    }

    public void addChild(OrphanFrame child, Transform transform, boolean isPseudoInertial) {
        this.addChild(child, new FixedTransformProvider(transform), isPseudoInertial);
    }

    public void addChild(OrphanFrame child, TransformProvider transformProvider, boolean isPseudoInertial) {
        if (child.orphanParent != null) {
            throw new OrekitException((Localizable)OrekitMessages.FRAME_ALREADY_ATTACHED, child.name, child.orphanParent.name);
        }
        this.children.add(child);
        child.orphanParent = this;
        child.provider = transformProvider;
        child.pseudoInertial = isPseudoInertial;
        if (this.frame != null) {
            this.buildTree();
        }
    }

    public void attachTo(Frame parent, Transform transform, boolean isPseudoInertial) {
        this.attachTo(parent, new FixedTransformProvider(transform), isPseudoInertial);
    }

    public void attachTo(Frame parent, TransformProvider transformProvider, boolean isPseudoInertial) {
        if (this.orphanParent != null) {
            throw new OrekitException((Localizable)OrekitMessages.FRAME_ALREADY_ATTACHED, this.name, this.orphanParent.name);
        }
        OrphanFrame op = new OrphanFrame(parent.getName());
        op.frame = parent;
        op.addChild(this, transformProvider, isPseudoInertial);
    }

    public List<OrphanFrame> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Frame getFrame() {
        if (this.frame == null) {
            throw new OrekitException((Localizable)OrekitMessages.FRAME_NOT_ATTACHED, this.name);
        }
        return this.frame;
    }

    private void buildTree() {
        for (OrphanFrame child : this.children) {
            if (child.frame != null) continue;
            child.frame = new Frame(this.frame, child.provider, child.name, child.pseudoInertial);
            child.buildTree();
        }
    }

    public String toString() {
        return this.name;
    }
}

