/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScale;

class TIRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20130919L;
    private static final double AVE = 7.292115146706979E-5;
    private final EOPHistory eopHistory;
    private final transient TimeScale ut1;
    private final transient TimeScalarFunction era;

    protected TIRFProvider(EOPHistory eopHistory, TimeScale ut1) {
        this.ut1 = ut1;
        this.eopHistory = eopHistory;
        this.era = eopHistory.getConventions().getEarthOrientationAngleFunction(ut1, eopHistory.getTimeScales().getTAI());
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public TIRFProvider getNonInterpolatingProvider() {
        return new TIRFProvider(this.eopHistory.getNonInterpolatingEOPHistory(), this.ut1);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double correctedERA = this.era.value(date);
        double lod = this.eopHistory == null ? 0.0 : this.eopHistory.getLOD(date);
        double omp = 7.292115146706979E-5 * (1.0 - lod / 86400.0);
        Vector3D rotationRate = new Vector3D(omp, Vector3D.PLUS_K);
        Rotation rotation = new Rotation(Vector3D.PLUS_K, correctedERA, RotationConvention.FRAME_TRANSFORM);
        return new Transform(date, rotation, rotationRate);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T correctedERA = this.era.value(date);
        RealFieldElement lod = this.eopHistory == null ? (RealFieldElement)date.getField().getZero() : this.eopHistory.getLOD(date);
        RealFieldElement omp = (RealFieldElement)((RealFieldElement)((RealFieldElement)lod.divide(86400.0)).subtract(1.0)).multiply(-7.292115146706979E-5);
        FieldVector3D<RealFieldElement> rotationRate = new FieldVector3D<RealFieldElement>(omp, Vector3D.PLUS_K);
        FieldRotation<T> rotation = new FieldRotation<T>(FieldVector3D.getPlusK(date.getField()), correctedERA, RotationConvention.FRAME_TRANSFORM);
        return new FieldTransform<RealFieldElement>(date, rotation, rotationRate);
    }

    public double getEarthRotationAngle(AbsoluteDate date) {
        return MathUtils.normalizeAngle(this.era.value(date), 0.0);
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.eopHistory);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final EOPHistory eopHistory;

        DataTransferObject(EOPHistory eopHistory) {
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TIRFProvider(this.eopHistory, DataContext.getDefault().getTimeScales().getUT1(this.eopHistory));
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

