/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TopocentricFrame
extends Frame
implements PVCoordinatesProvider {
    private static final long serialVersionUID = -5997915708080966466L;
    private final BodyShape parentShape;
    private final GeodeticPoint point;

    public TopocentricFrame(BodyShape parentShape, GeodeticPoint point, String name) {
        super(parentShape.getBodyFrame(), new Transform(AbsoluteDate.ARBITRARY_EPOCH, new Transform(AbsoluteDate.ARBITRARY_EPOCH, parentShape.transform(point).negate()), new Transform(AbsoluteDate.ARBITRARY_EPOCH, new Rotation(point.getEast(), point.getZenith(), Vector3D.PLUS_I, Vector3D.PLUS_K), Vector3D.ZERO)), name, false);
        this.parentShape = parentShape;
        this.point = point;
    }

    public BodyShape getParentShape() {
        return this.parentShape;
    }

    public GeodeticPoint getPoint() {
        return this.point;
    }

    public <T extends RealFieldElement<T>> FieldGeodeticPoint<T> getPoint(Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        return new FieldGeodeticPoint<RealFieldElement>((RealFieldElement)zero.add(this.point.getLatitude()), (RealFieldElement)zero.add(this.point.getLongitude()), (RealFieldElement)zero.add(this.point.getAltitude()));
    }

    public Vector3D getZenith() {
        return this.point.getZenith();
    }

    public Vector3D getNadir() {
        return this.point.getNadir();
    }

    public Vector3D getNorth() {
        return this.point.getNorth();
    }

    public Vector3D getSouth() {
        return this.point.getSouth();
    }

    public Vector3D getEast() {
        return this.point.getEast();
    }

    public Vector3D getWest() {
        return this.point.getWest();
    }

    public double getElevation(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Transform t = frame.getTransformTo((Frame)this, date);
        Vector3D extPointTopo = t.transformPosition(extPoint);
        return extPointTopo.getDelta();
    }

    public <T extends RealFieldElement<T>> T getElevation(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldTransform<T> t = frame.getTransformTo((Frame)this, date);
        FieldVector3D<T> extPointTopo = t.transformPosition(extPoint);
        return extPointTopo.getDelta();
    }

    public double getAzimuth(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Transform t = this.getTransformTo(frame, date).getInverse();
        Vector3D extPointTopo = t.transformPosition(extPoint);
        double azimuth = FastMath.atan2(extPointTopo.getX(), extPointTopo.getY());
        if (azimuth < 0.0) {
            azimuth += Math.PI * 2;
        }
        return azimuth;
    }

    public <T extends RealFieldElement<T>> T getAzimuth(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldTransform<T> t = this.getTransformTo(frame, date).getInverse();
        FieldVector3D<T> extPointTopo = t.transformPosition(extPoint);
        Object azimuth = FastMath.atan2(extPointTopo.getX(), extPointTopo.getY());
        if (azimuth.getReal() < 0.0) {
            azimuth = (RealFieldElement)azimuth.add(Math.PI * 2);
        }
        return azimuth;
    }

    public double getRange(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Transform t = frame.getTransformTo((Frame)this, date);
        Vector3D extPointTopo = t.transformPosition(extPoint);
        return extPointTopo.getNorm();
    }

    public <T extends RealFieldElement<T>> T getRange(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldTransform<T> t = frame.getTransformTo((Frame)this, date);
        FieldVector3D<T> extPointTopo = t.transformPosition(extPoint);
        return extPointTopo.getNorm();
    }

    public double getRangeRate(PVCoordinates extPV, Frame frame, AbsoluteDate date) {
        Transform t = frame.getTransformTo((Frame)this, date);
        PVCoordinates extPVTopo = t.transformPVCoordinates(extPV);
        return Vector3D.dotProduct(extPVTopo.getPosition(), extPVTopo.getVelocity()) / extPVTopo.getPosition().getNorm();
    }

    public <T extends RealFieldElement<T>> T getRangeRate(FieldPVCoordinates<T> extPV, Frame frame, FieldAbsoluteDate<T> date) {
        FieldTransform<T> t = frame.getTransformTo((Frame)this, date);
        FieldPVCoordinates<T> extPVTopo = t.transformPVCoordinates(extPV);
        return (T)((RealFieldElement)FieldVector3D.dotProduct(extPVTopo.getPosition(), extPVTopo.getVelocity()).divide(extPVTopo.getPosition().getNorm()));
    }

    public GeodeticPoint computeLimitVisibilityPoint(final double radius, final double azimuth, final double elevation) {
        try {
            double deltaP = 0.001;
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.567855942887398E-10, 0.001, 0.001, 5);
            double distance = solver.solve(1000, new UnivariateFunction(){

                @Override
                public double value(double x) {
                    GeodeticPoint gp = TopocentricFrame.this.pointAtDistance(azimuth, elevation, x);
                    return TopocentricFrame.this.parentShape.transform(gp).getNorm() - radius;
                }
            }, 0.0, 2.0 * radius);
            return this.pointAtDistance(azimuth, elevation, distance);
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public GeodeticPoint pointAtDistance(double azimuth, double elevation, double distance) {
        double cosAz = FastMath.cos(azimuth);
        double sinAz = FastMath.sin(azimuth);
        double cosEl = FastMath.cos(elevation);
        double sinEl = FastMath.sin(elevation);
        Vector3D observed = new Vector3D(distance * cosEl * sinAz, distance * cosEl * cosAz, distance * sinEl);
        return this.parentShape.transform(observed, (Frame)this, AbsoluteDate.ARBITRARY_EPOCH);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.getTransformTo(frame, date).transformPVCoordinates(new TimeStampedPVCoordinates(date, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
    }
}

