/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.geometry.fov;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.geometry.fov.SmoothFieldOfView;
import org.orekit.propagation.events.VisibilityTrigger;

public class CircularFieldOfView
extends SmoothFieldOfView {
    private final double halfAperture;
    private final Vector3D scaledX;
    private final Vector3D scaledY;
    private final Vector3D scaledZ;

    public CircularFieldOfView(Vector3D center, double halfAperture, double margin) {
        super(center, center.orthogonal(), margin);
        this.halfAperture = halfAperture;
        SinCos sc = FastMath.sinCos(halfAperture);
        this.scaledX = new Vector3D(sc.sin(), this.getX());
        this.scaledY = new Vector3D(sc.sin(), this.getY());
        this.scaledZ = new Vector3D(sc.cos(), this.getZ());
    }

    public double getHalfAperture() {
        return this.halfAperture;
    }

    @Override
    public double offsetFromBoundary(Vector3D lineOfSight, double angularRadius, VisibilityTrigger trigger) {
        return Vector3D.angle(this.getCenter(), lineOfSight) - this.halfAperture + trigger.radiusCorrection(angularRadius) - this.getMargin();
    }

    @Override
    public Vector3D projectToBoundary(Vector3D lineOfSight) {
        return this.directionAt(FastMath.atan2(Vector3D.dotProduct(lineOfSight, this.getY()), Vector3D.dotProduct(lineOfSight, this.getX())));
    }

    @Override
    protected Vector3D directionAt(double angle) {
        SinCos sc = FastMath.sinCos(angle);
        return new Vector3D(sc.cos(), this.scaledX, sc.sin(), this.scaledY, 1.0, this.scaledZ);
    }
}

