/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.geometry.fov;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.geometry.fov.PolygonalFieldOfView;

public class DoubleDihedraFieldOfView
extends PolygonalFieldOfView {
    public DoubleDihedraFieldOfView(Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2, double margin) {
        super(DoubleDihedraFieldOfView.createPolygon(center, axis1, halfAperture1, axis2, halfAperture2), margin);
    }

    private static SphericalPolygonsSet createPolygon(Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2) {
        RegionFactory<Sphere2D> factory = new RegionFactory<Sphere2D>();
        double tolerance = FastMath.max(FastMath.ulp(Math.PI * 2), 1.0E-12 * FastMath.max(halfAperture1, halfAperture2));
        Region<Sphere2D> dihedra1 = DoubleDihedraFieldOfView.buildDihedra(factory, tolerance, center, axis1, halfAperture1);
        Region<Sphere2D> dihedra2 = DoubleDihedraFieldOfView.buildDihedra(factory, tolerance, center, axis2, halfAperture2);
        return (SphericalPolygonsSet)factory.intersection(dihedra1, dihedra2);
    }

    private static Region<Sphere2D> buildDihedra(RegionFactory<Sphere2D> factory, double tolerance, Vector3D center, Vector3D axis, double halfAperture) {
        if (halfAperture > 1.5707963267948966) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, halfAperture, 0.0, 1.5707963267948966);
        }
        Rotation r = new Rotation(axis, halfAperture, RotationConvention.VECTOR_OPERATOR);
        Vector3D normalCenterPlane = Vector3D.crossProduct(axis, center);
        Vector3D normalSidePlus = r.applyInverseTo(normalCenterPlane);
        Vector3D normalSideMinus = r.applyTo(normalCenterPlane.negate());
        return factory.intersection(new SphericalPolygonsSet(normalSidePlus, tolerance), new SphericalPolygonsSet(normalSideMinus, tolerance));
    }
}

