/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.geometry.fov;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.geometry.fov.AbstractFieldOfView;
import org.orekit.propagation.events.VisibilityTrigger;

public abstract class SmoothFieldOfView
extends AbstractFieldOfView {
    private final Vector3D center;
    private final Vector3D xAxis;
    private final Vector3D yAxis;
    private final Vector3D zAxis;

    protected SmoothFieldOfView(Vector3D center, Vector3D primaryMeridian, double margin) {
        super(margin);
        this.center = center;
        this.zAxis = center.normalize();
        this.yAxis = Vector3D.crossProduct(center, primaryMeridian).normalize();
        this.xAxis = Vector3D.crossProduct(this.yAxis, center).normalize();
    }

    public Vector3D getCenter() {
        return this.center;
    }

    public Vector3D getX() {
        return this.xAxis;
    }

    public Vector3D getY() {
        return this.yAxis;
    }

    public Vector3D getZ() {
        return this.zAxis;
    }

    @Override
    public List<List<GeodeticPoint>> getFootprint(Transform fovToBody, OneAxisEllipsoid body, double angularStep) {
        Frame bodyFrame = body.getBodyFrame();
        Vector3D position = fovToBody.transformPosition(Vector3D.ZERO);
        double r = position.getNorm();
        if (body.isInside(position)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        boolean intersectionsFound = false;
        int nbPoints = (int)FastMath.ceil(Math.PI * 2 / angularStep);
        ArrayList<GeodeticPoint> loop = new ArrayList<GeodeticPoint>(nbPoints);
        double step = Math.PI * 2 / (double)nbPoints;
        for (int i = 0; i < nbPoints; ++i) {
            Vector3D direction = this.directionAt((double)(-i) * step);
            Vector3D awaySC = new Vector3D(r, direction);
            Vector3D awayBody = fovToBody.transformPosition(awaySC);
            Line lineOfSight = new Line(position, awayBody, 0.001);
            GeodeticPoint gp = body.getIntersectionPoint(lineOfSight, position, bodyFrame, null);
            if (gp != null && Vector3D.dotProduct((Vector3D)awayBody.subtract((Vector)position), (Vector3D)body.transform(gp).subtract((Vector)position)) < 0.0) {
                gp = null;
            }
            if (gp != null) {
                intersectionsFound = true;
            } else {
                gp = body.transform(body.pointOnLimb(position, awayBody), bodyFrame, null);
            }
            loop.add(gp);
        }
        ArrayList<List<GeodeticPoint>> footprint = new ArrayList<List<GeodeticPoint>>();
        if (intersectionsFound) {
            footprint.add(loop);
        } else {
            Vector3D bodyCenter = fovToBody.getInverse().transformPosition(Vector3D.ZERO);
            if (this.offsetFromBoundary(bodyCenter, 0.0, VisibilityTrigger.VISIBLE_ONLY_WHEN_FULLY_IN_FOV) < 0.0) {
                footprint.add(loop);
            }
        }
        return footprint;
    }

    protected abstract Vector3D directionAt(double var1);
}

