/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataFilter;
import org.orekit.data.NamedData;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.SatelliteSystem;

public class HatanakaCompressFilter
implements DataFilter {
    private static final Pattern RINEX_2_PATTERN = Pattern.compile("^(\\w{4}\\d{3}[0a-x](?:\\d{2})?\\.\\d{2})[dD]$");
    private static final Pattern RINEX_3_PATTERN = Pattern.compile("^(\\w{9}_\\w{1}_\\d{11}_\\d{2}\\w_\\d{2}\\w{1}_\\w{2})\\.crx$");

    @Override
    public NamedData filter(NamedData original) {
        String oName = original.getName();
        NamedData.StreamOpener oOpener = original.getStreamOpener();
        Matcher rinex2Matcher = RINEX_2_PATTERN.matcher(oName);
        if (rinex2Matcher.matches()) {
            String fName = rinex2Matcher.group(1) + "o";
            NamedData.StreamOpener fOpener = () -> new HatanakaInputStream(oName, oOpener.openStream());
            return new NamedData(fName, fOpener);
        }
        Matcher rinex3Matcher = RINEX_3_PATTERN.matcher(oName);
        if (rinex3Matcher.matches()) {
            String fName = rinex3Matcher.group(1) + ".rnx";
            NamedData.StreamOpener fOpener = () -> new HatanakaInputStream(oName, oOpener.openStream());
            return new NamedData(fName, fOpener);
        }
        return original;
    }

    private static class CompactRinex3
    extends CompactRinexFormat {
        private static final String SYS_NB_OBS_TYPES = "SYS / # / OBS TYPES";
        private static final int EPOCH_START = 0;
        private static final int EPOCH_LENGTH = 41;
        private static final int CLOCK_START = 41;
        private static final int CLOCK_LENGTH = 15;
        private static final int CLOCK_DECIMAL_PLACES = 12;
        private static final int EVENT_START = 31;
        private static final int NB_SAT_START = 32;
        private static final int SAT_LIST_START = 41;
        private static final int DATA_LENGTH = 14;
        private static final int DATA_DECIMAL_PLACES = 3;

        CompactRinex3(String name, BufferedReader reader) {
            super(name, reader);
        }

        @Override
        public String parseHeaderLine(String line) {
            if (this.isHeaderLine(SYS_NB_OBS_TYPES, line)) {
                if (line.charAt(0) != ' ') {
                    this.updateMaxObs(SatelliteSystem.parseSatelliteSystem(CompactRinex3.parseString(line, 0, 1)), CompactRinex3.parseInt(line, 1, 5));
                }
                return line;
            }
            return super.parseHeaderLine(line);
        }

        @Override
        public String parseEpochAndClockLines(String epochLine, String clockLine) throws IOException {
            StringBuilder builder = new StringBuilder();
            this.doParseEpochAndClockLines(builder, 0, 41, 31, 32, 41, 15, 12, epochLine, clockLine, '>');
            builder.append(this.getEpochPart());
            if (!this.getClockPart().isEmpty()) {
                while (builder.length() < 41) {
                    builder.append(' ');
                }
                builder.append(this.getClockPart());
            }
            CompactRinex3.trimTrailingSpaces(builder);
            return builder.toString();
        }

        @Override
        public String parseObservationLines(String[] observationLines) {
            this.doParseObservationLines(14, 3, observationLines);
            StringBuilder builder = new StringBuilder();
            for (CharSequence sat : this.getSatellites()) {
                if (builder.length() > 0) {
                    CompactRinex3.trimTrailingSpaces(builder);
                    builder.append('\n');
                }
                builder.append(sat);
                CombinedDifferentials cd = this.getCombinedDifferentials(sat);
                String flags = cd.flags.getUncompressed();
                for (int i = 0; i < cd.observations.length; ++i) {
                    if (cd.observations[i] == null) {
                        for (int j = 0; j < 16; ++j) {
                            builder.append(' ');
                        }
                        continue;
                    }
                    builder.append(cd.observations[i].getUncompressed());
                    if (2 * i < flags.length()) {
                        builder.append(flags.charAt(2 * i));
                    }
                    if (2 * i + 1 >= flags.length()) continue;
                    builder.append(flags.charAt(2 * i + 1));
                }
            }
            CompactRinex3.trimTrailingSpaces(builder);
            return builder.toString();
        }
    }

    private static class CompactRinex1
    extends CompactRinexFormat {
        private static final String NB_TYPES_OF_OBSERV = "# / TYPES OF OBSERV";
        private static final int EPOCH_START = 0;
        private static final int EPOCH_LENGTH = 32;
        private static final int EVENT_START = 28;
        private static final int NB_SAT_START = 29;
        private static final int SAT_LIST_START = 32;
        private static final int SAT_LIST_LENGTH = 36;
        private static final int MAX_SAT_EPOCH_LINE = 12;
        private static final int CLOCK_START = 68;
        private static final int CLOCK_LENGTH = 12;
        private static final int CLOCK_DECIMAL_PLACES = 9;
        private static final int DATA_LENGTH = 14;
        private static final int DATA_DECIMAL_PLACES = 3;

        CompactRinex1(String name, BufferedReader reader) {
            super(name, reader);
        }

        @Override
        public String parseHeaderLine(String line) {
            if (this.isHeaderLine(NB_TYPES_OF_OBSERV, line)) {
                for (SatelliteSystem system : SatelliteSystem.values()) {
                    this.updateMaxObs(system, CompactRinex1.parseInt(line, 0, 6));
                }
                return line;
            }
            return super.parseHeaderLine(line);
        }

        @Override
        public String parseEpochAndClockLines(String epochLine, String clockLine) throws IOException {
            StringBuilder builder = new StringBuilder();
            this.doParseEpochAndClockLines(builder, 0, 32, 28, 29, 32, 12, 9, epochLine, clockLine, '&');
            List<CharSequence> satellites = this.getSatellites();
            builder.append(this.getEpochPart());
            int iSat = 0;
            while (iSat < FastMath.min(satellites.size(), 12)) {
                builder.append(satellites.get(iSat++));
            }
            if (!this.getClockPart().isEmpty()) {
                while (builder.length() < 68) {
                    builder.append(' ');
                }
                builder.append(this.getClockPart());
            }
            while (iSat < satellites.size()) {
                CompactRinex1.trimTrailingSpaces(builder);
                builder.append('\n');
                for (int k = 0; k < 32; ++k) {
                    builder.append(' ');
                }
                int iSatStart = iSat;
                while (iSat < FastMath.min(satellites.size(), iSatStart + 12)) {
                    builder.append(satellites.get(iSat++));
                }
            }
            CompactRinex1.trimTrailingSpaces(builder);
            return builder.toString();
        }

        @Override
        public String parseObservationLines(String[] observationLines) {
            this.doParseObservationLines(14, 3, observationLines);
            StringBuilder builder = new StringBuilder();
            for (CharSequence sat : this.getSatellites()) {
                if (builder.length() > 0) {
                    CompactRinex1.trimTrailingSpaces(builder);
                    builder.append('\n');
                }
                CombinedDifferentials cd = this.getCombinedDifferentials(sat);
                String flags = cd.flags.getUncompressed();
                for (int i = 0; i < cd.observations.length; ++i) {
                    if (i > 0 && i % 5 == 0) {
                        CompactRinex1.trimTrailingSpaces(builder);
                        builder.append('\n');
                    }
                    if (cd.observations[i] == null) {
                        for (int j = 0; j < 16; ++j) {
                            builder.append(' ');
                        }
                        continue;
                    }
                    builder.append(cd.observations[i].getUncompressed());
                    if (2 * i < flags.length()) {
                        builder.append(flags.charAt(2 * i));
                    }
                    if (2 * i + 1 >= flags.length()) continue;
                    builder.append(flags.charAt(2 * i + 1));
                }
            }
            CompactRinex1.trimTrailingSpaces(builder);
            return builder.toString();
        }
    }

    private static abstract class CompactRinexFormat {
        private static final int LABEL_START = 60;
        private static final String CRINEX_VERSION_TYPE = "CRINEX VERS   / TYPE";
        private static final String CRINEX_PROG_DATE = "CRINEX PROG / DATE";
        private static final String NB_OF_SATELLITES = "# OF SATELLITES";
        private static final String END_OF_HEADER = "END OF HEADER";
        private static final int DEFAULT_NB_SAT = 500;
        private final String name;
        private final BufferedReader reader;
        private int lineNumber;
        private final Map<SatelliteSystem, Integer> maxObs;
        private int nbSat;
        private Section section;
        private List<CharSequence> satellites;
        private TextDifferential epochDifferential;
        private NumericDifferential clockDifferential;
        private TextDifferential satListDifferential;
        private Map<CharSequence, CombinedDifferentials> differentials;

        protected CompactRinexFormat(String name, BufferedReader reader) {
            this.name = name;
            this.reader = reader;
            this.maxObs = new HashMap<SatelliteSystem, Integer>();
            for (SatelliteSystem system : SatelliteSystem.values()) {
                this.maxObs.put(system, 0);
            }
            this.nbSat = 500;
            this.section = Section.HEADER;
        }

        public String uncompressSection(String firstLine) throws IOException {
            String uncompressed;
            switch (this.section) {
                case HEADER: {
                    StringBuilder builder = new StringBuilder();
                    String line = firstLine;
                    this.lineNumber = 3;
                    while (this.section == Section.HEADER) {
                        if (builder.length() > 0) {
                            builder.append('\n');
                            line = this.readLine();
                        }
                        builder.append(this.parseHeaderLine(line));
                        CompactRinexFormat.trimTrailingSpaces(builder);
                    }
                    uncompressed = builder.toString();
                    this.section = Section.EPOCH;
                    break;
                }
                case EPOCH: {
                    ++this.lineNumber;
                    uncompressed = this.parseEpochAndClockLines(firstLine, this.readLine().trim());
                    this.section = Section.OBSERVATION;
                    break;
                }
                default: {
                    String[] lines = new String[this.satellites.size()];
                    ++this.lineNumber;
                    lines[0] = firstLine;
                    for (int i = 1; i < lines.length; ++i) {
                        lines[i] = this.readLine();
                    }
                    uncompressed = this.parseObservationLines(lines);
                    this.section = Section.EPOCH;
                }
            }
            return uncompressed;
        }

        public String parseHeaderLine(String line) {
            if (this.isHeaderLine(NB_OF_SATELLITES, line)) {
                this.nbSat = CompactRinexFormat.parseInt(line, 0, 6);
            } else if (this.isHeaderLine(END_OF_HEADER, line)) {
                this.section = Section.EPOCH;
            }
            return line;
        }

        public abstract String parseEpochAndClockLines(String var1, String var2) throws IOException;

        protected void doParseEpochAndClockLines(StringBuilder builder, int epochStart, int epochLength, int eventStart, int nbSatStart, int satListStart, int clockLength, int clockDecimalPlaces, String epochLine, String clockLine, char resetChar) throws IOException {
            boolean loop = true;
            String loopEpochLine = epochLine;
            String loopClockLine = clockLine;
            while (loop) {
                if (this.epochDifferential == null || loopEpochLine.charAt(0) == resetChar) {
                    this.epochDifferential = new TextDifferential(epochLength);
                    this.satListDifferential = new TextDifferential(this.nbSat * 3);
                    this.differentials = new HashMap<CharSequence, CombinedDifferentials>();
                }
                this.epochDifferential.accept(loopEpochLine.subSequence(epochStart, FastMath.min(loopEpochLine.length(), epochStart + epochLength)));
                if (CompactRinexFormat.parseInt(this.epochDifferential.getUncompressed(), eventStart, 1) > 1) {
                    builder.append(this.epochDifferential.getUncompressed());
                    CompactRinexFormat.trimTrailingSpaces(builder);
                    builder.append('\n');
                    int skippedLines = CompactRinexFormat.parseInt(this.epochDifferential.getUncompressed(), nbSatStart, 3);
                    for (int i = 0; i < skippedLines; ++i) {
                        builder.append(loopClockLine);
                        CompactRinexFormat.trimTrailingSpaces(builder);
                        builder.append('\n');
                        loopClockLine = this.readLine();
                    }
                    loopEpochLine = loopClockLine;
                    loopClockLine = this.readLine();
                    loop = true;
                    continue;
                }
                loop = false;
                int n = CompactRinexFormat.parseInt(this.epochDifferential.getUncompressed(), nbSatStart, 3);
                this.satellites = new ArrayList<CharSequence>(n);
                if (satListStart < loopEpochLine.length()) {
                    this.satListDifferential.accept(loopEpochLine.subSequence(satListStart, loopEpochLine.length()));
                }
                String satListPart = this.satListDifferential.getUncompressed();
                for (int i = 0; i < n; ++i) {
                    this.satellites.add(satListPart.subSequence(i * 3, (i + 1) * 3));
                }
                if (loopClockLine.isEmpty()) continue;
                if (loopClockLine.length() > 2 && loopClockLine.charAt(1) == '&') {
                    this.clockDifferential = new NumericDifferential(clockLength, clockDecimalPlaces, CompactRinexFormat.parseInt(loopClockLine, 0, 1));
                    this.clockDifferential.accept(loopClockLine.subSequence(2, loopClockLine.length()));
                    continue;
                }
                if (this.clockDifferential == null) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, this.name, loopClockLine);
                }
                this.clockDifferential.accept(loopClockLine);
            }
        }

        protected String getEpochPart() {
            return this.epochDifferential.getUncompressed();
        }

        protected String getClockPart() {
            return this.clockDifferential == null ? "" : this.clockDifferential.getUncompressed();
        }

        protected List<CharSequence> getSatellites() {
            return this.satellites;
        }

        protected CombinedDifferentials getCombinedDifferentials(CharSequence sat) {
            return this.differentials.get(sat);
        }

        public abstract String parseObservationLines(String[] var1);

        protected void doParseObservationLines(int dataLength, int dataDecimalPlaces, String[] observationLines) {
            for (int i = 0; i < observationLines.length; ++i) {
                String line = observationLines[i];
                CharSequence sat = this.satellites.get(i);
                CombinedDifferentials satDiffs = this.differentials.get(sat);
                if (satDiffs == null) {
                    SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(sat.subSequence(0, 1).toString());
                    satDiffs = new CombinedDifferentials(this.maxObs.get((Object)system));
                    this.differentials.put(sat, satDiffs);
                }
                int k = 0;
                for (int j = 0; j < satDiffs.observations.length; ++j) {
                    if (k >= line.length() || line.charAt(k) == ' ') {
                        ((CombinedDifferentials)satDiffs).observations[j] = null;
                    } else {
                        if (k + 1 < line.length() && Character.isDigit(line.charAt(k)) && line.charAt(k + 1) == '&') {
                            ((CombinedDifferentials)satDiffs).observations[j] = new NumericDifferential(dataLength, dataDecimalPlaces, Character.digit(line.charAt(k), 10));
                            k += 2;
                        }
                        int start = k;
                        while (k < line.length() && line.charAt(k) != ' ') {
                            ++k;
                        }
                        try {
                            satDiffs.observations[j].accept(line.subSequence(start, k));
                        }
                        catch (NumberFormatException nfe) {
                            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber + i - (observationLines.length - 1), this.name, observationLines[i]);
                        }
                    }
                    ++k;
                }
                if (k >= line.length()) continue;
                satDiffs.flags.accept(line.subSequence(k, line.length()));
            }
        }

        protected boolean isHeaderLine(String label, String line) {
            return label.equals(CompactRinexFormat.parseString(line, 60, label.length()));
        }

        protected void updateMaxObs(SatelliteSystem system, int nbObs) {
            this.maxObs.put(system, FastMath.max(this.maxObs.get((Object)system), nbObs));
        }

        private String readLine() throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE, this.name);
            }
            ++this.lineNumber;
            return line;
        }

        public static CompactRinexFormat getFormat(String name, BufferedReader reader) throws IOException {
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            if (line1 == null || line2 == null) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_HATANAKA_COMPRESSED_FILE, name);
            }
            int cVersion100 = (int)FastMath.rint(100.0 * CompactRinexFormat.parseDouble(line1, 0, 9));
            if (cVersion100 != 100 && cVersion100 != 300) {
                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
            }
            if (!CRINEX_VERSION_TYPE.equals(CompactRinexFormat.parseString(line1, 60, CRINEX_VERSION_TYPE.length()))) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_HATANAKA_COMPRESSED_FILE, name);
            }
            if (!CRINEX_PROG_DATE.equals(CompactRinexFormat.parseString(line2, 60, CRINEX_PROG_DATE.length()))) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_HATANAKA_COMPRESSED_FILE, name);
            }
            return cVersion100 < 300 ? new CompactRinex1(name, reader) : new CompactRinex3(name, reader);
        }

        public static String parseString(String line, int start, int length) {
            if (line.length() > start) {
                return line.substring(start, FastMath.min(line.length(), start + length)).trim();
            }
            return null;
        }

        public static int parseInt(String line, int start, int length) {
            if (line.length() > start && !CompactRinexFormat.parseString(line, start, length).isEmpty()) {
                return Integer.parseInt(CompactRinexFormat.parseString(line, start, length));
            }
            return 0;
        }

        public static double parseDouble(String line, int start, int length) {
            if (line.length() > start && !CompactRinexFormat.parseString(line, start, length).isEmpty()) {
                return Double.parseDouble(CompactRinexFormat.parseString(line, start, length));
            }
            return Double.NaN;
        }

        public static void trimTrailingSpaces(StringBuilder builder) {
            for (int i = builder.length() - 1; i >= 0 && builder.charAt(i) == ' '; --i) {
                builder.deleteCharAt(i);
            }
        }

        private static enum Section {
            HEADER,
            EPOCH,
            OBSERVATION;

        }
    }

    private static class CombinedDifferentials {
        private NumericDifferential[] observations;
        private TextDifferential flags;

        CombinedDifferentials(int nbObs) {
            this.observations = new NumericDifferential[nbObs];
            this.flags = new TextDifferential(2 * nbObs);
        }
    }

    private static class TextDifferential {
        private CharBuffer state;

        TextDifferential(int fieldLength) {
            this.state = CharBuffer.allocate(fieldLength);
            for (int i = 0; i < fieldLength; ++i) {
                this.state.put(i, ' ');
            }
        }

        public void accept(CharSequence sequence) {
            int length = FastMath.min(this.state.capacity(), sequence.length());
            for (int i = 0; i < length; ++i) {
                char c = sequence.charAt(i);
                if (c == '&') {
                    this.state.put(i, ' ');
                    continue;
                }
                if (c == ' ') continue;
                this.state.put(i, c);
            }
        }

        public String getUncompressed() {
            return this.state.toString();
        }
    }

    private static class NumericDifferential {
        private final int fieldLength;
        private final int decimalPlaces;
        private final long[] state;
        private int nbComponents;
        private String uncompressed;

        NumericDifferential(int fieldLength, int decimalPlaces, int order) {
            this.fieldLength = fieldLength;
            this.decimalPlaces = decimalPlaces;
            this.state = new long[order + 1];
            this.nbComponents = 0;
        }

        public void accept(CharSequence sequence) {
            int i;
            this.state[this.nbComponents] = Long.parseLong(sequence.toString());
            for (int i2 = this.nbComponents; i2 > 0; --i2) {
                int n = i2 - 1;
                this.state[n] = this.state[n] + this.state[i2];
            }
            if (++this.nbComponents == this.state.length) {
                --this.nbComponents;
            }
            String unscaled = Long.toString(FastMath.abs(this.state[0]));
            int length = unscaled.length();
            int digits = FastMath.max(length, this.decimalPlaces);
            int padding = this.fieldLength - (digits + (this.state[0] < 0L ? 2 : 1));
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < padding; ++i) {
                builder.append(' ');
            }
            if (this.state[0] < 0L) {
                builder.append('-');
            }
            if (length > this.decimalPlaces) {
                builder.append(unscaled, 0, length - this.decimalPlaces);
            }
            builder.append('.');
            for (i = this.decimalPlaces; i > 0; --i) {
                builder.append(i > length ? (char)'0' : unscaled.charAt(length - i));
            }
            this.uncompressed = builder.toString();
        }

        public String getUncompressed() {
            return this.uncompressed;
        }
    }

    private static class HatanakaInputStream
    extends InputStream {
        private final CompactRinexFormat format;
        private final BufferedReader reader;
        private byte[] pending;
        private int countOut;

        HatanakaInputStream(String name, InputStream input) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            this.format = CompactRinexFormat.getFormat(name, this.reader);
            this.pending = null;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) < 0 ? -1 : b[0];
        }

        @Override
        public int read(byte[] b, int offset, int len) throws IOException {
            if (this.pending == null) {
                this.countOut = 0;
                String firstLine = this.reader.readLine();
                if (firstLine == null) {
                    return -1;
                }
                this.pending = this.format.uncompressSection(firstLine).getBytes(StandardCharsets.UTF_8);
            }
            int n = FastMath.min(len, this.pending.length - this.countOut);
            System.arraycopy(this.pending, this.countOut, b, offset, n);
            if (n < len) {
                b[offset + n] = 10;
                this.pending = null;
                ++n;
            } else {
                this.countOut += n;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

