/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.Pair;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.GPSAlmanac;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class YUMAParser
extends AbstractSelfFeedingLoader
implements DataLoader {
    private static final String SOURCE = "YUMA";
    private static final String[] KEY = new String[]{"id", "health", "eccentricity", "time", "orbital", "rate", "sqrt", "right", "argument", "mean", "af0", "af1", "week"};
    private static final String DEFAULT_SUPPORTED_NAMES = ".*\\.alm$";
    private final List<GPSAlmanac> almanacs = new ArrayList<GPSAlmanac>();
    private final List<Integer> prnList = new ArrayList<Integer>();
    private final TimeScales timeScales;

    @DefaultDataContext
    public YUMAParser(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales());
    }

    public YUMAParser(String supportedNames, DataProvidersManager dataProvidersManager, TimeScales timeScales) {
        super(supportedNames == null ? DEFAULT_SUPPORTED_NAMES : supportedNames, dataProvidersManager);
        this.timeScales = timeScales;
    }

    public void loadData() {
        this.feed(this);
        if (this.almanacs.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NO_YUMA_ALMANAC_AVAILABLE, new Object[0]);
        }
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.almanacs.clear();
        this.prnList.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        try {
            ArrayList<Pair<String, String>> entries = new ArrayList<Pair<String, String>>(KEY.length);
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.trim().split(":");
                if (token.length == 2) {
                    entries.add(new Pair<String, String>(token[0].trim(), token[1].trim()));
                }
                if (entries.size() == KEY.length) {
                    GPSAlmanac almanac = this.getAlmanac(entries, name);
                    this.almanacs.add(almanac);
                    this.prnList.add(almanac.getPRN());
                    entries.clear();
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return this.almanacs.isEmpty();
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    public List<GPSAlmanac> getAlmanacs() {
        return this.almanacs;
    }

    public List<Integer> getPRNNumbers() {
        return this.prnList;
    }

    private GPSAlmanac getAlmanac(List<Pair<String, String>> entries, String name) {
        try {
            int prn = 0;
            int health = 0;
            int week = 0;
            double ecc = 0.0;
            double toa = 0.0;
            double inc = 0.0;
            double dom = 0.0;
            double sqa = 0.0;
            double om0 = 0.0;
            double aop = 0.0;
            double anom = 0.0;
            double af0 = 0.0;
            double af1 = 0.0;
            boolean[] checks = new boolean[KEY.length];
            for (Pair<String, String> entry : entries) {
                String lowerCaseKey = entry.getKey().toLowerCase(Locale.US);
                if (lowerCaseKey.startsWith(KEY[0])) {
                    prn = Integer.parseInt(entry.getValue());
                    checks[0] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[1])) {
                    health = Integer.parseInt(entry.getValue());
                    checks[1] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[2])) {
                    ecc = Double.parseDouble(entry.getValue());
                    checks[2] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[3])) {
                    toa = Double.parseDouble(entry.getValue());
                    checks[3] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[4])) {
                    inc = Double.parseDouble(entry.getValue());
                    checks[4] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[5])) {
                    dom = Double.parseDouble(entry.getValue());
                    checks[5] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[6])) {
                    sqa = Double.parseDouble(entry.getValue());
                    checks[6] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[7])) {
                    om0 = Double.parseDouble(entry.getValue());
                    checks[7] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[8])) {
                    aop = Double.parseDouble(entry.getValue());
                    checks[8] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[9])) {
                    anom = Double.parseDouble(entry.getValue());
                    checks[9] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[10])) {
                    af0 = Double.parseDouble(entry.getValue());
                    checks[10] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[11])) {
                    af1 = Double.parseDouble(entry.getValue());
                    checks[11] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[12])) {
                    week = Integer.parseInt(entry.getValue());
                    checks[12] = true;
                    continue;
                }
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
            }
            if (this.readOK(checks)) {
                AbsoluteDate date = new GNSSDate(week, toa * 1000.0, SatelliteSystem.GPS, this.timeScales).getDate();
                return new GPSAlmanac(SOURCE, prn, -1, week, toa, sqa, ecc, inc, om0, dom, aop, anom, af0, af1, health, -1, -1, date);
            }
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
    }

    private boolean readOK(boolean[] checks) {
        for (boolean check : checks) {
            if (check) continue;
            return false;
        }
        return true;
    }
}

