/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;

class FieldTurnSpan<T extends RealFieldElement<T>>
implements TimeStamped {
    private final double endMargin;
    private FieldAbsoluteDate<T> start;
    private AbsoluteDate startDouble;
    private FieldAbsoluteDate<T> end;
    private AbsoluteDate endPlusMarginDouble;
    private double startProjection;
    private double endProjection;
    private T duration;

    FieldTurnSpan(FieldAbsoluteDate<T> start, FieldAbsoluteDate<T> end, AbsoluteDate estimationDate, double endMargin) {
        TimeShiftable endPlusMargin = end.shiftedBy(endMargin);
        this.endMargin = endMargin;
        this.start = start;
        this.startDouble = start.toAbsoluteDate();
        this.end = end;
        this.endPlusMarginDouble = ((FieldAbsoluteDate)endPlusMargin).toAbsoluteDate();
        this.startProjection = FastMath.abs(start.durationFrom(estimationDate).getReal());
        this.endProjection = FastMath.abs(((FieldAbsoluteDate)endPlusMargin).durationFrom(estimationDate).getReal());
        this.duration = end.durationFrom(start);
    }

    public void updateStart(FieldAbsoluteDate<T> newStart, AbsoluteDate estimationDate) {
        double newStartProjection = FastMath.abs(newStart.toAbsoluteDate().durationFrom(estimationDate));
        if (newStartProjection <= this.startProjection) {
            this.start = newStart;
            this.startDouble = newStart.toAbsoluteDate();
            this.startProjection = newStartProjection;
            this.duration = this.end.durationFrom(this.start);
        }
    }

    public void updateEnd(FieldAbsoluteDate<T> newEnd, AbsoluteDate estimationDate) {
        double newEndProjection = FastMath.abs(newEnd.toAbsoluteDate().durationFrom(estimationDate));
        if (newEndProjection <= this.endProjection) {
            TimeShiftable endPlusMargin = newEnd.shiftedBy(this.endMargin);
            this.end = newEnd;
            this.endPlusMarginDouble = ((FieldAbsoluteDate)endPlusMargin).toAbsoluteDate();
            this.endProjection = newEndProjection;
            this.duration = this.end.durationFrom(this.start);
        }
    }

    @Override
    public AbsoluteDate getDate() {
        return this.endPlusMarginDouble;
    }

    public T getTurnDuration() {
        return this.duration;
    }

    public FieldAbsoluteDate<T> getTurnStartDate() {
        return this.start;
    }

    public FieldAbsoluteDate<T> getTurnEndDate() {
        return this.end;
    }

    public boolean inTurnTimeRange(AbsoluteDate date) {
        return date.durationFrom(this.startDouble) >= 0.0 && date.durationFrom(this.endPlusMarginDouble) <= 0.0;
    }
}

