/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class GPSBlockIIR
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_RATE = FastMath.toRadians(0.2);
    private static final double END_MARGIN = 1800.0;
    private final double yawRate;

    public GPSBlockIIR(double yawRate, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double aNoon = FastMath.atan(context.getMuRate() / this.yawRate);
        double cNoon = FastMath.cos(aNoon);
        double cNight = -cNoon;
        if (context.setUpTurnRegion(cNight, cNoon)) {
            double absBeta = FastMath.abs(context.beta(context.getDate()));
            context.setHalfSpan(absBeta * FastMath.sqrt(aNoon / absBeta - 1.0), 1800.0);
            if (context.inTurnTimeRange()) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart();
                if (context.inSunSide()) {
                    phiDot = -FastMath.copySign(this.yawRate, beta);
                    linearPhi = phiStart + phiDot * dtStart;
                } else {
                    phiDot = FastMath.copySign(this.yawRate, beta);
                    linearPhi = phiStart + phiDot * dtStart;
                }
                if (context.linearModelStillActive(linearPhi, phiDot)) {
                    return context.turnCorrectedAttitude(linearPhi, phiDot);
                }
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        RealFieldElement aNoon = FastMath.atan((RealFieldElement)context.getMuRate().divide(this.yawRate));
        double cNoon = FastMath.cos(aNoon.getReal());
        double cNight = -cNoon;
        if (context.setUpTurnRegion(cNight, cNoon)) {
            RealFieldElement absBeta = FastMath.abs(context.beta(context.getDate()));
            context.setHalfSpan(absBeta.multiply((RealFieldElement)FastMath.sqrt((RealFieldElement)((RealFieldElement)aNoon.divide(absBeta)).subtract(1.0))), 1800.0);
            if (context.inTurnTimeRange()) {
                RealFieldElement linearPhi;
                RealFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((RealFieldElement)beta);
                T dtStart = context.timeSinceTurnStart();
                if (context.inSunSide()) {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(-FastMath.copySign(this.yawRate, beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                } else {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(FastMath.copySign(this.yawRate, beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                }
                if (context.linearModelStillActive(linearPhi, phiDot)) {
                    return context.turnCorrectedAttitude(linearPhi, phiDot);
                }
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

