/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class Galileo
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_RATE = FastMath.toRadians(0.203);
    private static final double BETA_X = FastMath.toRadians(15.0);
    private static final double COS_NOON = FastMath.cos(BETA_X);
    private static final double COS_NIGHT = -COS_NOON;
    private static final double END_MARGIN = 0.0;
    private final double yawRate;

    public Galileo(double yawRate, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double beta0 = FastMath.atan(context.getMuRate() / this.yawRate);
        if (FastMath.abs(context.beta(context.getDate())) < beta0 && context.setUpTurnRegion(COS_NIGHT, COS_NOON)) {
            context.setHalfSpan(context.inSunSide() ? BETA_X : context.inOrbitPlaneAbsoluteAngle(BETA_X), 0.0);
            if (context.inTurnTimeRange()) {
                DerivativeStructure beta = context.betaDS();
                DerivativeStructure cosBeta = beta.cos();
                DerivativeStructure sinBeta = beta.sin();
                double sinY = FastMath.copySign(FastMath.sin(beta0), context.getSecuredBeta());
                DerivativeStructure sd = FastMath.sin(context.getDeltaDS()).multiply(FastMath.copySign(1.0, -context.getSVBcos() * context.getDeltaDS().getPartialDerivative(1)));
                DerivativeStructure c = sd.multiply(cosBeta);
                DerivativeStructure shy = sinBeta.negate().subtract(sinY).add(sinBeta.subtract(sinY).multiply(c.abs().multiply(Math.PI / FastMath.sin(BETA_X)).cos())).multiply(0.5);
                DerivativeStructure phi = FastMath.atan2(shy, c);
                return context.turnCorrectedAttitude(phi);
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        double beta0 = FastMath.atan(context.getMuRate().getReal() / this.yawRate);
        if (FastMath.abs(context.beta(context.getDate())).getReal() < beta0 && context.setUpTurnRegion(COS_NIGHT, COS_NOON)) {
            Field<T> field = context.getDate().getField();
            RealFieldElement betaX = (RealFieldElement)((RealFieldElement)field.getZero()).add(BETA_X);
            context.setHalfSpan(context.inSunSide() ? betaX : context.inOrbitPlaneAbsoluteAngle(betaX), 0.0);
            if (context.inTurnTimeRange()) {
                FieldDerivativeStructure<T> beta = context.betaDS();
                Object cosBeta = beta.cos();
                Object sinBeta = beta.sin();
                RealFieldElement sinY = (RealFieldElement)FastMath.sin((RealFieldElement)((RealFieldElement)field.getZero()).add(beta0)).copySign(context.getSecuredBeta());
                Object sd = FastMath.sin(context.getDeltaDS()).multiply(FastMath.copySign(1.0, -context.getSVBcos().getReal() * context.getDeltaDS().getPartialDerivative(1).getReal()));
                FieldDerivativeStructure c = ((FieldDerivativeStructure)sd).multiply(cosBeta);
                Object shy = ((FieldDerivativeStructure)((FieldDerivativeStructure)sinBeta).negate()).subtract(sinY).add(((FieldDerivativeStructure)sinBeta).subtract(sinY).multiply((FieldDerivativeStructure<RealFieldElement>)((FieldDerivativeStructure)((FieldDerivativeStructure)c.abs()).multiply(Math.PI / FastMath.sin(BETA_X))).cos())).multiply(0.5);
                FieldDerivativeStructure phi = FastMath.atan2(shy, c);
                return context.turnCorrectedAttitude(phi);
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

