/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.optim.MaxEval;
import org.hipparchus.optim.nonlinear.scalar.GoalType;
import org.hipparchus.optim.univariate.BrentOptimizer;
import org.hipparchus.optim.univariate.SearchInterval;
import org.hipparchus.optim.univariate.UnivariateObjectiveFunction;
import org.hipparchus.util.FastMath;
import org.orekit.models.AtmosphericRefractionModel;

public class EarthITU453AtmosphereRefraction
implements AtmosphericRefractionModel {
    private static final double KM_TO_M = 1000.0;
    private static final double INV_DEG_TO_INV_RAD = 57.29577951308232;
    private static final double DEFAULT_CORRECTION_ACOEF = 3.15E-4;
    private static final double DEFAULT_CORRECTION_BCOEF = 1.361E-4;
    private static final double EARTH_RAY = 6370000.0;
    private static final double[] CCOEF = new double[]{75.28665428019018, 36.88129327257109, 1.643815914230332, 0.013206677177765476, 0.005401846092493401, 6.279617434633822E-4, 4.917696755607856E-7};
    private static final double[] CCOEF0 = new double[]{99.00710699860625, 31.002746294528848, 2.133121871272055, 0.01039918398162444, 0.003593591291060523, 6.520259708588768E-4, 9.894981121909318E-7, 4.7486742060442633E-7};
    private static final long serialVersionUID = 20160118L;
    private final double altitude;
    private final double thetamin;
    private final double theta0;
    private final double elev_star;
    private final double refrac_star;

    public EarthITU453AtmosphereRefraction(double altitude) {
        this.altitude = altitude;
        this.thetamin = this.getMinimalElevation(altitude);
        this.theta0 = this.thetamin - this.getTau(this.thetamin);
        UnivariateFunction refrac = new UnivariateFunction(){

            @Override
            public double value(double elev) {
                return elev + EarthITU453AtmosphereRefraction.this.getBaseRefraction(elev);
            }
        };
        double rel = 1.0E-5;
        double abs = 1.0E-10;
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-5, 1.0E-10);
        this.elev_star = optimizer.optimize(new MaxEval(200), new UnivariateObjectiveFunction(refrac), GoalType.MINIMIZE, new SearchInterval(-0.10471975511965977, 0.7853981633974483)).getPoint();
        this.refrac_star = this.getBaseRefraction(this.elev_star);
    }

    private double getRefractiveIndex(double alt) {
        return 1.0 + 3.15E-4 * FastMath.exp(-1.361E-4 * alt);
    }

    private double getMinimalElevation(double alt) {
        return -FastMath.acos(6370000.0 / (6370000.0 + alt) * this.getRefractiveIndex(0.0) / this.getRefractiveIndex(alt));
    }

    private double getTau(double elevation) {
        double eld = FastMath.toDegrees(elevation);
        double tmp0 = CCOEF[0] + CCOEF[1] * eld + CCOEF[2] * eld * eld;
        double tmp1 = this.altitude * (CCOEF[3] + CCOEF[4] * eld + CCOEF[5] * eld * eld);
        double tmp2 = this.altitude * this.altitude * CCOEF[6];
        return 1.0 / (tmp0 + tmp1 + tmp2);
    }

    private double getTauZero(double elevationZero) {
        double eld = FastMath.toDegrees(elevationZero);
        double tmp0 = CCOEF0[0] + CCOEF0[1] * eld + CCOEF0[2] * eld * eld;
        double tmp1 = this.altitude * (CCOEF0[3] + CCOEF0[4] * eld + CCOEF0[5] * eld * eld);
        double tmp2 = this.altitude * this.altitude * (CCOEF0[6] + CCOEF0[7] * eld);
        return 1.0 / (tmp0 + tmp1 + tmp2);
    }

    private double getBaseRefraction(double elevation) {
        return this.getTauZero(elevation);
    }

    public double getThetaMin() {
        return this.thetamin;
    }

    public double getTheta0() {
        return this.theta0;
    }

    @Override
    public double getRefraction(double elevation) {
        if (elevation < this.elev_star) {
            return this.refrac_star;
        }
        return this.getTauZero(elevation);
    }
}

