/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.Frame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class SimpleExponentialAtmosphere
implements Atmosphere {
    private static final long serialVersionUID = 2772347498196369601L;
    private BodyShape shape;
    private double rho0;
    private double h0;
    private double hscale;

    public SimpleExponentialAtmosphere(BodyShape shape, double rho0, double h0, double hscale) {
        this.shape = shape;
        this.rho0 = rho0;
        this.h0 = h0;
        this.hscale = hscale;
    }

    @Override
    public Frame getFrame() {
        return this.shape.getBodyFrame();
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) {
        GeodeticPoint gp = this.shape.transform(position, frame, date);
        return this.rho0 * FastMath.exp((this.h0 - gp.getAltitude()) / this.hscale);
    }

    @Override
    public <T extends RealFieldElement<T>> T getDensity(FieldAbsoluteDate<T> date, FieldVector3D<T> position, Frame frame) {
        FieldGeodeticPoint<T> gp = this.shape.transform(position, frame, date);
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)gp.getAltitude().subtract(this.h0)).divide(-this.hscale)).exp()).multiply(this.rho0));
    }
}

