/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.DTM2000InputParameters;
import org.orekit.models.earth.atmosphere.NRLMSISE00InputParameters;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public class MarshallSolarActivityFutureEstimation
extends AbstractSelfFeedingLoader
implements DataLoader,
DTM2000InputParameters,
NRLMSISE00InputParameters {
    public static final String DEFAULT_SUPPORTED_NAMES = "\\p{Alpha}\\p{Lower}\\p{Lower}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}(?:f|F)10(?:_prd)?\\.(?:txt|TXT)";
    private static final long serialVersionUID = -5212198874900835369L;
    private final Pattern dataPattern;
    private final SortedSet<TimeStamped> data = new TreeSet<TimeStamped>(new ChronologicalComparator());
    private final StrengthLevel strengthLevel;
    private final TimeScale utc;
    private AbsoluteDate firstDate = null;
    private AbsoluteDate lastDate = null;
    private LineParameters previousParam;
    private LineParameters currentParam;

    @DefaultDataContext
    public MarshallSolarActivityFutureEstimation(String supportedNames, StrengthLevel strengthLevel) {
        this(supportedNames, strengthLevel, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public MarshallSolarActivityFutureEstimation(String supportedNames, StrengthLevel strengthLevel, DataProvidersManager dataProvidersManager, TimeScale utc) {
        super(supportedNames, dataProvidersManager);
        this.strengthLevel = strengthLevel;
        this.utc = utc;
        StringBuilder builder = new StringBuilder("^");
        builder.append("\\p{Blank}*(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})");
        builder.append("\\.\\p{Digit}+");
        builder.append("\\p{Blank}+(");
        for (Month month : Month.values()) {
            builder.append(month.getUpperCaseAbbreviation());
            builder.append('|');
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(")");
        for (int i = 0; i < 6; ++i) {
            builder.append("\\p{Blank}+([-+]?[0-9]+\\.[0-9]+)");
        }
        builder.append("\\p{Blank}*$");
        this.dataPattern = Pattern.compile(builder.toString());
    }

    public StrengthLevel getStrengthLevel() {
        return this.strengthLevel;
    }

    private void bracketDate(AbsoluteDate date) {
        if (date.durationFrom(this.firstDate) < 0.0 || date.durationFrom(this.lastDate) > 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, date, this.firstDate, this.lastDate);
        }
        if (this.previousParam != null && date.durationFrom(this.previousParam.getDate()) > 0.0 && date.durationFrom(this.currentParam.getDate()) <= 0.0) {
            return;
        }
        if (date.equals(this.firstDate)) {
            this.currentParam = (LineParameters)this.data.tailSet(date.shiftedBy(1.0)).first();
            this.previousParam = (LineParameters)this.data.first();
        } else if (date.equals(this.lastDate)) {
            this.currentParam = (LineParameters)this.data.last();
            this.previousParam = (LineParameters)this.data.headSet(date.shiftedBy(-1.0)).last();
        } else {
            this.currentParam = (LineParameters)this.data.tailSet(date).first();
            this.previousParam = (LineParameters)this.data.headSet(date).last();
        }
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    @Override
    public AbsoluteDate getMinDate() {
        if (this.firstDate == null) {
            this.feed(this);
        }
        return this.firstDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        if (this.lastDate == null) {
            this.feed(this);
        }
        return this.lastDate;
    }

    @Override
    public double getInstantFlux(AbsoluteDate date) {
        return this.getMeanFlux(date);
    }

    @Override
    public double getMeanFlux(AbsoluteDate date) {
        this.bracketDate(date);
        AbsoluteDate previousDate = this.previousParam.getDate();
        AbsoluteDate currentDate = this.currentParam.getDate();
        double dt = currentDate.durationFrom(previousDate);
        double previousF107 = this.previousParam.getF107();
        double currentF107 = this.currentParam.getF107();
        double previousWeight = currentDate.durationFrom(date) / dt;
        double currentWeight = date.durationFrom(previousDate) / dt;
        return previousF107 * previousWeight + currentF107 * currentWeight;
    }

    @Override
    public double getThreeHourlyKP(AbsoluteDate date) {
        return this.get24HoursKp(date);
    }

    public DateComponents getFileDate(AbsoluteDate date) {
        this.bracketDate(date);
        double dtP = date.durationFrom(this.previousParam.getDate());
        double dtC = this.currentParam.getDate().durationFrom(date);
        return dtP < dtC ? this.previousParam.getFileDate() : this.currentParam.getFileDate();
    }

    @Override
    public double get24HoursKp(AbsoluteDate date) {
        double ap = this.getDailyAp(date);
        return 1.89 * FastMath.asinh(0.154 * ap);
    }

    @Override
    public double getDailyFlux(AbsoluteDate date) {
        return this.getMeanFlux(date.shiftedBy(-86400.0));
    }

    @Override
    public double getAverageFlux(AbsoluteDate date) {
        double average = 0.0;
        for (int i = -40; i < 41; ++i) {
            average += this.getMeanFlux(date.shiftedBy((double)i * 86400.0));
        }
        return average / 81.0;
    }

    @Override
    public double[] getAp(AbsoluteDate date) {
        double ap = this.getDailyAp(date);
        return new double[]{ap, ap, ap, ap, ap, ap, ap};
    }

    private double getDailyAp(AbsoluteDate date) {
        this.bracketDate(date);
        AbsoluteDate previousDate = this.previousParam.getDate();
        AbsoluteDate currentDate = this.currentParam.getDate();
        double dt = currentDate.durationFrom(previousDate);
        double previousAp = this.previousParam.getAp();
        double currentAp = this.currentParam.getAp();
        double previousWeight = currentDate.durationFrom(date) / dt;
        double currentWeight = date.durationFrom(previousDate) / dt;
        return previousAp * previousWeight + currentAp * currentWeight;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int apGroup;
        int f107Group;
        switch (this.strengthLevel) {
            case STRONG: {
                f107Group = 3;
                apGroup = 6;
                break;
            }
            case AVERAGE: {
                f107Group = 4;
                apGroup = 7;
                break;
            }
            default: {
                f107Group = 5;
                apGroup = 8;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        boolean inData = false;
        DateComponents fileDate = null;
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                Matcher matcher = this.dataPattern.matcher(line);
                if (matcher.matches()) {
                    inData = true;
                    int year = Integer.parseInt(matcher.group(1));
                    Month month = Month.parseMonth(matcher.group(2));
                    AbsoluteDate date = new AbsoluteDate(year, month, 1, this.utc);
                    if (fileDate == null) {
                        fileDate = month.getNumber() > 6 ? new DateComponents(year + 1, month.getNumber() - 6, 1) : new DateComponents(year, month.getNumber() + 6, 1);
                    }
                    boolean addEntry = false;
                    Iterator iterator = this.data.tailSet(date).iterator();
                    if (iterator.hasNext()) {
                        LineParameters existingEntry = (LineParameters)iterator.next();
                        if (existingEntry.getDate().equals(date)) {
                            if (existingEntry.getFileDate().compareTo(fileDate) < 0) {
                                iterator.remove();
                                addEntry = true;
                            }
                        } else {
                            addEntry = true;
                        }
                    } else {
                        addEntry = true;
                    }
                    if (addEntry) {
                        this.data.add(new LineParameters(fileDate, date, Double.parseDouble(matcher.group(f107Group)), Double.parseDouble(matcher.group(apGroup))));
                    }
                } else if (inData) {
                    throw new OrekitException((Localizable)OrekitMessages.NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE, name);
                }
            }
            line = reader.readLine();
        }
        if (this.data.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE, name);
        }
        this.firstDate = this.data.first().getDate();
        this.lastDate = this.data.last().getDate();
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.getSupportedNames(), this.strengthLevel);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = -5212198874900835369L;
        private final String supportedNames;
        private final StrengthLevel strengthLevel;

        DataTransferObject(String supportedNames, StrengthLevel strengthLevel) {
            this.supportedNames = supportedNames;
            this.strengthLevel = strengthLevel;
        }

        private Object readResolve() {
            try {
                return new MarshallSolarActivityFutureEstimation(this.supportedNames, this.strengthLevel);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private static class LineParameters
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = 6607862001953526475L;
        private final DateComponents fileDate;
        private final AbsoluteDate date;
        private final double f107;
        private final double ap;

        private LineParameters(DateComponents fileDate, AbsoluteDate date, double f107, double ap) {
            this.fileDate = fileDate;
            this.date = date;
            this.f107 = f107;
            this.ap = ap;
        }

        public DateComponents getFileDate() {
            return this.fileDate;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getF107() {
            return this.f107;
        }

        public double getAp() {
            return this.ap;
        }
    }

    public static enum StrengthLevel {
        STRONG,
        AVERAGE,
        WEAK;

    }
}

