/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;

public class KlobucharIonoCoefficientsLoader
extends AbstractSelfFeedingLoader
implements DataLoader {
    public static final String DEFAULT_SUPPORTED_NAMES = "CGIM*0\\.*N$";
    private double[] alpha = null;
    private double[] beta = null;

    @DefaultDataContext
    public KlobucharIonoCoefficientsLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager());
    }

    public KlobucharIonoCoefficientsLoader(String supportedNames, DataProvidersManager dataProvidersManager) {
        super(supportedNames, dataProvidersManager);
    }

    @DefaultDataContext
    public KlobucharIonoCoefficientsLoader() {
        this(DEFAULT_SUPPORTED_NAMES);
    }

    public double[] getAlpha() {
        return (double[])this.alpha.clone();
    }

    public double[] getBeta() {
        return (double[])this.beta.clone();
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    public void loadKlobucharIonosphericCoefficients() {
        this.feed(this);
        if (this.alpha == null || this.beta == null) {
            throw new OrekitException((Localizable)OrekitMessages.KLOBUCHAR_ALPHA_BETA_NOT_LOADED, this.getSupportedNames());
        }
    }

    public void loadKlobucharIonosphericCoefficients(DateComponents dateComponents) {
        int doy = dateComponents.getDayOfYear();
        String yearString = String.valueOf(dateComponents.getYear());
        this.setSupportedNames(String.format("CGIM%03d0.%2sN", doy, yearString.substring(yearString.length() - 2)));
        try {
            this.loadKlobucharIonosphericCoefficients();
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe, OrekitMessages.KLOBUCHAR_ALPHA_BETA_NOT_AVAILABLE_FOR_DATE, dateComponents.toString());
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        int lineNumber = 0;
        String splitter = "\\s+";
        String line = br.readLine();
        while (line != null) {
            ++lineNumber;
            line = line.trim();
            try {
                int j;
                if (line.length() > 0 && line.endsWith("ALPHA")) {
                    String[] alpha_line = line.split("\\s+");
                    this.alpha = new double[4];
                    for (j = 0; j < 4; ++j) {
                        this.alpha[j] = Double.parseDouble(alpha_line[j].replace("D", "E"));
                    }
                }
                if (line.length() > 0 && line.endsWith("BETA")) {
                    String[] beta_line = line.split("\\s+");
                    this.beta = new double[4];
                    for (j = 0; j < 4; ++j) {
                        this.beta[j] = Double.parseDouble(beta_line[j].replace("D", "E"));
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            line = br.readLine();
        }
        if (this.alpha == null || this.beta == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_KLOBUCHAR_ALPHA_BETA_IN_FILE, name);
        }
        input.close();
    }
}

