/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class KlobucharIonoModel
implements IonosphericModel {
    private static final long serialVersionUID = 7277525837842061107L;
    private final double[] alpha;
    private final double[] beta;
    private final TimeScale gps;

    @DefaultDataContext
    public KlobucharIonoModel(double[] alpha, double[] beta) {
        this(alpha, beta, DataContext.getDefault().getTimeScales().getGPS());
    }

    public KlobucharIonoModel(double[] alpha, double[] beta, TimeScale gps) {
        this.alpha = (double[])alpha.clone();
        this.beta = (double[])beta.clone();
        this.gps = gps;
    }

    public double pathDelay(AbsoluteDate date, GeodeticPoint geo, double elevation, double azimuth, double frequency, double[] parameters) {
        double rad2semi = 0.3183098861837907;
        double semi2rad = Math.PI;
        double psi = 0.0137 / (elevation / Math.PI + 0.11) - 0.022;
        double latIono = FastMath.min(FastMath.max(geo.getLatitude() * 0.3183098861837907 + psi * FastMath.cos(azimuth), -0.416), 0.416);
        double lonIono = geo.getLongitude() * 0.3183098861837907 + psi * FastMath.sin(azimuth) / FastMath.cos(latIono * Math.PI);
        double latGeom = latIono + 0.064 * FastMath.cos((lonIono - 1.617) * Math.PI);
        DateTimeComponents dtc = date.getComponents(this.gps);
        int dofweek = dtc.getDate().getDayOfWeek();
        double secday = dtc.getTime().getSecondsInLocalDay();
        double tow = (double)dofweek * 86400.0 + secday;
        double t = 43200.0 * lonIono + tow;
        double tsec = t - FastMath.floor(t / 86400.0) * 86400.0;
        double slantFactor = 1.0 + 16.0 * FastMath.pow(0.53 - elevation / Math.PI, 3);
        double period = FastMath.max(72000.0, this.beta[0] + (this.beta[1] + (this.beta[2] + this.beta[3] * latGeom) * latGeom) * latGeom);
        double x = Math.PI * 2 * (tsec - 50400.0) / period;
        double amplitude = FastMath.max(0.0, this.alpha[0] + (this.alpha[1] + (this.alpha[2] + this.alpha[3] * latGeom) * latGeom) * latGeom);
        double ionoTimeDelayL1 = slantFactor * 5.0E-9;
        if (FastMath.abs(x) < 1.57) {
            ionoTimeDelayL1 += slantFactor * (amplitude * (1.0 - FastMath.pow(x, 2) / 2.0 + FastMath.pow(x, 4) / 24.0));
        }
        double ratio = FastMath.pow(1.57542E9 / frequency, 2);
        return ratio * 2.99792458E8 * ionoTimeDelayL1;
    }

    @Override
    public double pathDelay(SpacecraftState state, TopocentricFrame baseFrame, double frequency, double[] parameters) {
        Vector3D position = state.getPVCoordinates(baseFrame).getPosition();
        double elevation = position.getDelta();
        if (elevation > 0.0) {
            AbsoluteDate date = state.getDate();
            GeodeticPoint geo = baseFrame.getPoint();
            double azimuth = FastMath.atan2(position.getX(), position.getY());
            if (azimuth < 0.0) {
                azimuth += Math.PI * 2;
            }
            return this.pathDelay(date, geo, elevation, azimuth, frequency, parameters);
        }
        return 0.0;
    }

    public <T extends RealFieldElement<T>> T pathDelay(FieldAbsoluteDate<T> date, FieldGeodeticPoint<T> geo, T elevation, T azimuth, double frequency, T[] parameters) {
        Field<T> field = date.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement one = (RealFieldElement)field.getOne();
        double rad2semi = 0.3183098861837907;
        double semi2rad = Math.PI;
        RealFieldElement psi = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elevation.divide(Math.PI)).add(0.11)).divide(0.0137)).reciprocal()).subtract(0.022);
        RealFieldElement latIono = FastMath.min(FastMath.max(((RealFieldElement)geo.getLatitude().multiply(0.3183098861837907)).add(psi.multiply(FastMath.cos(azimuth))), (RealFieldElement)zero.subtract(0.416)), (RealFieldElement)zero.add(0.416));
        RealFieldElement lonIono = ((RealFieldElement)geo.getLongitude().multiply(0.3183098861837907)).add(psi.multiply(FastMath.sin(azimuth)).divide((RealFieldElement)FastMath.cos((RealFieldElement)latIono.multiply(Math.PI))));
        RealFieldElement latGeom = (RealFieldElement)latIono.add(FastMath.cos((RealFieldElement)((RealFieldElement)lonIono.subtract(1.617)).multiply(Math.PI)).multiply(0.064));
        DateTimeComponents dtc = date.getComponents(this.gps);
        int dofweek = dtc.getDate().getDayOfWeek();
        double secday = dtc.getTime().getSecondsInLocalDay();
        double tow = (double)dofweek * 86400.0 + secday;
        RealFieldElement t = (RealFieldElement)((RealFieldElement)lonIono.multiply(43200.0)).add(tow);
        RealFieldElement tsec = (RealFieldElement)t.subtract(FastMath.floor((RealFieldElement)t.divide(86400.0)).multiply(86400.0));
        RealFieldElement slantFactor = ((RealFieldElement)FastMath.pow((RealFieldElement)((RealFieldElement)((RealFieldElement)elevation.divide(Math.PI)).negate()).add(0.53), 3).multiply(16.0)).add(one);
        RealFieldElement period = FastMath.max((RealFieldElement)zero.add(72000.0), (RealFieldElement)((RealFieldElement)latGeom.multiply(((RealFieldElement)latGeom.multiply(((RealFieldElement)latGeom.multiply(this.beta[3])).add(this.beta[2]))).add(this.beta[1]))).add(this.beta[0]));
        RealFieldElement x = ((RealFieldElement)((RealFieldElement)tsec.subtract(50400.0)).multiply(Math.PI * 2)).divide(period);
        RealFieldElement amplitude = FastMath.max(zero, (RealFieldElement)((RealFieldElement)latGeom.multiply(((RealFieldElement)latGeom.multiply(((RealFieldElement)latGeom.multiply(this.alpha[3])).add(this.alpha[2]))).add(this.alpha[1]))).add(this.alpha[0]));
        RealFieldElement ionoTimeDelayL1 = (RealFieldElement)slantFactor.multiply(5.0E-9);
        if (FastMath.abs(x.getReal()) < 1.57) {
            ionoTimeDelayL1 = (RealFieldElement)ionoTimeDelayL1.add(slantFactor.multiply(amplitude.multiply(((RealFieldElement)one.subtract(FastMath.pow(x, 2).multiply(0.5))).add(FastMath.pow(x, 4).divide(24.0)))));
        }
        double ratio = FastMath.pow(1.57542E9 / frequency, 2);
        return (T)((RealFieldElement)((RealFieldElement)ionoTimeDelayL1.multiply(2.99792458E8)).multiply(ratio));
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(FieldSpacecraftState<T> state, TopocentricFrame baseFrame, double frequency, T[] parameters) {
        FieldVector3D position = state.getPVCoordinates(baseFrame).getPosition();
        Object elevation = position.getDelta();
        if (elevation.getReal() > 0.0) {
            FieldAbsoluteDate<T> date = state.getDate();
            FieldGeodeticPoint<T> geo = baseFrame.getPoint(date.getField());
            Object azimuth = FastMath.atan2(position.getX(), position.getY());
            if (azimuth.getReal() < 0.0) {
                azimuth = (RealFieldElement)azimuth.add(Math.PI * 2);
            }
            return (T)this.pathDelay(date, geo, (RealFieldElement)elevation, (RealFieldElement)azimuth, frequency, (RealFieldElement[])parameters);
        }
        return (T)((RealFieldElement)elevation.getField().getZero());
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

