/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.tessellation.TileAiming;

public class DivertedSingularityAiming
implements TileAiming {
    private final Vector3D singularity;
    private final GeodeticPoint singularityGP;
    private final Vector3D moment;

    public DivertedSingularityAiming(SphericalPolygonsSet forbiddenZone) {
        S2Point outside = forbiddenZone.getEnclosingCap().getCenter().negate();
        this.singularity = outside.getVector();
        this.singularityGP = new GeodeticPoint(1.5707963267948966 - outside.getPhi(), outside.getTheta(), 0.0);
        this.moment = this.singularity.orthogonal();
    }

    @Override
    public List<GeodeticPoint> getSingularPoints() {
        return Arrays.asList(this.singularityGP);
    }

    @Override
    public Vector3D alongTileDirection(Vector3D point, GeodeticPoint gp) {
        Vector3D p = new S2Point(gp.getLongitude(), 1.5707963267948966 - gp.getLatitude()).getVector();
        Vector3D r = ((Vector3D)p.subtract((Vector)this.singularity)).normalize();
        Vector3D field = new Vector3D(3.0 * Vector3D.dotProduct(this.moment, r), r, -1.0, this.moment);
        Vector3D horizontal = new Vector3D(1.0, field, -Vector3D.dotProduct(field, p), p);
        return horizontal.normalize();
    }
}

