/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.io.Serializable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;

public class Tile
implements Serializable {
    private static final long serialVersionUID = 20150313L;
    private final GeodeticPoint v0;
    private final GeodeticPoint v1;
    private final GeodeticPoint v2;
    private final GeodeticPoint v3;

    public Tile(GeodeticPoint v0, GeodeticPoint v1, GeodeticPoint v2, GeodeticPoint v3) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public GeodeticPoint[] getVertices() {
        return new GeodeticPoint[]{this.v0, this.v1, this.v2, this.v3};
    }

    public GeodeticPoint getInterpolatedPoint(double u, double v) {
        Vector3D pu0 = this.interpolate(this.v0.getZenith(), this.v1.getZenith(), u);
        Vector3D pu1 = this.interpolate(this.v3.getZenith(), this.v2.getZenith(), u);
        Vector3D puv = this.interpolate(pu0, pu1, v);
        double hu0 = this.v1.getAltitude() * u + this.v0.getAltitude() * (1.0 - u);
        double hu1 = this.v2.getAltitude() * u + this.v3.getAltitude() * (1.0 - u);
        double huv = hu1 * v + hu0 * (1.0 - v);
        return new GeodeticPoint(puv.getDelta(), puv.getAlpha(), huv);
    }

    private Vector3D interpolate(Vector3D p0, Vector3D p1, double r) {
        double theta = Vector3D.angle(p0, p1);
        double alpha = r * theta;
        double thetaMAlpha = (1.0 - r) * theta;
        double sinTheta = FastMath.sin(theta);
        double sinAlpha = FastMath.sin(alpha);
        double sinThetaMAlpha = FastMath.sin(thetaMAlpha);
        return new Vector3D(sinThetaMAlpha / sinTheta, p0, sinAlpha / sinTheta, p1);
    }

    public GeodeticPoint getCenter() {
        return this.getInterpolatedPoint(0.5, 0.5);
    }
}

