/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class NiellMappingFunctionModel
implements MappingFunction {
    private static final double[] VALUES_FOR_AH_AVERAGE = new double[]{0.0012769934, 0.001268323, 0.0012465397, 0.0012196049, 0.0012045996};
    private static final double[] VALUES_FOR_BH_AVERAGE = new double[]{0.0029153695, 0.0029152299, 0.0029288445, 0.0029022565, 0.0029024912};
    private static final double[] VALUES_FOR_CH_AVERAGE = new double[]{0.062610505, 0.062837393, 0.063721774, 0.063824265, 0.064258455};
    private static final double[] VALUES_FOR_AH_AMPLITUDE = new double[]{0.0, 1.2709626E-5, 2.6523662E-5, 3.4000452E-5, 4.1202191E-5};
    private static final double[] VALUES_FOR_BH_AMPLITUDE = new double[]{0.0, 2.1414979E-5, 3.0160779E-5, 7.2562722E-5, 1.1723375E-4};
    private static final double[] VALUES_FOR_CH_AMPLITUDE = new double[]{0.0, 9.01284E-5, 4.3497037E-5, 8.4795348E-4, 0.0017037206};
    private static final double[] VALUES_FOR_AW = new double[]{5.8021897E-4, 5.6794847E-4, 5.8118019E-4, 5.9727542E-4, 6.1641693E-4};
    private static final double[] VALUES_FOR_BW = new double[]{0.0014275268, 0.0015138625, 0.0014572752, 0.0015007428, 0.0017599082};
    private static final double[] VALUES_FOR_CW = new double[]{0.043472961, 0.04672951, 0.043908931, 0.044626982, 0.054736038};
    private static final double[] LATITUDE_VALUES = new double[]{FastMath.toRadians(15.0), FastMath.toRadians(30.0), FastMath.toRadians(45.0), FastMath.toRadians(60.0), FastMath.toRadians(75.0)};
    private final UnivariateFunction ahAverageFunction;
    private final UnivariateFunction bhAverageFunction;
    private final UnivariateFunction chAverageFunction;
    private final UnivariateFunction ahAmplitudeFunction;
    private final UnivariateFunction bhAmplitudeFunction;
    private final UnivariateFunction chAmplitudeFunction;
    private final UnivariateFunction awFunction;
    private final UnivariateFunction bwFunction;
    private final UnivariateFunction cwFunction;
    private final double latitude;
    private final TimeScale utc;

    @DefaultDataContext
    public NiellMappingFunctionModel(double latitude) {
        this(latitude, DataContext.getDefault().getTimeScales().getUTC());
    }

    public NiellMappingFunctionModel(double latitude, TimeScale utc) {
        this.utc = utc;
        this.ahAverageFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_AH_AVERAGE);
        this.bhAverageFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_BH_AVERAGE);
        this.chAverageFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_CH_AVERAGE);
        this.ahAmplitudeFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_AH_AMPLITUDE);
        this.bhAmplitudeFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_BH_AMPLITUDE);
        this.chAmplitudeFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_CH_AMPLITUDE);
        this.awFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_AW);
        this.bwFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_BW);
        this.cwFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_CW);
        this.latitude = latitude;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        double t0 = 28.0;
        if (this.latitude < 0.0) {
            t0 += 183.0;
        }
        double coef = Math.PI * 2 * (((double)dofyear - t0) / 365.25);
        double cosCoef = FastMath.cos(coef);
        double absLatidude = FastMath.abs(this.latitude);
        absLatidude = FastMath.max(FastMath.toRadians(15.0), absLatidude);
        absLatidude = FastMath.min(FastMath.toRadians(75.0), absLatidude);
        double ah = this.ahAverageFunction.value(absLatidude) - this.ahAmplitudeFunction.value(absLatidude) * cosCoef;
        double bh = this.bhAverageFunction.value(absLatidude) - this.bhAmplitudeFunction.value(absLatidude) * cosCoef;
        double ch = this.chAverageFunction.value(absLatidude) - this.chAmplitudeFunction.value(absLatidude) * cosCoef;
        double[] function = new double[]{this.computeFunction(ah, bh, ch, elevation), this.computeFunction(this.awFunction.value(absLatidude), this.bwFunction.value(absLatidude), this.cwFunction.value(absLatidude), elevation)};
        double correction = this.computeHeightCorrection(elevation, height);
        function[0] = function[0] + correction;
        return function;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        double t0 = 28.0;
        if (this.latitude < 0.0) {
            t0 += 183.0;
        }
        RealFieldElement coef = (RealFieldElement)zero.add(Math.PI * 2 * (((double)dofyear - t0) / 365.25));
        RealFieldElement cosCoef = FastMath.cos(coef);
        double absLatidude = FastMath.abs(this.latitude);
        absLatidude = FastMath.max(FastMath.toRadians(15.0), absLatidude);
        absLatidude = FastMath.min(FastMath.toRadians(75.0), absLatidude);
        RealFieldElement ah = (RealFieldElement)((RealFieldElement)((RealFieldElement)cosCoef.multiply(this.ahAmplitudeFunction.value(absLatidude))).negate()).add(this.ahAverageFunction.value(absLatidude));
        RealFieldElement bh = (RealFieldElement)((RealFieldElement)((RealFieldElement)cosCoef.multiply(this.bhAmplitudeFunction.value(absLatidude))).negate()).add(this.bhAverageFunction.value(absLatidude));
        RealFieldElement ch = (RealFieldElement)((RealFieldElement)((RealFieldElement)cosCoef.multiply(this.chAmplitudeFunction.value(absLatidude))).negate()).add(this.chAverageFunction.value(absLatidude));
        RealFieldElement[] function = (RealFieldElement[])MathArrays.buildArray(field, 2);
        function[0] = this.computeFunction(ah, bh, ch, elevation);
        function[1] = this.computeFunction((RealFieldElement)zero.add(this.awFunction.value(absLatidude)), (RealFieldElement)zero.add(this.bwFunction.value(absLatidude)), (RealFieldElement)zero.add(this.cwFunction.value(absLatidude)), elevation);
        T correction = this.computeHeightCorrection(elevation, height, field);
        function[0] = function[0].add(correction);
        return function;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double computeFunction(double a, double b, double c, double elevation) {
        double sinE = FastMath.sin(elevation);
        double numMP = 1.0 + a / (1.0 + b / (1.0 + c));
        double denMP = sinE + a / (sinE + b / (sinE + c));
        double felevation = numMP / denMP;
        return felevation;
    }

    private <T extends RealFieldElement<T>> T computeFunction(T a, T b, T c, T elevation) {
        T sinE = FastMath.sin(elevation);
        RealFieldElement numMP = (RealFieldElement)((RealFieldElement)a.divide(((RealFieldElement)b.divide(c.add(1.0))).add(1.0))).add(1.0);
        T denMP = a.divide(b.divide(c.add(sinE)).add(sinE)).add(sinE);
        T felevation = numMP.divide(denMP);
        return felevation;
    }

    private double computeHeightCorrection(double elevation, double height) {
        double fixedHeight = FastMath.max(0.0, height);
        double sinE = FastMath.sin(elevation);
        double function = this.computeFunction(2.53E-5, 0.00549, 0.00114, elevation);
        double dmdh = 1.0 / sinE - function;
        double correction = dmdh * (fixedHeight / 1000.0);
        return correction;
    }

    private <T extends RealFieldElement<T>> T computeHeightCorrection(T elevation, T height, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement fixedHeight = FastMath.max(zero, height);
        T sinE = FastMath.sin(elevation);
        RealFieldElement function = this.computeFunction((RealFieldElement)zero.add(2.53E-5), (RealFieldElement)zero.add(0.00549), (RealFieldElement)zero.add(0.00114), elevation);
        RealFieldElement dmdh = ((RealFieldElement)sinE.reciprocal()).subtract(function);
        RealFieldElement correction = (RealFieldElement)dmdh.multiply(fixedHeight.divide(1000.0));
        return (T)correction;
    }
}

