/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.Geoid;
import org.orekit.models.earth.weather.WeatherModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;

public class GlobalPressureTemperature2Model
implements WeatherModel {
    public static final String DEFAULT_SUPPORTED_NAMES = "gpt2_\\d+.grd";
    private static final double G = 9.80665;
    private static final double R = 287.0;
    private static final int DEG_TO_MAS = 3600000;
    private static final AtomicReference<Grid> SHARED_GRID = new AtomicReference<Object>(null);
    private final GridEntry southWest;
    private final GridEntry southEast;
    private final GridEntry northWest;
    private final GridEntry northEast;
    private double[] coefficientsA = null;
    private double latitude;
    private double longitude;
    private double temperature = Double.NaN;
    private double pressure = Double.NaN;
    private double e0 = Double.NaN;
    private final Geoid geoid;
    private final TimeScale utc;

    @DefaultDataContext
    public GlobalPressureTemperature2Model(String supportedNames, double latitude, double longitude, Geoid geoid) {
        this(supportedNames, latitude, longitude, geoid, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public GlobalPressureTemperature2Model(String supportedNames, double latitude, double longitude, Geoid geoid, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this.geoid = geoid;
        this.latitude = latitude;
        this.utc = utc;
        Grid grid = SHARED_GRID.get();
        if (grid == null) {
            Parser parser = new Parser();
            dataProvidersManager.feed(supportedNames, parser);
            SHARED_GRID.compareAndSet(null, parser.grid);
            grid = parser.grid;
        }
        this.longitude = MathUtils.normalizeAngle(longitude, grid.entries[0][0].longitude + Math.PI);
        int southIndex = grid.getSouthIndex(this.latitude);
        int westIndex = grid.getWestIndex(this.longitude);
        this.southWest = grid.entries[southIndex][westIndex];
        this.southEast = grid.entries[southIndex][westIndex + 1];
        this.northWest = grid.entries[southIndex + 1][westIndex];
        this.northEast = grid.entries[southIndex + 1][westIndex + 1];
    }

    @DefaultDataContext
    public GlobalPressureTemperature2Model(double latitude, double longitude, Geoid geoid) {
        this(DEFAULT_SUPPORTED_NAMES, latitude, longitude, geoid);
    }

    public double[] getA() {
        return (double[])this.coefficientsA.clone();
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getPressure() {
        return this.pressure;
    }

    public double getWaterVaporPressure() {
        return this.e0;
    }

    @Override
    public void weatherParameters(double stationHeight, AbsoluteDate currentDate) {
        int dayOfYear = currentDate.getComponents(this.utc).getDate().getDayOfYear();
        this.coefficientsA = new double[]{this.interpolate(e -> this.evaluate(dayOfYear, ((GridEntry)e).ah)) * 0.001, this.interpolate(e -> this.evaluate(dayOfYear, ((GridEntry)e).aw)) * 0.001};
        double undu = this.geoid.getUndulation(this.latitude, this.longitude, currentDate);
        double correctedheight = stationHeight - undu - this.interpolate(e -> ((GridEntry)e).hS);
        double dTdH = this.interpolate(e -> this.evaluate(dayOfYear, ((GridEntry)e).dT)) * 0.001;
        double qv = this.interpolate(e -> this.evaluate(dayOfYear, ((GridEntry)e).qv0)) * 0.001;
        double t0 = this.interpolate(e -> this.evaluate(dayOfYear, ((GridEntry)e).temperature0));
        this.temperature = t0 + dTdH * correctedheight;
        double p0 = this.interpolate(e -> this.evaluate(dayOfYear, ((GridEntry)e).pressure0));
        double exponent = 9.80665 / (dTdH * 287.0);
        this.pressure = p0 * FastMath.pow(1.0 - dTdH / t0 * correctedheight, exponent) * 0.01;
        this.e0 = qv * this.pressure / (0.622 + 0.378 * qv);
    }

    private double interpolate(ToDoubleFunction<GridEntry> gridGetter) {
        double[] xVal = new double[]{this.southWest.longitude, this.southEast.longitude};
        double[] yVal = new double[]{this.southWest.latitude, this.northWest.latitude};
        double[][] fval = new double[][]{{gridGetter.applyAsDouble(this.southWest), gridGetter.applyAsDouble(this.northWest)}, {gridGetter.applyAsDouble(this.southEast), gridGetter.applyAsDouble(this.northEast)}};
        return new BilinearInterpolatingFunction(xVal, yVal, fval).value(this.longitude, this.latitude);
    }

    private double evaluate(int dayOfYear, double[] model) {
        double coef = (double)dayOfYear / 365.25 * 2.0 * Math.PI;
        SinCos sc1 = FastMath.sinCos(coef);
        SinCos sc2 = FastMath.sinCos(2.0 * coef);
        return model[0] + model[1] * sc1.cos() + model[2] * sc1.sin() + model[3] * sc2.cos() + model[4] * sc2.sin();
    }

    private static class GridEntry {
        private final double latitude;
        private final int latKey;
        private final double longitude;
        private final int lonKey;
        private final double hS;
        private final double[] pressure0;
        private final double[] temperature0;
        private final double[] qv0;
        private final double[] dT;
        private final double[] ah;
        private final double[] aw;

        GridEntry(String[] fields) {
            double latDegree = Double.parseDouble(fields[0]);
            double lonDegree = Double.parseDouble(fields[1]);
            this.latitude = FastMath.toRadians(latDegree);
            this.longitude = FastMath.toRadians(lonDegree);
            this.latKey = (int)FastMath.rint(latDegree * 3600000.0);
            this.lonKey = (int)FastMath.rint(lonDegree * 3600000.0);
            this.hS = Double.parseDouble(fields[23]);
            this.pressure0 = this.createModel(fields, 2);
            this.temperature0 = this.createModel(fields, 7);
            this.qv0 = this.createModel(fields, 12);
            this.dT = this.createModel(fields, 17);
            this.ah = this.createModel(fields, 24);
            this.aw = this.createModel(fields, 29);
        }

        GridEntry(double latitude, int latKey, double longitude, int lonKey, double hS, double[] pressure0, double[] temperature0, double[] qv0, double[] dT, double[] ah, double[] aw) {
            this.latitude = latitude;
            this.latKey = latKey;
            this.longitude = longitude;
            this.lonKey = lonKey;
            this.hS = hS;
            this.pressure0 = (double[])pressure0.clone();
            this.temperature0 = (double[])temperature0.clone();
            this.qv0 = (double[])qv0.clone();
            this.dT = (double[])dT.clone();
            this.ah = (double[])ah.clone();
            this.aw = (double[])aw.clone();
        }

        private double[] createModel(String[] fields, int first) {
            return new double[]{Double.parseDouble(fields[first]), Double.parseDouble(fields[first + 1]), Double.parseDouble(fields[first + 2]), Double.parseDouble(fields[first + 3]), Double.parseDouble(fields[first + 4])};
        }
    }

    private static class Grid {
        private final SortedSet<Integer> latitudeSample;
        private final SortedSet<Integer> longitudeSample;
        private final GridEntry[][] entries;

        Grid(SortedSet<Integer> latitudeSample, SortedSet<Integer> longitudeSample, List<GridEntry> loadedEntries, String name) {
            int nA = latitudeSample.size();
            int nO = longitudeSample.size() + 1;
            this.entries = new GridEntry[nA][nO];
            this.latitudeSample = latitudeSample;
            this.longitudeSample = longitudeSample;
            for (GridEntry entry : loadedEntries) {
                int latitudeIndex = latitudeSample.headSet(entry.latKey + 1).size() - 1;
                int longitudeIndex = longitudeSample.headSet(entry.lonKey + 1).size() - 1;
                this.entries[latitudeIndex][longitudeIndex] = entry;
            }
            for (GridEntry[] row : this.entries) {
                for (int longitudeIndex = 0; longitudeIndex < nO - 1; ++longitudeIndex) {
                    if (row[longitudeIndex] != null) continue;
                    throw new OrekitException((Localizable)OrekitMessages.IRREGULAR_OR_INCOMPLETE_GRID, name);
                }
                row[nO - 1] = new GridEntry(row[0].latitude, row[0].latKey, row[0].longitude + Math.PI * 2, row[0].lonKey + 1296000000, row[0].hS, row[0].pressure0, row[0].temperature0, row[0].qv0, row[0].dT, row[0].ah, row[0].aw);
            }
        }

        public int getSouthIndex(double latitude) {
            int latKey = (int)FastMath.rint(FastMath.toDegrees(latitude) * 3600000.0);
            int index = this.latitudeSample.headSet(latKey + 1).size() - 1;
            return FastMath.min(index, this.latitudeSample.size() - 2);
        }

        public int getWestIndex(double longitude) {
            int lonKey = (int)FastMath.rint(FastMath.toDegrees(longitude) * 3600000.0);
            int index = this.longitudeSample.headSet(lonKey + 1).size() - 1;
            return index;
        }
    }

    private static class Parser
    implements DataLoader {
        private Grid grid;

        private Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return this.grid == null;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException {
            TreeSet<Integer> latSample = new TreeSet<Integer>();
            TreeSet<Integer> lonSample = new TreeSet<Integer>();
            ArrayList<GridEntry> entries = new ArrayList<GridEntry>();
            int lineNumber = 0;
            String line = null;
            try (InputStreamReader isr = new InputStreamReader(input, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                String splitter = "\\s+";
                line = br.readLine();
                while (line != null) {
                    ++lineNumber;
                    if ((line = line.trim()).length() > 0 && !line.startsWith("%")) {
                        GridEntry entry = new GridEntry(line.split("\\s+"));
                        latSample.add(entry.latKey);
                        lonSample.add(entry.lonKey);
                        entries.add(entry);
                    }
                    line = br.readLine();
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            this.grid = new Grid(latSample, lonSample, entries, name);
        }
    }
}

