/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCartesianOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private static final Map<Field<? extends RealFieldElement<?>>, FDSFactory<? extends RealFieldElement<?>>> FACTORIES = new HashMap();
    private final transient boolean hasNonKeplerianAcceleration;
    private transient FieldEquinoctialOrbit<T> equinoctial;
    private final Field<T> field;
    private final T zero;
    private final T one;

    public FieldCartesianOrbit(TimeStampedFieldPVCoordinates<T> pvaCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.hasNonKeplerianAcceleration = FieldCartesianOrbit.hasNonKeplerianAcceleration(pvaCoordinates, mu);
        this.equinoctial = null;
        this.field = pvaCoordinates.getPosition().getX().getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
        if (!FACTORIES.containsKey(this.field)) {
            FACTORIES.put(this.field, new FDSFactory<T>(this.field, 1, 1));
        }
    }

    public FieldCartesianOrbit(FieldPVCoordinates<T> pvaCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvaCoordinates), frame, mu);
    }

    public FieldCartesianOrbit(FieldOrbit<T> op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op instanceof FieldEquinoctialOrbit ? (FieldEquinoctialOrbit)op : (op instanceof FieldCartesianOrbit ? ((FieldCartesianOrbit)op).equinoctial : null);
        this.field = op.getA().getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
        if (!FACTORIES.containsKey(this.field)) {
            FACTORIES.put(this.field, new FDSFactory<T>(this.field, 1, 1));
        }
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            this.equinoctial = this.hasDerivatives() ? new FieldEquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu()) : new FieldEquinoctialOrbit(new FieldPVCoordinates(this.getPVCoordinates().getPosition(), this.getPVCoordinates().getVelocity()), this.getFrame(), this.getDate(), this.getMu());
        }
    }

    private FieldVector3D<FieldDerivativeStructure<T>> getPositionDS() {
        FieldVector3D p = this.getPVCoordinates().getPosition();
        FieldVector3D v = this.getPVCoordinates().getVelocity();
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.field);
        return new FieldVector3D<FieldDerivativeStructure<T>>(factory.build(new RealFieldElement[]{p.getX(), v.getX()}), factory.build(new RealFieldElement[]{p.getY(), v.getY()}), factory.build(new RealFieldElement[]{p.getZ(), v.getZ()}));
    }

    private FieldVector3D<FieldDerivativeStructure<T>> getVelocityDS() {
        FieldVector3D v = this.getPVCoordinates().getVelocity();
        FieldVector3D a = this.getPVCoordinates().getAcceleration();
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.field);
        return new FieldVector3D<FieldDerivativeStructure<T>>(factory.build(new RealFieldElement[]{v.getX(), a.getX()}), factory.build(new RealFieldElement[]{v.getY(), a.getY()}), factory.build(new RealFieldElement[]{v.getZ(), a.getZ()}));
    }

    @Override
    public T getA() {
        Object r = this.getPVCoordinates().getPosition().getNorm();
        Object V2 = this.getPVCoordinates().getVelocity().getNormSq();
        return (T)((RealFieldElement)r.divide(((RealFieldElement)((RealFieldElement)((RealFieldElement)r.negate()).multiply(V2)).divide(this.getMu())).add(2.0)));
    }

    @Override
    public T getADot() {
        if (this.hasDerivatives()) {
            FieldDerivativeStructure<T> r = this.getPositionDS().getNorm();
            FieldDerivativeStructure<T> V2 = this.getVelocityDS().getNormSq();
            FieldDerivativeStructure<T> a = r.divide((FieldDerivativeStructure<T>)((FieldDerivativeStructure)r.multiply(V2).divide(this.getMu()).subtract(2.0)).negate());
            return a.getPartialDerivative(1);
        }
        return null;
    }

    @Override
    public T getE() {
        RealFieldElement muA = (RealFieldElement)this.getA().multiply(this.getMu());
        if (muA.getReal() > 0.0) {
            FieldVector3D pvP = this.getPVCoordinates().getPosition();
            FieldVector3D pvV = this.getPVCoordinates().getVelocity();
            RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)pvP.getNorm().multiply(pvV.getNormSq())).divide(this.getMu());
            RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(muA.sqrt());
            RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
            return (T)((RealFieldElement)eCE.multiply(eCE).add(eSE.multiply(eSE)).sqrt());
        }
        FieldVector3D pvM = this.getPVCoordinates().getMomentum();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)pvM.getNormSq().divide((RealFieldElement)muA).negate()).add(1.0)).sqrt());
    }

    @Override
    public T getEDot() {
        if (this.hasDerivatives()) {
            FieldVector3D<FieldDerivativeStructure<T>> pvP = this.getPositionDS();
            FieldVector3D<FieldDerivativeStructure<T>> pvV = this.getVelocityDS();
            FieldDerivativeStructure<T> r = this.getPositionDS().getNorm();
            FieldDerivativeStructure<T> V2 = this.getVelocityDS().getNormSq();
            FieldDerivativeStructure<T> rV2OnMu = r.multiply(V2).divide(this.getMu());
            FieldDerivativeStructure a = r.divide((FieldDerivativeStructure<T>)((FieldDerivativeStructure)rV2OnMu.negate()).add(2.0));
            FieldDerivativeStructure<T> eSE = FieldVector3D.dotProduct(pvP, pvV).divide((FieldDerivativeStructure<T>)a.multiply(this.getMu()).sqrt());
            Object eCE = rV2OnMu.subtract(1.0);
            Object e = ((FieldDerivativeStructure)eCE).multiply(eCE).add(eSE.multiply(eSE)).sqrt();
            return ((FieldDerivativeStructure)e).getPartialDerivative(1);
        }
        return null;
    }

    @Override
    public T getI() {
        return FieldVector3D.angle(new FieldVector3D<T>(this.zero, this.zero, this.one), this.getPVCoordinates().getMomentum());
    }

    @Override
    public T getIDot() {
        if (this.hasDerivatives()) {
            FieldVector3D<FieldDerivativeStructure<T>> momentum = FieldVector3D.crossProduct(this.getPositionDS(), this.getVelocityDS());
            FieldDerivativeStructure<T> i = FieldVector3D.angle(Vector3D.PLUS_K, momentum);
            return i.getPartialDerivative(1);
        }
        return null;
    }

    @Override
    public T getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public T getEquinoctialExDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialExDot();
    }

    @Override
    public T getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public T getEquinoctialEyDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEyDot();
    }

    @Override
    public T getHx() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)w.getY().negate()).divide(w.getZ().add(1.0)));
    }

    @Override
    public T getHxDot() {
        if (this.hasDerivatives()) {
            FieldVector3D<FieldDerivativeStructure<T>> w = FieldVector3D.crossProduct(this.getPositionDS(), this.getVelocityDS()).normalize();
            double x = w.getX().getValue().getReal();
            double y = w.getY().getValue().getReal();
            double z = w.getZ().getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((RealFieldElement)this.zero.add(Double.NaN));
            }
            FieldDerivativeStructure hx = ((FieldDerivativeStructure)w.getY().negate()).divide(w.getZ().add(1.0));
            return hx.getPartialDerivative(1);
        }
        return null;
    }

    @Override
    public T getHy() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)w.getX().divide(w.getZ().add(1.0)));
    }

    @Override
    public T getHyDot() {
        if (this.hasDerivatives()) {
            FieldVector3D<FieldDerivativeStructure<T>> w = FieldVector3D.crossProduct(this.getPositionDS(), this.getVelocityDS()).normalize();
            double x = w.getX().getValue().getReal();
            double y = w.getY().getValue().getReal();
            double z = w.getZ().getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((RealFieldElement)this.zero.add(Double.NaN));
            }
            FieldDerivativeStructure<T> hy = w.getX().divide((FieldDerivativeStructure<T>)w.getZ().add(1.0));
            return hy.getPartialDerivative(1);
        }
        return null;
    }

    @Override
    public T getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public T getLvDot() {
        this.initEquinoctial();
        return this.equinoctial.getLvDot();
    }

    @Override
    public T getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public T getLEDot() {
        this.initEquinoctial();
        return this.equinoctial.getLEDot();
    }

    @Override
    public T getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    public T getLMDot() {
        this.initEquinoctial();
        return this.equinoctial.getLMDot();
    }

    @Override
    public boolean hasDerivatives() {
        return this.hasNonKeplerianAcceleration;
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(T dt) {
        FieldPVCoordinates<T> shiftedPV = this.getA().getReal() < 0.0 ? this.shiftPVHyperbolic(dt) : this.shiftPVElliptic(dt);
        return new FieldCartesianOrbit<T>(shiftedPV, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
    }

    @Override
    public FieldCartesianOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        TimeStampedFieldPVCoordinates<T> interpolated = TimeStampedFieldPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_PVA, sample.map(orbit -> orbit.getPVCoordinates()));
        return new FieldCartesianOrbit<T>(interpolated, this.getFrame(), date, this.getMu());
    }

    private FieldPVCoordinates<T> shiftPVElliptic(T dt) {
        FieldVector3D pvP = this.getPVCoordinates().getPosition();
        FieldVector3D pvV = this.getPVCoordinates().getVelocity();
        Object r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply(pvV.getNormSq())).divide(this.getMu());
        RealFieldElement a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)a.multiply(this.getMu())).sqrt());
        RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement e2 = eCE.multiply(eCE).add(eSE.multiply(eSE));
        FieldVector3D u = pvP.normalize();
        FieldVector3D v = FieldVector3D.crossProduct(FieldVector3D.crossProduct(pvP, pvV), u).normalize();
        RealFieldElement ex = eCE.subtract(e2).multiply(a).divide(r);
        RealFieldElement s = (RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt();
        RealFieldElement ey = ((RealFieldElement)s.negate()).multiply(eSE).multiply(a).divide(r);
        RealFieldElement beta = (RealFieldElement)((RealFieldElement)s.add(1.0)).reciprocal();
        RealFieldElement thetaE0 = ey.add(eSE.multiply(beta).multiply(ex)).atan2(r.divide(a).add(ex).subtract(eSE.multiply(beta).multiply(ey)));
        RealFieldElement thetaM0 = (RealFieldElement)((RealFieldElement)thetaE0.subtract(ex.multiply(thetaE0.sin()))).add(ey.multiply(thetaE0.cos()));
        RealFieldElement sqrtMmuOA = (RealFieldElement)((RealFieldElement)((RealFieldElement)a.reciprocal()).multiply(this.getMu())).sqrt();
        RealFieldElement thetaM1 = (RealFieldElement)thetaM0.add(sqrtMmuOA.divide(a).multiply(dt));
        RealFieldElement thetaE1 = this.meanToEccentric(thetaM1, ex, ey);
        RealFieldElement cTE = (RealFieldElement)thetaE1.cos();
        RealFieldElement sTE = (RealFieldElement)thetaE1.sin();
        RealFieldElement exey = ex.multiply(ey);
        RealFieldElement exCeyS = ex.multiply(cTE).add(ey.multiply(sTE));
        RealFieldElement x = a.multiply(((RealFieldElement)((RealFieldElement)beta.multiply(ey).multiply(ey).negate()).add(1.0)).multiply(cTE).add(beta.multiply(exey).multiply(sTE)).subtract(ex));
        RealFieldElement y = a.multiply(((RealFieldElement)((RealFieldElement)beta.multiply(ex).multiply(ex).negate()).add(1.0)).multiply(sTE).add(beta.multiply(exey).multiply(cTE)).subtract(ey));
        RealFieldElement factor = (RealFieldElement)sqrtMmuOA.divide(((RealFieldElement)exCeyS.negate()).add(1.0));
        RealFieldElement xDot = factor.multiply(beta.multiply(ey).multiply(exCeyS).subtract(sTE));
        RealFieldElement yDot = factor.multiply(cTE.subtract(beta.multiply(ex).multiply(exCeyS)));
        FieldVector3D<RealFieldElement> shiftedP = new FieldVector3D<RealFieldElement>(x, u, y, v);
        FieldVector3D<RealFieldElement> shiftedV = new FieldVector3D<RealFieldElement>(xDot, u, yDot, v);
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D<RealFieldElement> nonKeplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)this.getPVCoordinates().getAcceleration(), (RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply(r2)).reciprocal()).multiply(this.getMu()), (FieldVector3D<RealFieldElement>)pvP);
            FieldVector3D<RealFieldElement> fixedP = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, shiftedP, (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D<RealFieldElement> fixedV = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, shiftedV, (RealFieldElement)dt, nonKeplerianAcceleration);
            FieldVector3D<RealFieldElement> fixedA = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)fixedR.multiply(fixedR2).reciprocal()).multiply(this.getMu().negate()), shiftedP, (RealFieldElement)this.one, nonKeplerianAcceleration);
            return new FieldPVCoordinates<RealFieldElement>(fixedP, fixedV, fixedA);
        }
        return new FieldPVCoordinates<RealFieldElement>(shiftedP, shiftedV);
    }

    private FieldPVCoordinates<T> shiftPVHyperbolic(T dt) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D pvP = pv.getPosition();
        FieldVector3D pvV = pv.getVelocity();
        FieldVector3D pvM = pv.getMomentum();
        Object r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply(pvV.getNormSq())).divide(this.getMu());
        Object a = this.getA();
        RealFieldElement muA = (RealFieldElement)a.multiply(this.getMu());
        RealFieldElement e = (RealFieldElement)this.one.subtract((RealFieldElement)FieldVector3D.dotProduct(pvM, pvM).divide((RealFieldElement)muA)).sqrt();
        RealFieldElement sqrt = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.add(1.0)).divide(e.subtract(1.0))).sqrt();
        RealFieldElement eSH = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)muA.negate()).sqrt());
        RealFieldElement eCH = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement H0 = (RealFieldElement)((RealFieldElement)eCH.add(eSH).divide(eCH.subtract(eSH)).log()).divide(2.0);
        RealFieldElement M0 = ((RealFieldElement)e.multiply(H0.sinh())).subtract(H0);
        RealFieldElement v0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)sqrt.multiply(((RealFieldElement)H0.divide(2.0)).tanh())).atan()).multiply(2);
        FieldVector3D<RealFieldElement> p = new FieldRotation<RealFieldElement>(pvM, v0, RotationConvention.FRAME_TRANSFORM).applyTo(pvP).normalize();
        FieldVector3D<RealFieldElement> q = FieldVector3D.crossProduct(pvM, p).normalize();
        RealFieldElement M1 = (RealFieldElement)M0.add(this.getKeplerianMeanMotion().multiply(dt));
        RealFieldElement H1 = this.meanToHyperbolicEccentric(M1, e);
        RealFieldElement cH = (RealFieldElement)H1.cosh();
        RealFieldElement sH = (RealFieldElement)H1.sinh();
        RealFieldElement sE2m1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.subtract(1.0)).multiply(e.add(1.0))).sqrt();
        RealFieldElement x = a.multiply((RealFieldElement)cH.subtract(e));
        RealFieldElement y = ((RealFieldElement)a.negate()).multiply(sE2m1).multiply(sH);
        RealFieldElement factor = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getMu().divide(a.negate())).sqrt()).divide(e.multiply(cH).subtract(1.0));
        RealFieldElement xDot = ((RealFieldElement)factor.negate()).multiply(sH);
        RealFieldElement yDot = factor.multiply(sE2m1).multiply(cH);
        FieldVector3D<RealFieldElement> shiftedP = new FieldVector3D<RealFieldElement>(x, p, y, q);
        FieldVector3D<RealFieldElement> shiftedV = new FieldVector3D<RealFieldElement>(xDot, p, yDot, q);
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D<RealFieldElement> nonKeplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)this.getPVCoordinates().getAcceleration(), (RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply(r2)).reciprocal()).multiply(this.getMu()), (FieldVector3D<RealFieldElement>)pvP);
            FieldVector3D<RealFieldElement> fixedP = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, shiftedP, (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D<RealFieldElement> fixedV = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, shiftedV, (RealFieldElement)dt, nonKeplerianAcceleration);
            FieldVector3D<RealFieldElement> fixedA = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)fixedR.multiply(fixedR2).reciprocal()).multiply(this.getMu().negate()), shiftedP, (RealFieldElement)this.one, nonKeplerianAcceleration);
            return new FieldPVCoordinates<RealFieldElement>(fixedP, fixedV, fixedA);
        }
        return new FieldPVCoordinates<RealFieldElement>(shiftedP, shiftedV);
    }

    private T meanToEccentric(T thetaM, T ex, T ey) {
        RealFieldElement thetaE = thetaM;
        RealFieldElement thetaEMthetaM = this.zero;
        int iter = 0;
        do {
            RealFieldElement cosThetaE = (RealFieldElement)thetaE.cos();
            RealFieldElement sinThetaE = (RealFieldElement)thetaE.sin();
            RealFieldElement f2 = ex.multiply((RealFieldElement)sinThetaE).subtract(ey.multiply((RealFieldElement)cosThetaE));
            RealFieldElement f1 = this.one.subtract((RealFieldElement)ex.multiply((RealFieldElement)cosThetaE)).subtract(ey.multiply((RealFieldElement)sinThetaE));
            RealFieldElement f0 = thetaEMthetaM.subtract((RealFieldElement)f2);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2.0);
            RealFieldElement shift = f0.multiply(f12).divide(f1.multiply(f12).subtract(f0.multiply(f2)));
            thetaEMthetaM = thetaEMthetaM.subtract((RealFieldElement)shift);
            thetaE = (RealFieldElement)thetaM.add(thetaEMthetaM);
            if (!(FastMath.abs(shift.getReal()) <= 1.0E-12)) continue;
            return (T)thetaE;
        } while (++iter < 50);
        throw new MathIllegalStateException(LocalizedCoreFormats.CONVERGENCE_FAILED, new Object[0]);
    }

    private T meanToHyperbolicEccentric(T M, T ecc) {
        RealFieldElement H = ecc.getReal() < 1.6 ? (-Math.PI < M.getReal() && M.getReal() < 0.0 || M.getReal() > Math.PI ? (RealFieldElement)M.subtract(ecc) : (RealFieldElement)M.add(ecc)) : (ecc.getReal() < 3.6 && FastMath.abs(M.getReal()) > Math.PI ? (RealFieldElement)M.subtract(ecc.copySign(M)) : (RealFieldElement)M.divide(ecc.subtract(1.0)));
        int iter = 0;
        do {
            RealFieldElement f3 = (RealFieldElement)ecc.multiply(H.cosh());
            RealFieldElement f2 = (RealFieldElement)ecc.multiply(H.sinh());
            RealFieldElement f1 = (RealFieldElement)f3.subtract(1.0);
            RealFieldElement f0 = (RealFieldElement)f2.subtract(H).subtract(M);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2);
            RealFieldElement d = f0.divide(f12);
            RealFieldElement fdf = f1.subtract(d.multiply(f2));
            RealFieldElement ds = f0.divide(fdf);
            RealFieldElement shift = (RealFieldElement)f0.divide(fdf.add(ds.multiply(ds).multiply(f3.divide(6.0))));
            H = H.subtract(shift);
            if (!(FastMath.abs(shift.getReal()) <= 1.0E-12)) continue;
            return (T)H;
        } while (++iter < 50);
        throw new MathIllegalStateException(OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, iter);
    }

    private T[][] create6x6Identity() {
        RealFieldElement[][] identity = (RealFieldElement[][])MathArrays.buildArray(this.field, 6, 6);
        for (int i = 0; i < 6; ++i) {
            Arrays.fill(identity[i], this.zero);
            identity[i][i] = this.one;
        }
        return identity;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D velocity = pv.getVelocity();
        pDot[0] = (RealFieldElement)pDot[0].add(velocity.getX());
        pDot[1] = (RealFieldElement)pDot[1].add(velocity.getY());
        pDot[2] = (RealFieldElement)pDot[2].add(velocity.getZ());
        FieldVector3D position = pv.getPosition();
        Object r2 = position.getNormSq();
        RealFieldElement coeff = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).negate()).multiply(gm);
        pDot[3] = (RealFieldElement)pDot[3].add(coeff.multiply(position.getX()));
        pDot[4] = (RealFieldElement)pDot[4].add(coeff.multiply(position.getY()));
        pDot[5] = (RealFieldElement)pDot[5].add(coeff.multiply(position.getZ()));
    }

    public String toString() {
        String comma = ", ";
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        return "Cartesian parameters: {P(" + p.getX() + ", " + p.getY() + ", " + p.getZ() + "), V(" + v.getX() + ", " + v.getY() + ", " + v.getZ() + ")}";
    }

    @Override
    public CartesianOrbit toOrbit() {
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        AbsoluteDate date = this.getPVCoordinates().getDate().toAbsoluteDate();
        if (this.hasDerivatives()) {
            return new CartesianOrbit(pv, this.getFrame(), date, this.getMu().getReal());
        }
        return new CartesianOrbit(new PVCoordinates(pv.getPosition(), pv.getVelocity()), this.getFrame(), date, this.getMu().getReal());
    }
}

