/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEquinoctialOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private static final Map<Field<? extends RealFieldElement<?>>, FDSFactory<? extends RealFieldElement<?>>> FACTORIES = new HashMap();
    private final T a;
    private final T ex;
    private final T ey;
    private final T hx;
    private final T hy;
    private final T lv;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T hxDot;
    private final T hyDot;
    private final T lvDot;
    private FieldPVCoordinates<T> partialPV;
    private Field<T> field;
    private T zero;
    private T one;

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, hx, hy, l, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, T aDot, T exDot, T eyDot, T hxDot, T hyDot, T lDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        this.field = a.getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        if (!FACTORIES.containsKey(a.getField())) {
            FACTORIES.put(a.getField(), new FDSFactory(a.getField(), 1, 1));
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.hx = hx;
        this.hxDot = hxDot;
        this.hy = hy;
        this.hyDot = hyDot;
        if (this.hasDerivatives()) {
            FieldDerivativeStructure lvDS;
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(a.getField());
            FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{ex, exDot});
            FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{ey, eyDot});
            FieldDerivativeStructure lDS = factory.build(new RealFieldElement[]{l, lDot});
            switch (type) {
                case MEAN: {
                    lvDS = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(lDS, exDS, eyDS), exDS, eyDS);
                    break;
                }
                case ECCENTRIC: {
                    lvDS = FieldEquinoctialOrbit.eccentricToTrue(lDS, exDS, eyDS);
                    break;
                }
                case TRUE: {
                    lvDS = lDS;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.lv = lvDS.getValue();
            this.lvDot = lvDS.getPartialDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.lv = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(l, ex, ey), ex, ey);
                    break;
                }
                case ECCENTRIC: {
                    this.lv = FieldEquinoctialOrbit.eccentricToTrue(l, ex, ey);
                    break;
                }
                case TRUE: {
                    this.lv = l;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.lvDot = null;
        }
        this.partialPV = null;
    }

    public FieldEquinoctialOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.field = pvCoordinates.getPosition().getX().getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D<RealFieldElement> pvA = pvCoordinates.getAcceleration();
        Object r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        Object V2 = pvV.getNormSq();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply(V2)).divide(mu);
        if (rV2OnMu.getReal() > 2.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        FieldVector3D w = pvCoordinates.getMomentum().normalize();
        RealFieldElement d = (RealFieldElement)this.one.divide(this.one.add(w.getZ()));
        this.hx = (RealFieldElement)((RealFieldElement)d.negate()).multiply(w.getY());
        this.hy = (RealFieldElement)d.multiply(w.getX());
        RealFieldElement cLv = ((RealFieldElement)pvP.getX().subtract(((RealFieldElement)d.multiply(pvP.getZ())).multiply(w.getX()))).divide(r);
        RealFieldElement sLv = ((RealFieldElement)pvP.getY().subtract(((RealFieldElement)d.multiply(pvP.getZ())).multiply(w.getY()))).divide(r);
        this.lv = sLv.atan2(cLv);
        this.a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)this.a.multiply(mu)).sqrt());
        RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement e2 = eCE.multiply(eCE).add(eSE.multiply(eSE));
        RealFieldElement f = eCE.subtract(e2);
        RealFieldElement g = ((RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt()).multiply(eSE);
        this.ex = this.a.multiply((RealFieldElement)f.multiply(cLv).add(g.multiply(sLv))).divide(r);
        this.ey = this.a.multiply((RealFieldElement)f.multiply(sLv).subtract(g.multiply(cLv))).divide(r);
        this.partialPV = pvCoordinates;
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (FieldEquinoctialOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.a.getField(), 6, 6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D<RealFieldElement> keplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply(r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D<RealFieldElement> nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            RealFieldElement aX = nonKeplerianAcceleration.getX();
            RealFieldElement aY = nonKeplerianAcceleration.getY();
            RealFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = jacobian[0][3].multiply(aX).add(jacobian[0][4].multiply(aY)).add(jacobian[0][5].multiply(aZ));
            this.exDot = jacobian[1][3].multiply(aX).add(jacobian[1][4].multiply(aY)).add(jacobian[1][5].multiply(aZ));
            this.eyDot = jacobian[2][3].multiply(aX).add(jacobian[2][4].multiply(aY)).add(jacobian[2][5].multiply(aZ));
            this.hxDot = jacobian[3][3].multiply(aX).add(jacobian[3][4].multiply(aY)).add(jacobian[3][5].multiply(aZ));
            this.hyDot = jacobian[4][3].multiply(aX).add(jacobian[4][4].multiply(aY)).add(jacobian[4][5].multiply(aZ));
            RealFieldElement lMDot = this.getKeplerianMeanMotion().add((RealFieldElement)jacobian[5][3].multiply(aX)).add(jacobian[5][4].multiply(aY)).add(jacobian[5][5].multiply(aZ));
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
            FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
            FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
            FieldDerivativeStructure lMDS = factory.build(new RealFieldElement[]{this.getLM(), lMDot});
            FieldDerivativeStructure lvDS = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(lMDS, exDS, eyDS), exDS, eyDS);
            this.lvDot = lvDS.getPartialDerivative(1);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.hxDot = null;
            this.hyDot = null;
            this.lvDot = null;
        }
    }

    public FieldEquinoctialOrbit(FieldPVCoordinates<T> pvCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvCoordinates), frame, mu);
    }

    public FieldEquinoctialOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.ex = op.getEquinoctialEx();
        this.ey = op.getEquinoctialEy();
        this.hx = op.getHx();
        this.hy = op.getHy();
        this.lv = op.getLv();
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        this.aDot = op.getADot();
        this.exDot = op.getEquinoctialExDot();
        this.eyDot = op.getEquinoctialEyDot();
        this.hxDot = op.getHxDot();
        this.hyDot = op.getHyDot();
        this.lvDot = op.getLvDot();
        this.field = this.a.getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.EQUINOCTIAL;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        return this.ex;
    }

    @Override
    public T getEquinoctialExDot() {
        return this.exDot;
    }

    @Override
    public T getEquinoctialEy() {
        return this.ey;
    }

    @Override
    public T getEquinoctialEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        return this.hx;
    }

    @Override
    public T getHxDot() {
        return this.hxDot;
    }

    @Override
    public T getHy() {
        return this.hy;
    }

    @Override
    public T getHyDot() {
        return this.hyDot;
    }

    @Override
    public T getLv() {
        return this.lv;
    }

    @Override
    public T getLvDot() {
        return this.lvDot;
    }

    @Override
    public T getLE() {
        return FieldEquinoctialOrbit.trueToEccentric(this.lv, this.ex, this.ey);
    }

    @Override
    public T getLEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure lVDS = factory.build(new RealFieldElement[]{this.lv, this.lvDot});
        FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
        FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
        FieldDerivativeStructure lEDS = FieldEquinoctialOrbit.trueToEccentric(lVDS, exDS, eyDS);
        return lEDS.getPartialDerivative(1);
    }

    @Override
    public T getLM() {
        return FieldEquinoctialOrbit.eccentricToMean(FieldEquinoctialOrbit.trueToEccentric(this.lv, this.ex, this.ey), this.ex, this.ey);
    }

    @Override
    public T getLMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure lVDS = factory.build(new RealFieldElement[]{this.lv, this.lvDot});
        FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
        FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
        FieldDerivativeStructure lMDS = FieldEquinoctialOrbit.eccentricToMean(FieldEquinoctialOrbit.trueToEccentric(lVDS, exDS, eyDS), exDS, eyDS);
        return lMDS.getPartialDerivative(1);
    }

    public T getL(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getLM() : (type == PositionAngle.ECCENTRIC ? this.getLE() : this.getLv());
    }

    public T getLDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getLMDot() : (type == PositionAngle.ECCENTRIC ? this.getLEDot() : this.getLvDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    public static <T extends RealFieldElement<T>> T eccentricToTrue(T lE, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex).add(ey.multiply(ey)).negate()).add(1.0)).sqrt();
        RealFieldElement cosLE = (RealFieldElement)lE.cos();
        RealFieldElement sinLE = (RealFieldElement)lE.sin();
        RealFieldElement num = ex.multiply((RealFieldElement)sinLE).subtract(ey.multiply((RealFieldElement)cosLE));
        RealFieldElement den = ((RealFieldElement)epsilon.add(1.0)).subtract(ex.multiply((RealFieldElement)cosLE)).subtract(ey.multiply((RealFieldElement)sinLE));
        return (T)((RealFieldElement)lE.add(((RealFieldElement)num.divide(den).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T trueToEccentric(T lv, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex).add(ey.multiply(ey)).negate()).add(1.0)).sqrt();
        RealFieldElement cosLv = (RealFieldElement)lv.cos();
        RealFieldElement sinLv = (RealFieldElement)lv.sin();
        RealFieldElement num = ey.multiply((RealFieldElement)cosLv).subtract(ex.multiply((RealFieldElement)sinLv));
        RealFieldElement den = ((RealFieldElement)epsilon.add(1.0)).add(ex.multiply((RealFieldElement)cosLv)).add(ey.multiply((RealFieldElement)sinLv));
        return (T)((RealFieldElement)lv.add(((RealFieldElement)num.divide(den).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T meanToEccentric(T lM, T ex, T ey) {
        Object lE = lM;
        RealFieldElement shift = (RealFieldElement)lM.getField().getZero();
        RealFieldElement lEmlM = (RealFieldElement)lM.getField().getZero();
        RealFieldElement cosLE = (RealFieldElement)lE.cos();
        RealFieldElement sinLE = (RealFieldElement)lE.sin();
        int iter = 0;
        do {
            RealFieldElement f2 = ex.multiply((RealFieldElement)sinLE).subtract(ey.multiply((RealFieldElement)cosLE));
            RealFieldElement f1 = (RealFieldElement)((RealFieldElement)ex.multiply((RealFieldElement)cosLE).add(ey.multiply((RealFieldElement)sinLE)).negate()).add(1.0);
            RealFieldElement f0 = lEmlM.subtract(f2);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2.0);
            shift = f0.multiply(f12).divide(f1.multiply(f12).subtract(f0.multiply(f2)));
            lEmlM = lEmlM.subtract(shift);
            lE = lM.add((RealFieldElement)lEmlM);
            cosLE = (RealFieldElement)lE.cos();
            sinLE = (RealFieldElement)lE.sin();
        } while (++iter < 50 && FastMath.abs(shift.getReal()) > 1.0E-12);
        return (T)lE;
    }

    public static <T extends RealFieldElement<T>> T eccentricToMean(T lE, T ex, T ey) {
        return (T)((RealFieldElement)((RealFieldElement)lE.subtract(ex.multiply(lE.sin()))).add(ey.multiply(lE.cos())));
    }

    @Override
    public T getE() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.exDot)).add(this.ey.multiply(this.eyDot))).divide(((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt()));
    }

    @Override
    public T getI() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.hx.multiply(this.hx)).add(this.hy.multiply(this.hy))).sqrt()).atan()).multiply(2));
    }

    @Override
    public T getIDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        RealFieldElement h2 = (RealFieldElement)((RealFieldElement)this.hx.multiply(this.hx)).add(this.hy.multiply(this.hy));
        RealFieldElement h = (RealFieldElement)h2.sqrt();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.hx.multiply(this.hxDot)).add(this.hy.multiply(this.hyDot))).multiply(2)).divide(h.multiply(h2.add(1.0))));
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T lE = this.getLE();
        RealFieldElement hx2 = (RealFieldElement)this.hx.multiply(this.hx);
        RealFieldElement hy2 = (RealFieldElement)this.hy.multiply(this.hy);
        RealFieldElement factH = this.one.divide((RealFieldElement)((RealFieldElement)hx2.add(1.0)).add(hy2));
        RealFieldElement ux = ((RealFieldElement)hx2.add(1.0)).subtract(hy2).multiply(factH);
        RealFieldElement uy = (RealFieldElement)((RealFieldElement)this.hx.multiply(this.hy)).multiply(factH).multiply(2);
        RealFieldElement uz = ((RealFieldElement)this.hy.multiply((int)-2)).multiply(factH);
        RealFieldElement vx = uy;
        RealFieldElement vy = ((RealFieldElement)hy2.subtract(hx2).add(1.0)).multiply(factH);
        RealFieldElement vz = (RealFieldElement)this.hx.multiply((RealFieldElement)factH).multiply(2);
        RealFieldElement ex2 = (RealFieldElement)this.ex.multiply(this.ex);
        RealFieldElement exey = (RealFieldElement)this.ex.multiply(this.ey);
        RealFieldElement ey2 = (RealFieldElement)this.ey.multiply(this.ey);
        RealFieldElement e2 = ex2.add(ey2);
        RealFieldElement eta = (RealFieldElement)((RealFieldElement)this.one.subtract((RealFieldElement)e2).sqrt()).add(1.0);
        RealFieldElement beta = this.one.divide((RealFieldElement)eta);
        RealFieldElement cLe = (RealFieldElement)lE.cos();
        RealFieldElement sLe = (RealFieldElement)lE.sin();
        RealFieldElement exCeyS = this.ex.multiply((RealFieldElement)cLe).add(this.ey.multiply((RealFieldElement)sLe));
        RealFieldElement x = (RealFieldElement)this.a.multiply(this.one.subtract((RealFieldElement)beta.multiply(ey2)).multiply(cLe).add(beta.multiply(exey).multiply(sLe)).subtract(this.ex));
        RealFieldElement y = (RealFieldElement)this.a.multiply(this.one.subtract((RealFieldElement)beta.multiply(ex2)).multiply(sLe).add(beta.multiply(exey).multiply(cLe)).subtract(this.ey));
        RealFieldElement factor = ((RealFieldElement)((RealFieldElement)this.getMu().divide(this.a)).sqrt()).divide(this.one.subtract((RealFieldElement)exCeyS));
        RealFieldElement xdot = factor.multiply(((RealFieldElement)sLe.negate()).add(((RealFieldElement)beta.multiply(this.ey)).multiply(exCeyS)));
        RealFieldElement ydot = factor.multiply(cLe.subtract(((RealFieldElement)beta.multiply(this.ex)).multiply(exCeyS)));
        FieldVector3D<RealFieldElement> position = new FieldVector3D<RealFieldElement>(x.multiply(ux).add(y.multiply(vx)), x.multiply(uy).add(y.multiply(vy)), x.multiply(uz).add(y.multiply(vz)));
        FieldVector3D<RealFieldElement> velocity = new FieldVector3D<RealFieldElement>(xdot.multiply(ux).add(ydot.multiply(vx)), xdot.multiply(uy).add(ydot.multiply(vy)), xdot.multiply(uz).add(ydot.multiply(vz)));
        this.partialPV = new FieldPVCoordinates<RealFieldElement>(position, velocity);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        RealFieldElement[][] dCdP = (RealFieldElement[][])MathArrays.buildArray(this.a.getField(), 6, 6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        RealFieldElement nonKeplerianMeanMotion = (RealFieldElement)this.getLMDot().subtract(this.getKeplerianMeanMotion());
        RealFieldElement nonKeplerianAx = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.exDot))).add(dCdP[3][2].multiply(this.eyDot))).add(dCdP[3][3].multiply(this.hxDot))).add(dCdP[3][4].multiply(this.hyDot))).add(dCdP[3][5].multiply(nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAy = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.exDot))).add(dCdP[4][2].multiply(this.eyDot))).add(dCdP[4][3].multiply(this.hxDot))).add(dCdP[4][4].multiply(this.hyDot))).add(dCdP[4][5].multiply(nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAz = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.exDot))).add(dCdP[5][2].multiply(this.eyDot))).add(dCdP[5][3].multiply(this.hxDot))).add(dCdP[5][4].multiply(this.hyDot))).add(dCdP[5][5].multiply(nonKeplerianMeanMotion));
        return new FieldVector3D<RealFieldElement>(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        Object r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D<RealFieldElement> keplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D<RealFieldElement> acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates<RealFieldElement>(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(T dt) {
        FieldEquinoctialOrbit<RealFieldElement> keplerianShifted = new FieldEquinoctialOrbit<RealFieldElement>((RealFieldElement)this.a, (RealFieldElement)this.ex, (RealFieldElement)this.ey, (RealFieldElement)this.hx, (RealFieldElement)this.hy, (RealFieldElement)this.getLM().add(this.getKeplerianMeanMotion().multiply(dt)), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (RealFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D<RealFieldElement> fixedP = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)keplerianShifted.partialPV.getPosition(), (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), (FieldVector3D<RealFieldElement>)nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D<T> fixedV = new FieldVector3D<T>(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D<RealFieldElement> fixedA = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)fixedR2.multiply(fixedR).reciprocal()).multiply(this.getMu().negate()), (FieldVector3D<RealFieldElement>)keplerianShifted.partialPV.getPosition(), (RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)nonKeplerianAcceleration);
            return new FieldEquinoctialOrbit<RealFieldElement>(new TimeStampedFieldPVCoordinates<RealFieldElement>(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), (RealFieldElement)keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldEquinoctialOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        RealFieldElement previousLm = (RealFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousLm;
            FieldEquinoctialOrbit equi = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(orbit);
            if (previousDate == null) {
                continuousLm = equi.getLM();
            } else {
                Object dt = equi.getDate().durationFrom(previousDate);
                RealFieldElement keplerLm = previousLm.add((RealFieldElement)equi.getKeplerianMeanMotion().multiply(dt));
                continuousLm = MathUtils.normalizeAngle(equi.getLM(), keplerLm);
            }
            previousDate = equi.getDate();
            previousLm = continuousLm;
            RealFieldElement[] toAdd = (RealFieldElement[])MathArrays.buildArray(this.field, 6);
            toAdd[0] = equi.getA();
            toAdd[1] = equi.getEquinoctialEx();
            toAdd[2] = equi.getEquinoctialEy();
            toAdd[3] = equi.getHx();
            toAdd[4] = equi.getHy();
            toAdd[5] = continuousLm;
            if (useDerivatives) {
                RealFieldElement[] toAddDot = (RealFieldElement[])MathArrays.buildArray(this.one.getField(), 6);
                toAddDot[0] = equi.getADot();
                toAddDot[1] = equi.getEquinoctialExDot();
                toAddDot[2] = equi.getEquinoctialEyDot();
                toAddDot[3] = equi.getHxDot();
                toAddDot[4] = equi.getHyDot();
                toAddDot[5] = equi.getLMDot();
                interpolator.addSamplePoint((FieldElement)equi.getDate().durationFrom(date), new RealFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint((FieldElement)equi.getDate().durationFrom(date), new RealFieldElement[][]{toAdd});
        }
        RealFieldElement[][] interpolated = (RealFieldElement[][])interpolator.derivatives((FieldElement)this.zero, 1);
        return new FieldEquinoctialOrbit<RealFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<RealFieldElement>)date, (RealFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.field, 6, 6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        T r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement r3 = (RealFieldElement)r.multiply(r2);
        Object mu = this.getMu();
        RealFieldElement sqrtMuA = (RealFieldElement)((RealFieldElement)this.a.multiply(mu)).sqrt();
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        RealFieldElement oMe2 = this.one.subtract((RealFieldElement)e2);
        RealFieldElement epsilon = (RealFieldElement)oMe2.sqrt();
        RealFieldElement beta = (RealFieldElement)this.one.divide(epsilon.add(1.0));
        RealFieldElement ratio = epsilon.multiply(beta);
        RealFieldElement hx2 = (RealFieldElement)this.hx.multiply(this.hx);
        RealFieldElement hy2 = (RealFieldElement)this.hy.multiply(this.hy);
        RealFieldElement hxhy = (RealFieldElement)this.hx.multiply(this.hy);
        FieldVector3D<RealFieldElement> f = new FieldVector3D<RealFieldElement>((RealFieldElement)hx2.subtract(hy2).add(1.0), (RealFieldElement)hxhy.multiply(2), (RealFieldElement)this.hy.multiply((int)-2)).normalize();
        FieldVector3D<RealFieldElement> g = new FieldVector3D<RealFieldElement>((RealFieldElement)hxhy.multiply(2), ((RealFieldElement)hy2.add(1.0)).subtract(hx2), (RealFieldElement)this.hx.multiply((int)2)).normalize();
        FieldVector3D<T> w = FieldVector3D.crossProduct(position, velocity).normalize();
        RealFieldElement x = FieldVector3D.dotProduct(position, f);
        RealFieldElement y = FieldVector3D.dotProduct(position, g);
        RealFieldElement xDot = FieldVector3D.dotProduct(velocity, f);
        RealFieldElement yDot = FieldVector3D.dotProduct(velocity, g);
        RealFieldElement c1 = this.a.divide((RealFieldElement)sqrtMuA.multiply(epsilon));
        RealFieldElement c1N = (RealFieldElement)c1.negate();
        RealFieldElement c2 = this.a.multiply((RealFieldElement)sqrtMuA).multiply(beta).divide(r3);
        RealFieldElement c3 = sqrtMuA.divide(r3.multiply(epsilon));
        FieldVector3D<RealFieldElement> drDotSdEx = new FieldVector3D<RealFieldElement>(c1.multiply(xDot).multiply(yDot).subtract(((RealFieldElement)c2.multiply(this.ey)).multiply(x)).subtract(c3.multiply(x).multiply(y)), f, c1N.multiply(xDot).multiply(xDot).subtract(((RealFieldElement)c2.multiply(this.ey)).multiply(y)).add(c3.multiply(x).multiply(x)), g);
        FieldVector3D<RealFieldElement> drDotSdEy = new FieldVector3D<RealFieldElement>(c1.multiply(yDot).multiply(yDot).add(((RealFieldElement)c2.multiply(this.ex)).multiply(x)).subtract(c3.multiply(y).multiply(y)), f, c1N.multiply(xDot).multiply(yDot).add(((RealFieldElement)c2.multiply(this.ex)).multiply(y)).add(c3.multiply(x).multiply(y)), g);
        FieldVector3D<RealFieldElement> vectorAR = new FieldVector3D<RealFieldElement>(((RealFieldElement)a2.multiply(2)).divide(r3), position);
        FieldVector3D<RealFieldElement> vectorARDot = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)a2.multiply(2)).divide(mu), velocity);
        this.fillHalfRow((RealFieldElement)this.one, vectorAR, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorARDot, jacobian[0], 3);
        RealFieldElement d1 = ((RealFieldElement)this.a.negate()).multiply(ratio).divide(r3);
        RealFieldElement d2 = this.hy.multiply((RealFieldElement)xDot).subtract(this.hx.multiply((RealFieldElement)yDot)).divide(sqrtMuA.multiply(epsilon));
        RealFieldElement d3 = this.hx.multiply((RealFieldElement)y).subtract(this.hy.multiply((RealFieldElement)x)).divide(sqrtMuA);
        FieldVector3D<RealFieldElement> vectorExRDot = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)x.multiply(2)).multiply(yDot).subtract(xDot.multiply(y)).divide(mu), g, (RealFieldElement)((RealFieldElement)y.negate()).multiply(yDot).divide(mu), f, ((RealFieldElement)this.ey.negate()).multiply(d3).divide(epsilon), w);
        this.fillHalfRow(this.ex.multiply((RealFieldElement)d1), position, ((RealFieldElement)this.ey.negate()).multiply(d2), w, epsilon.divide(sqrtMuA), drDotSdEy, jacobian[1], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorExRDot, jacobian[1], 3);
        FieldVector3D<RealFieldElement> vectorEyRDot = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)xDot.multiply(2)).multiply(y).subtract(x.multiply(yDot)).divide(mu), f, (RealFieldElement)((RealFieldElement)x.negate()).multiply(xDot).divide(mu), g, this.ex.multiply((RealFieldElement)d3).divide(epsilon), w);
        this.fillHalfRow(this.ey.multiply((RealFieldElement)d1), position, this.ex.multiply((RealFieldElement)d2), w, ((RealFieldElement)epsilon.negate()).divide(sqrtMuA), drDotSdEx, jacobian[2], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorEyRDot, jacobian[2], 3);
        RealFieldElement h = ((RealFieldElement)hx2.add(1.0)).add(hy2).divide(((RealFieldElement)sqrtMuA.multiply(2)).multiply(epsilon));
        this.fillHalfRow(((RealFieldElement)h.negate()).multiply(xDot), w, jacobian[3], 0);
        this.fillHalfRow(h.multiply(x), w, jacobian[3], 3);
        this.fillHalfRow(((RealFieldElement)h.negate()).multiply(yDot), w, jacobian[4], 0);
        this.fillHalfRow(h.multiply(y), w, jacobian[4], 3);
        RealFieldElement l = ((RealFieldElement)ratio.negate()).divide(sqrtMuA);
        this.fillHalfRow(((RealFieldElement)this.one.negate()).divide(sqrtMuA), velocity, d2, w, (RealFieldElement)l.multiply(this.ex), drDotSdEx, (RealFieldElement)l.multiply(this.ey), drDotSdEy, jacobian[5], 0);
        this.fillHalfRow(((RealFieldElement)this.zero.add(-2.0)).divide(sqrtMuA), position, this.ex.multiply((RealFieldElement)beta), vectorEyRDot, ((RealFieldElement)this.ey.negate()).multiply(beta), vectorExRDot, d3, w, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        T le = this.getLE();
        RealFieldElement cosLe = (RealFieldElement)le.cos();
        RealFieldElement sinLe = (RealFieldElement)le.sin();
        RealFieldElement aOr = this.one.divide((RealFieldElement)this.one.subtract((RealFieldElement)this.ex.multiply((RealFieldElement)cosLe)).subtract(this.ey.multiply((RealFieldElement)sinLe)));
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = aOr.multiply(rowL[j].add(sinLe.multiply(rowEx[j])).subtract(cosLe.multiply(rowEy[j])));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        T le = this.getLE();
        RealFieldElement cosLe = (RealFieldElement)le.cos();
        RealFieldElement sinLe = (RealFieldElement)le.sin();
        RealFieldElement eSinE = this.ex.multiply((RealFieldElement)sinLe).subtract(this.ey.multiply((RealFieldElement)cosLe));
        RealFieldElement ecosE = this.ex.multiply((RealFieldElement)cosLe).add(this.ey.multiply((RealFieldElement)sinLe));
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        RealFieldElement epsilon = (RealFieldElement)this.one.subtract((RealFieldElement)e2).sqrt();
        RealFieldElement onePeps = (RealFieldElement)epsilon.add(1.0);
        RealFieldElement d = onePeps.subtract(ecosE);
        RealFieldElement cT = (RealFieldElement)d.multiply(d).add(eSinE.multiply(eSinE)).divide(2.0);
        RealFieldElement cE = ecosE.multiply(onePeps).subtract(e2);
        RealFieldElement cX = ((RealFieldElement)this.ex.multiply((RealFieldElement)eSinE).divide(epsilon).subtract(this.ey)).add(sinLe.multiply(onePeps));
        RealFieldElement cY = ((RealFieldElement)this.ey.multiply((RealFieldElement)eSinE).divide(epsilon).add(this.ex)).subtract(cosLe.multiply(onePeps));
        RealFieldElement factorLe = cT.add(cE).divide(cT);
        RealFieldElement factorEx = cX.divide(cT);
        RealFieldElement factorEy = cY.divide(cT);
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = factorLe.multiply(rowL[j]).add(factorEx.multiply(rowEx[j])).add(factorEy.multiply(rowEy[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)gm.divide(this.a)).sqrt()).divide(this.a);
        switch (type) {
            case MEAN: {
                pDot[5] = pDot[5].add((RealFieldElement)n);
                break;
            }
            case ECCENTRIC: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.lv.cos())).add(1.0)).add(this.ey.multiply(this.lv.sin()));
                pDot[5] = pDot[5].add((RealFieldElement)n.multiply(ksi).divide(oMe2));
                break;
            }
            case TRUE: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.lv.cos())).add(1.0)).add(this.ey.multiply(this.lv.sin()));
                pDot[5] = (RealFieldElement)pDot[5].add(n.multiply(ksi).multiply(ksi).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("equinoctial parameters: ").append('{').append("a: ").append(this.a.getReal()).append("; ex: ").append(this.ex.getReal()).append("; ey: ").append(this.ey.getReal()).append("; hx: ").append(this.hx.getReal()).append("; hy: ").append(this.hy.getReal()).append("; lv: ").append(FastMath.toDegrees(this.lv.getReal())).append(";}").toString();
    }

    @Deprecated
    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2))));
    }

    @Override
    public EquinoctialOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), this.lv.getReal(), this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.hxDot.getReal(), this.hyDot.getReal(), this.lvDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), this.lv.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

