/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldKeplerianOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private static final Map<Field<? extends RealFieldElement<?>>, FDSFactory<? extends RealFieldElement<?>>> FACTORIES = new HashMap();
    private static final double A;
    private static final double B;
    private final T a;
    private final T e;
    private final T i;
    private final T pa;
    private final T raan;
    private final T v;
    private final T aDot;
    private final T eDot;
    private final T iDot;
    private final T paDot;
    private final T raanDot;
    private final T vDot;
    private FieldPVCoordinates<T> partialPV;
    private final T one;
    private final T zero;
    private final FieldVector3D<T> PLUS_K;

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, e, i, pa, raan, anomaly, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, T aDot, T eDot, T iDot, T paDot, T raanDot, T anomalyDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (((RealFieldElement)a.multiply(((RealFieldElement)e.negate()).add(1.0))).getReal() < 0.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_A_E_MISMATCH_WITH_CONIC_TYPE, a.getReal(), e.getReal());
        }
        if (!FACTORIES.containsKey(a.getField())) {
            FACTORIES.put(a.getField(), new FDSFactory(a.getField(), 1, 1));
        }
        this.a = a;
        this.aDot = aDot;
        this.e = e;
        this.eDot = eDot;
        this.i = i;
        this.iDot = iDot;
        this.pa = pa;
        this.paDot = paDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.one = (RealFieldElement)a.getField().getOne();
        this.zero = (RealFieldElement)a.getField().getZero();
        this.PLUS_K = FieldVector3D.getPlusK(a.getField());
        if (this.hasDerivatives()) {
            FieldDerivativeStructure vDS;
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(a.getField());
            FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{e, eDot});
            FieldDerivativeStructure anomalyDS = factory.build(new RealFieldElement[]{anomaly, anomalyDot});
            switch (type) {
                case MEAN: {
                    vDS = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(anomalyDS, eDS), eDS) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(anomalyDS, eDS), eDS);
                    break;
                }
                case ECCENTRIC: {
                    vDS = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(anomalyDS, eDS) : FieldKeplerianOrbit.ellipticEccentricToTrue(anomalyDS, eDS);
                    break;
                }
                case TRUE: {
                    vDS = anomalyDS;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.v = vDS.getValue();
            this.vDot = vDS.getPartialDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.v = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(anomaly, e), e) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(anomaly, e), e);
                    break;
                }
                case ECCENTRIC: {
                    this.v = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(anomaly, e) : FieldKeplerianOrbit.ellipticEccentricToTrue(anomaly, e);
                    break;
                }
                case TRUE: {
                    this.v = anomaly;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.vDot = null;
        }
        if (((RealFieldElement)((RealFieldElement)e.multiply(this.v.cos())).add(1.0)).getReal() <= 0.0) {
            double vMax = ((RealFieldElement)((RealFieldElement)((RealFieldElement)e.reciprocal()).negate()).acos()).getReal();
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_ANOMALY_OUT_OF_HYPERBOLIC_RANGE, this.v.getReal(), e.getReal(), -vMax, vMax);
        }
        this.partialPV = null;
    }

    public FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        this(pvCoordinates, frame, mu, FieldKeplerianOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu));
    }

    private FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu, boolean reliableAcceleration) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.one = (RealFieldElement)pvCoordinates.getPosition().getX().getField().getOne();
        this.zero = (RealFieldElement)this.one.getField().getZero();
        this.PLUS_K = FieldVector3D.getPlusK(this.one.getField());
        FieldVector3D momentum = pvCoordinates.getMomentum();
        Object m2 = momentum.getNormSq();
        this.i = FieldVector3D.angle(momentum, this.PLUS_K);
        this.raan = FieldVector3D.crossProduct(this.PLUS_K, momentum).getAlpha();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D<RealFieldElement> pvA = pvCoordinates.getAcceleration();
        Object r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        Object V2 = pvV.getNormSq();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply(V2)).divide(mu);
        this.a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        RealFieldElement muA = (RealFieldElement)this.a.multiply(mu);
        if (this.a.getReal() > 0.0) {
            RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(muA.sqrt());
            RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
            this.e = (RealFieldElement)eSE.multiply(eSE).add(eCE.multiply(eCE)).sqrt();
            this.v = FieldKeplerianOrbit.ellipticEccentricToTrue(eSE.atan2(eCE), this.e);
        } else {
            RealFieldElement eSH = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)muA.negate()).sqrt());
            RealFieldElement eCH = (RealFieldElement)rV2OnMu.subtract(1.0);
            this.e = (RealFieldElement)((RealFieldElement)((RealFieldElement)m2.negate()).divide(muA).add(1.0)).sqrt();
            this.v = FieldKeplerianOrbit.hyperbolicEccentricToTrue((RealFieldElement)((RealFieldElement)eCH.add(eSH).divide(eCH.subtract(eSH)).log()).divide(2.0), this.e);
        }
        FieldVector3D<T> node = new FieldVector3D<T>(this.raan, this.zero);
        Object px = FieldVector3D.dotProduct(pvP, node);
        RealFieldElement py = (RealFieldElement)FieldVector3D.dotProduct(pvP, FieldVector3D.crossProduct(momentum, node)).divide(m2.sqrt());
        this.pa = (RealFieldElement)((RealFieldElement)py.atan2(px)).subtract(this.v);
        this.partialPV = pvCoordinates;
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (reliableAcceleration) {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.a.getField(), 6, 6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D<RealFieldElement> keplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply(r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D<RealFieldElement> nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            RealFieldElement aX = nonKeplerianAcceleration.getX();
            RealFieldElement aY = nonKeplerianAcceleration.getY();
            RealFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = jacobian[0][3].multiply(aX).add(jacobian[0][4].multiply(aY)).add(jacobian[0][5].multiply(aZ));
            this.eDot = jacobian[1][3].multiply(aX).add(jacobian[1][4].multiply(aY)).add(jacobian[1][5].multiply(aZ));
            this.iDot = jacobian[2][3].multiply(aX).add(jacobian[2][4].multiply(aY)).add(jacobian[2][5].multiply(aZ));
            this.paDot = jacobian[3][3].multiply(aX).add(jacobian[3][4].multiply(aY)).add(jacobian[3][5].multiply(aZ));
            this.raanDot = jacobian[4][3].multiply(aX).add(jacobian[4][4].multiply(aY)).add(jacobian[4][5].multiply(aZ));
            RealFieldElement MDot = this.getKeplerianMeanMotion().add((RealFieldElement)jacobian[5][3].multiply(aX)).add(jacobian[5][4].multiply(aY)).add(jacobian[5][5].multiply(aZ));
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
            FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
            FieldDerivativeStructure MDS = factory.build(new RealFieldElement[]{this.getMeanAnomaly(), MDot});
            FieldDerivativeStructure vDS = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(MDS, eDS), eDS) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(MDS, eDS), eDS);
            this.vDot = vDS.getPartialDerivative(1);
        } else {
            this.aDot = null;
            this.eDot = null;
            this.iDot = null;
            this.paDot = null;
            this.raanDot = null;
            this.vDot = null;
        }
    }

    public FieldKeplerianOrbit(FieldPVCoordinates<T> FieldPVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, FieldPVCoordinates2), frame, mu);
    }

    public FieldKeplerianOrbit(FieldOrbit<T> op) {
        this(op.getPVCoordinates(), op.getFrame(), op.getMu(), op.hasDerivatives());
    }

    @Override
    public OrbitType getType() {
        return OrbitType.KEPLERIAN;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getE() {
        return this.e;
    }

    @Override
    public T getEDot() {
        return this.eDot;
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getPerigeeArgument() {
        return this.pa;
    }

    public T getPerigeeArgumentDot() {
        return this.paDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    public T getTrueAnomaly() {
        return this.v;
    }

    public T getTrueAnomalyDot() {
        return this.vDot;
    }

    public T getEccentricAnomaly() {
        return this.a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(this.v, this.e) : FieldKeplerianOrbit.trueToEllipticEccentric(this.v, this.e);
    }

    public T getEccentricAnomalyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure vDS = factory.build(new RealFieldElement[]{this.v, this.vDot});
        FieldDerivativeStructure EDS = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(vDS, eDS) : FieldKeplerianOrbit.trueToEllipticEccentric(vDS, eDS);
        return EDS.getPartialDerivative(1);
    }

    public T getMeanAnomaly() {
        return this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToMean(FieldKeplerianOrbit.trueToHyperbolicEccentric(this.v, this.e), this.e) : FieldKeplerianOrbit.ellipticEccentricToMean(FieldKeplerianOrbit.trueToEllipticEccentric(this.v, this.e), this.e);
    }

    public T getMeanAnomalyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure vDS = factory.build(new RealFieldElement[]{this.v, this.vDot});
        FieldDerivativeStructure MDS = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToMean(FieldKeplerianOrbit.trueToHyperbolicEccentric(vDS, eDS), eDS) : FieldKeplerianOrbit.ellipticEccentricToMean(FieldKeplerianOrbit.trueToEllipticEccentric(vDS, eDS), eDS);
        return MDS.getPartialDerivative(1);
    }

    public T getAnomaly(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getMeanAnomaly() : (type == PositionAngle.ECCENTRIC ? this.getEccentricAnomaly() : this.getTrueAnomaly());
    }

    public T getAnomalyDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getMeanAnomalyDot() : (type == PositionAngle.ECCENTRIC ? this.getEccentricAnomalyDot() : this.getTrueAnomalyDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    public static <T extends RealFieldElement<T>> T ellipticEccentricToTrue(T E, T e) {
        RealFieldElement beta = (RealFieldElement)e.divide(((RealFieldElement)((RealFieldElement)((RealFieldElement)e.multiply(e).negate()).add(1.0)).sqrt()).add(1.0));
        return (T)((RealFieldElement)E.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.multiply(E.sin())).divide(((RealFieldElement)((RealFieldElement)beta.multiply(E.cos())).subtract(1.0)).negate())).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T trueToEllipticEccentric(T v, T e) {
        RealFieldElement beta = (RealFieldElement)e.divide(((RealFieldElement)((RealFieldElement)((RealFieldElement)e.multiply(e).negate()).add(1.0)).sqrt()).add(1.0));
        return (T)((RealFieldElement)v.subtract(((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.multiply(v.sin())).divide(((RealFieldElement)beta.multiply(v.cos())).add(1.0))).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T hyperbolicEccentricToTrue(T H, T e) {
        RealFieldElement s = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.add(1.0)).divide(e.subtract(1.0))).sqrt();
        RealFieldElement tanH = (RealFieldElement)((RealFieldElement)H.multiply(0.5)).tanh();
        return (T)((RealFieldElement)((RealFieldElement)s.multiply(tanH).atan()).multiply(2));
    }

    public static <T extends RealFieldElement<T>> T trueToHyperbolicEccentric(T v, T e) {
        RealFieldElement sinhH = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e.multiply(e).subtract(1.0)).sqrt()).multiply(v.sin())).divide(((RealFieldElement)e.multiply(v.cos())).add(1.0));
        return (T)((RealFieldElement)sinhH.asinh());
    }

    public static <T extends RealFieldElement<T>> T hyperbolicEccentricToMean(T H, T e) {
        return ((RealFieldElement)e.multiply(H.sinh())).subtract(H);
    }

    public static <T extends RealFieldElement<T>> T meanToEllipticEccentric(T M, T e) {
        RealFieldElement w;
        RealFieldElement E;
        RealFieldElement reducedM = MathUtils.normalizeAngle(M, (RealFieldElement)M.getField().getZero());
        if (((RealFieldElement)reducedM.abs()).getReal() < 0.16666666666666666) {
            E = FastMath.abs(reducedM.getReal()) < Precision.SAFE_MIN ? reducedM : reducedM.add(e.multiply((RealFieldElement)((RealFieldElement)((RealFieldElement)reducedM.multiply(6)).cbrt()).subtract(reducedM)));
        } else if (reducedM.getReal() < 0.0) {
            w = (RealFieldElement)reducedM.add(Math.PI);
            E = reducedM.add(e.multiply((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)w.multiply(A)).divide(((RealFieldElement)w.negate()).add(B))).subtract(Math.PI)).subtract(reducedM)));
        } else {
            w = (RealFieldElement)((RealFieldElement)reducedM.negate()).add(Math.PI);
            E = (RealFieldElement)reducedM.add(e.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)w.multiply(A)).divide(((RealFieldElement)w.negate()).add(B))).negate()).subtract(reducedM).add(Math.PI)));
        }
        RealFieldElement e1 = (RealFieldElement)((RealFieldElement)e.negate()).add(1.0);
        boolean noCancellationRisk = e1.getReal() + E.getReal() * E.getReal() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            RealFieldElement fd;
            RealFieldElement f;
            RealFieldElement fdd = (RealFieldElement)e.multiply(E.sin());
            RealFieldElement fddd = (RealFieldElement)e.multiply(E.cos());
            if (noCancellationRisk) {
                f = E.subtract(fdd).subtract(reducedM);
                fd = (RealFieldElement)((RealFieldElement)fddd.negate()).add(1.0);
            } else {
                f = FieldKeplerianOrbit.eMeSinE(E, e).subtract(reducedM);
                RealFieldElement s = (RealFieldElement)((RealFieldElement)E.multiply(0.5)).sin();
                fd = (RealFieldElement)e1.add(e.multiply((RealFieldElement)s).multiply(s).multiply(2));
            }
            RealFieldElement dee = f.multiply(fd).divide(((RealFieldElement)f.multiply(fdd).multiply(0.5)).subtract(fd.multiply(fd)));
            RealFieldElement w2 = (RealFieldElement)fd.add(((RealFieldElement)dee.multiply(fdd.add(dee.multiply(fddd.divide(3.0))))).multiply(0.5));
            fd = (RealFieldElement)fd.add(dee.multiply(fdd.add(dee.multiply(fddd).multiply(0.5))));
            E = E.subtract(f.subtract(dee.multiply(fd.subtract(w2))).divide(fd));
        }
        E = E.add(M).subtract((RealFieldElement)reducedM);
        return (T)E;
    }

    private static <T extends RealFieldElement<T>> T eMeSinE(T E, T e) {
        RealFieldElement x = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.negate()).add(1.0)).multiply(E.sin());
        T mE2 = ((RealFieldElement)E.negate()).multiply(E);
        Object term = E;
        double d = 0.0;
        RealFieldElement x0 = (RealFieldElement)((RealFieldElement)E.getField().getZero()).add(Double.NaN);
        while (!Double.valueOf(x.getReal()).equals(x0.getReal())) {
            term = (RealFieldElement)term.multiply(mE2.divide((d += 2.0) * (d + 1.0)));
            x0 = x;
            x = x.subtract(term);
        }
        return (T)x;
    }

    public static <T extends RealFieldElement<T>> T meanToHyperbolicEccentric(T M, T e) {
        RealFieldElement H = e.getReal() < 1.6 ? (-Math.PI < M.getReal() && M.getReal() < 0.0 || M.getReal() > Math.PI ? M.subtract(e) : M.add(e)) : (e.getReal() < 3.6 && ((RealFieldElement)M.abs()).getReal() > Math.PI ? (RealFieldElement)M.subtract(e.copySign(M)) : (RealFieldElement)M.divide(e.subtract(1.0)));
        int iter = 0;
        do {
            RealFieldElement f3 = (RealFieldElement)e.multiply(H.cosh());
            RealFieldElement f2 = (RealFieldElement)e.multiply(H.sinh());
            RealFieldElement f1 = (RealFieldElement)f3.subtract(1.0);
            RealFieldElement f0 = f2.subtract(H).subtract(M);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2);
            RealFieldElement d = f0.divide((RealFieldElement)f12);
            RealFieldElement fdf = f1.subtract(d.multiply(f2));
            RealFieldElement ds = f0.divide((RealFieldElement)fdf);
            RealFieldElement shift = (RealFieldElement)f0.divide(fdf.add(ds.multiply(ds.multiply(f3.divide(6.0)))));
            H = H.subtract(shift);
            if (!(((RealFieldElement)shift.abs()).getReal() <= 1.0E-12)) continue;
            return (T)H;
        } while (++iter < 50);
        throw new MathIllegalArgumentException(OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, iter);
    }

    public static <T extends RealFieldElement<T>> T ellipticEccentricToMean(T E, T e) {
        return (T)((RealFieldElement)E.subtract(e.multiply(E.sin())));
    }

    @Override
    public T getEquinoctialEx() {
        return (T)((RealFieldElement)this.e.multiply(((RealFieldElement)this.pa.add(this.raan)).cos()));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure paDS = factory.build(new RealFieldElement[]{this.pa, this.paDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return eDS.multiply(paDS.add(raanDS).cos()).getPartialDerivative(1);
    }

    @Override
    public T getEquinoctialEy() {
        return (T)((RealFieldElement)this.e.multiply(((RealFieldElement)this.pa.add(this.raan)).sin()));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure paDS = factory.build(new RealFieldElement[]{this.pa, this.paDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return eDS.multiply(paDS.add(raanDS).sin()).getPartialDerivative(1);
    }

    @Override
    public T getHx() {
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.cos()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure iDS = factory.build(new RealFieldElement[]{this.i, this.iDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return ((FieldDerivativeStructure)raanDS.cos()).multiply(((FieldDerivativeStructure)iDS.multiply(0.5)).tan()).getPartialDerivative(1);
    }

    @Override
    public T getHy() {
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.sin()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure iDS = factory.build(new RealFieldElement[]{this.i, this.iDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return ((FieldDerivativeStructure)raanDS.sin()).multiply(((FieldDerivativeStructure)iDS.multiply(0.5)).tan()).getPartialDerivative(1);
    }

    @Override
    public T getLv() {
        return (T)((RealFieldElement)((RealFieldElement)this.pa.add(this.raan)).add(this.v));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)((RealFieldElement)this.paDot.add(this.raanDot)).add(this.vDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((RealFieldElement)((RealFieldElement)this.pa.add(this.raan)).add(this.getEccentricAnomaly()));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)((RealFieldElement)this.paDot.add(this.raanDot)).add(this.getEccentricAnomalyDot()) : null);
    }

    @Override
    public T getLM() {
        return (T)((RealFieldElement)((RealFieldElement)this.pa.add(this.raan)).add(this.getMeanAnomaly()));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)((RealFieldElement)this.paDot.add(this.raanDot)).add(this.getMeanAnomalyDot()) : null);
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement cosPa = (RealFieldElement)this.pa.cos();
        RealFieldElement sinPa = (RealFieldElement)this.pa.sin();
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement crcp = cosRaan.multiply(cosPa);
        RealFieldElement crsp = cosRaan.multiply(sinPa);
        RealFieldElement srcp = sinRaan.multiply(cosPa);
        RealFieldElement srsp = sinRaan.multiply(sinPa);
        FieldVector3D<RealFieldElement> p = new FieldVector3D<RealFieldElement>(crcp.subtract(cosI.multiply(srsp)), srcp.add(cosI.multiply(crsp)), sinI.multiply(sinPa));
        FieldVector3D<RealFieldElement> q = new FieldVector3D<RealFieldElement>((RealFieldElement)crsp.add(cosI.multiply(srcp)).negate(), cosI.multiply(crcp).subtract(srsp), sinI.multiply(cosPa));
        if (this.a.getReal() > 0.0) {
            RealFieldElement uME2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.negate()).add(1.0)).multiply(this.e.add(1.0));
            RealFieldElement s1Me2 = (RealFieldElement)uME2.sqrt();
            T E = this.getEccentricAnomaly();
            RealFieldElement cosE = (RealFieldElement)E.cos();
            RealFieldElement sinE = (RealFieldElement)E.sin();
            RealFieldElement x = (RealFieldElement)this.a.multiply(cosE.subtract(this.e));
            RealFieldElement y = this.a.multiply((RealFieldElement)sinE).multiply(s1Me2);
            RealFieldElement factor = (RealFieldElement)FastMath.sqrt((RealFieldElement)this.getMu().divide(this.a)).divide(((RealFieldElement)this.e.negate()).multiply(cosE).add(1.0));
            RealFieldElement xDot = ((RealFieldElement)sinE.negate()).multiply(factor);
            RealFieldElement yDot = cosE.multiply(s1Me2).multiply(factor);
            FieldVector3D<RealFieldElement> position = new FieldVector3D<RealFieldElement>(x, p, y, q);
            FieldVector3D<RealFieldElement> velocity = new FieldVector3D<RealFieldElement>(xDot, p, yDot, q);
            this.partialPV = new FieldPVCoordinates<RealFieldElement>(position, velocity);
        } else {
            RealFieldElement sinV = (RealFieldElement)this.v.sin();
            RealFieldElement cosV = (RealFieldElement)this.v.cos();
            RealFieldElement f = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0));
            RealFieldElement posFactor = (RealFieldElement)f.divide(this.e.multiply((RealFieldElement)cosV).add(1.0));
            RealFieldElement velFactor = FastMath.sqrt(this.getMu().divide((RealFieldElement)f));
            FieldVector3D<RealFieldElement> position = new FieldVector3D<RealFieldElement>(posFactor.multiply(cosV), p, posFactor.multiply(sinV), q);
            FieldVector3D<RealFieldElement> velocity = new FieldVector3D<RealFieldElement>((RealFieldElement)velFactor.multiply(sinV).negate(), p, velFactor.multiply(this.e.add((RealFieldElement)cosV)), q);
            this.partialPV = new FieldPVCoordinates<RealFieldElement>(position, velocity);
        }
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        RealFieldElement[][] dCdP = (RealFieldElement[][])MathArrays.buildArray(this.a.getField(), 6, 6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        RealFieldElement nonKeplerianMeanMotion = (RealFieldElement)this.getMeanAnomalyDot().subtract(this.getKeplerianMeanMotion());
        RealFieldElement nonKeplerianAx = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.eDot))).add(dCdP[3][2].multiply(this.iDot))).add(dCdP[3][3].multiply(this.paDot))).add(dCdP[3][4].multiply(this.raanDot))).add(dCdP[3][5].multiply(nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAy = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.eDot))).add(dCdP[4][2].multiply(this.iDot))).add(dCdP[4][3].multiply(this.paDot))).add(dCdP[4][4].multiply(this.raanDot))).add(dCdP[4][5].multiply(nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAz = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.eDot))).add(dCdP[5][2].multiply(this.iDot))).add(dCdP[5][3].multiply(this.paDot))).add(dCdP[5][4].multiply(this.raanDot))).add(dCdP[5][5].multiply(nonKeplerianMeanMotion));
        return new FieldVector3D<RealFieldElement>(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        T r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D<RealFieldElement> keplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(FastMath.sqrt(r2))).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D<RealFieldElement> acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates<RealFieldElement>(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(T dt) {
        FieldKeplerianOrbit<RealFieldElement> keplerianShifted = new FieldKeplerianOrbit<RealFieldElement>((RealFieldElement)this.a, (RealFieldElement)this.e, (RealFieldElement)this.i, (RealFieldElement)this.pa, (RealFieldElement)this.raan, (RealFieldElement)((RealFieldElement)this.getKeplerianMeanMotion().multiply(dt)).add(this.getMeanAnomaly()), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (RealFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D<RealFieldElement> fixedP = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)keplerianShifted.partialPV.getPosition(), (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), (FieldVector3D<RealFieldElement>)nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D<T> fixedV = new FieldVector3D<T>(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D<RealFieldElement> fixedA = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)fixedR2.multiply(fixedR).reciprocal()).multiply(this.getMu().negate()), (FieldVector3D<RealFieldElement>)keplerianShifted.partialPV.getPosition(), (RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)nonKeplerianAcceleration);
            return new FieldKeplerianOrbit<RealFieldElement>(new TimeStampedFieldPVCoordinates<RealFieldElement>(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), (RealFieldElement)keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldKeplerianOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        RealFieldElement previousPA = (RealFieldElement)this.zero.add(Double.NaN);
        RealFieldElement previousRAAN = (RealFieldElement)this.zero.add(Double.NaN);
        RealFieldElement previousM = (RealFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousM;
            Object continuousRAAN;
            Object continuousPA;
            FieldKeplerianOrbit kep = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
            if (previousDate == null) {
                continuousPA = kep.getPerigeeArgument();
                continuousRAAN = kep.getRightAscensionOfAscendingNode();
                continuousM = kep.getMeanAnomaly();
            } else {
                Object dt = kep.getDate().durationFrom(previousDate);
                RealFieldElement keplerM = (RealFieldElement)previousM.add(kep.getKeplerianMeanMotion().multiply(dt));
                continuousPA = MathUtils.normalizeAngle(kep.getPerigeeArgument(), previousPA);
                continuousRAAN = MathUtils.normalizeAngle(kep.getRightAscensionOfAscendingNode(), previousRAAN);
                continuousM = MathUtils.normalizeAngle(kep.getMeanAnomaly(), keplerM);
            }
            previousDate = kep.getDate();
            previousPA = continuousPA;
            previousRAAN = continuousRAAN;
            previousM = continuousM;
            RealFieldElement[] toAdd = (RealFieldElement[])MathArrays.buildArray(this.getA().getField(), 6);
            toAdd[0] = kep.getA();
            toAdd[1] = kep.getE();
            toAdd[2] = kep.getI();
            toAdd[3] = continuousPA;
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousM;
            if (useDerivatives) {
                RealFieldElement[] toAddDot = (RealFieldElement[])MathArrays.buildArray(this.one.getField(), 6);
                toAddDot[0] = kep.getADot();
                toAddDot[1] = kep.getEDot();
                toAddDot[2] = kep.getIDot();
                toAddDot[3] = kep.getPerigeeArgumentDot();
                toAddDot[4] = kep.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = kep.getMeanAnomalyDot();
                interpolator.addSamplePoint((FieldElement)kep.getDate().durationFrom(date), new RealFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint((FieldElement)this.zero.add(kep.getDate().durationFrom(date)), new RealFieldElement[][]{toAdd});
        }
        RealFieldElement[][] interpolated = (RealFieldElement[][])interpolator.derivatives((FieldElement)this.zero, 1);
        return new FieldKeplerianOrbit<RealFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<RealFieldElement>)date, (RealFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianMeanWrtCartesianElliptical();
        }
        return this.computeJacobianMeanWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianMeanWrtCartesianElliptical() {
        RealFieldElement factorI1;
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.getA().getField(), 6, 6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<RealFieldElement> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        T v2 = velocity.getNormSq();
        T r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement r3 = (RealFieldElement)r.multiply(r2);
        T px = position.getX();
        T py = position.getY();
        T pz = position.getZ();
        T vx = velocity.getX();
        T vy = velocity.getY();
        RealFieldElement vz = velocity.getZ();
        T mx = momentum.getX();
        T my = momentum.getY();
        T mz = momentum.getZ();
        Object mu = this.getMu();
        RealFieldElement sqrtMuA = FastMath.sqrt((RealFieldElement)this.a.multiply(mu));
        RealFieldElement sqrtAoMu = FastMath.sqrt((RealFieldElement)this.a.divide(mu));
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement twoA = (RealFieldElement)this.a.multiply((int)2);
        RealFieldElement rOnA = (RealFieldElement)r.divide(this.a);
        RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0);
        RealFieldElement epsilon = (RealFieldElement)oMe2.sqrt();
        RealFieldElement sqrtRec = (RealFieldElement)epsilon.reciprocal();
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement cosPA = (RealFieldElement)this.pa.cos();
        RealFieldElement sinPA = (RealFieldElement)this.pa.sin();
        RealFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        RealFieldElement cosE = (RealFieldElement)this.a.subtract((RealFieldElement)r).divide(this.a.multiply(this.e));
        RealFieldElement sinE = pv.divide((RealFieldElement)this.e.multiply((RealFieldElement)sqrtMuA));
        FieldVector3D<RealFieldElement> vectorAR = new FieldVector3D<RealFieldElement>(((RealFieldElement)a2.multiply(2)).divide(r3), position);
        FieldVector3D<RealFieldElement> vectorARDot = velocity.scalarMultiply((RealFieldElement)a2.multiply(((RealFieldElement)mu.divide(2.0)).reciprocal()));
        this.fillHalfRow((RealFieldElement)this.one, vectorAR, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorARDot, jacobian[0], 3);
        RealFieldElement factorER3 = pv.divide((RealFieldElement)twoA);
        FieldVector3D<RealFieldElement> vectorER = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)cosE.multiply(v2)).divide(r.multiply(mu)), position, sinE.divide(sqrtMuA), velocity, ((RealFieldElement)factorER3.negate()).multiply(sinE).divide(sqrtMuA), vectorAR);
        FieldVector3D<RealFieldElement> vectorERDot = new FieldVector3D<RealFieldElement>(sinE.divide(sqrtMuA), position, ((RealFieldElement)cosE.multiply(((RealFieldElement)mu.divide(2.0)).reciprocal())).multiply(r), velocity, ((RealFieldElement)factorER3.negate()).multiply(sinE).divide(sqrtMuA), vectorARDot);
        this.fillHalfRow((RealFieldElement)this.one, vectorER, jacobian[1], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorERDot, jacobian[1], 3);
        RealFieldElement coefE = cosE.divide(this.e.multiply((RealFieldElement)sqrtMuA));
        FieldVector3D<RealFieldElement> vectorEAnR = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)sinE.negate()).multiply(v2)).divide(this.e.multiply((RealFieldElement)r).multiply(mu)), position, coefE, velocity, ((RealFieldElement)factorER3.negate()).multiply(coefE), vectorAR);
        FieldVector3D<RealFieldElement> vectorEAnRDot = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)sinE.multiply(-2)).multiply(r).divide(this.e.multiply(mu)), velocity, coefE, position, ((RealFieldElement)factorER3.negate()).multiply(coefE), vectorARDot);
        RealFieldElement s1 = ((RealFieldElement)((RealFieldElement)sinE.negate()).multiply(pz)).divide(r).subtract(((RealFieldElement)cosE.multiply(vz)).multiply(sqrtAoMu));
        RealFieldElement s2 = ((RealFieldElement)((RealFieldElement)cosE.negate()).multiply(pz)).divide(r3);
        RealFieldElement s3 = (RealFieldElement)((RealFieldElement)sinE.multiply(vz)).divide(sqrtMuA.multiply(-2));
        RealFieldElement t1 = sqrtRec.multiply(((RealFieldElement)cosE.multiply(pz)).divide(r).subtract(((RealFieldElement)sinE.multiply(vz)).multiply(sqrtAoMu)));
        RealFieldElement t2 = sqrtRec.multiply(((RealFieldElement)((RealFieldElement)sinE.negate()).multiply(pz)).divide(r3));
        RealFieldElement t3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)sqrtRec.multiply(cosE.subtract(this.e))).multiply(vz)).divide(sqrtMuA.multiply(2));
        RealFieldElement t4 = sqrtRec.multiply(this.e.multiply((RealFieldElement)sinI).multiply(cosPA).multiply(sqrtRec).subtract(vz.multiply((RealFieldElement)sqrtAoMu)));
        FieldVector3D<RealFieldElement> s = new FieldVector3D<RealFieldElement>(cosE.divide(r), this.PLUS_K, s1, vectorEAnR, s2, position, s3, vectorAR);
        FieldVector3D<RealFieldElement> sDot = new FieldVector3D<RealFieldElement>(((RealFieldElement)sinE.negate()).multiply(sqrtAoMu), this.PLUS_K, s1, vectorEAnRDot, s3, vectorARDot);
        FieldVector3D<RealFieldElement> t = new FieldVector3D<RealFieldElement>(sqrtRec.multiply(sinE).divide(r), this.PLUS_K).add(new FieldVector3D<RealFieldElement>(t1, vectorEAnR, t2, position, t3, vectorAR, t4, vectorER));
        FieldVector3D<RealFieldElement> tDot = new FieldVector3D<RealFieldElement>(((RealFieldElement)sqrtRec.multiply(cosE.subtract(this.e))).multiply(sqrtAoMu), this.PLUS_K, t1, vectorEAnRDot, t3, vectorARDot, t4, vectorERDot);
        RealFieldElement i1 = factorI1 = ((RealFieldElement)sinI.negate()).multiply(sqrtRec).divide(sqrtMuA);
        RealFieldElement i2 = ((RealFieldElement)((RealFieldElement)factorI1.negate()).multiply(mz)).divide(twoA);
        RealFieldElement i3 = ((RealFieldElement)((RealFieldElement)factorI1.multiply(mz)).multiply(this.e)).divide(oMe2);
        RealFieldElement i4 = cosI.multiply(sinPA);
        RealFieldElement i5 = cosI.multiply(cosPA);
        this.fillHalfRow(i1, new FieldVector3D<RealFieldElement>((RealFieldElement)vy, (RealFieldElement)vx.negate(), (RealFieldElement)this.zero), i2, vectorAR, i3, vectorER, i4, s, i5, t, jacobian[2], 0);
        this.fillHalfRow(i1, new FieldVector3D<RealFieldElement>((RealFieldElement)py.negate(), (RealFieldElement)px, (RealFieldElement)this.zero), i2, vectorARDot, i3, vectorERDot, i4, sDot, i5, tDot, jacobian[2], 3);
        this.fillHalfRow(cosPA.divide(sinI), s, ((RealFieldElement)sinPA.negate()).divide(sinI), t, jacobian[3], 0);
        this.fillHalfRow(cosPA.divide(sinI), sDot, ((RealFieldElement)sinPA.negate()).divide(sinI), tDot, jacobian[3], 3);
        RealFieldElement factorRaanR = (RealFieldElement)((RealFieldElement)this.a.multiply(mu)).multiply(oMe2).multiply(sinI).multiply(sinI).reciprocal();
        this.fillHalfRow((RealFieldElement)((RealFieldElement)factorRaanR.negate()).multiply(my), new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero, vz, (RealFieldElement)vy.negate()), (RealFieldElement)factorRaanR.multiply(mx), new FieldVector3D<RealFieldElement>((RealFieldElement)vz.negate(), (RealFieldElement)this.zero, (RealFieldElement)vx), jacobian[4], 0);
        this.fillHalfRow((RealFieldElement)((RealFieldElement)factorRaanR.negate()).multiply(my), new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero, (RealFieldElement)pz.negate(), (RealFieldElement)py), (RealFieldElement)factorRaanR.multiply(mx), new FieldVector3D<RealFieldElement>((RealFieldElement)pz, (RealFieldElement)this.zero, (RealFieldElement)px.negate()), jacobian[4], 3);
        this.fillHalfRow(rOnA, vectorEAnR, (RealFieldElement)sinE.negate(), vectorER, jacobian[5], 0);
        this.fillHalfRow(rOnA, vectorEAnRDot, (RealFieldElement)sinE.negate(), vectorERDot, jacobian[5], 3);
        return jacobian;
    }

    private T[][] computeJacobianMeanWrtCartesianHyperbolic() {
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.getA().getField(), 6, 6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<RealFieldElement> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement r3 = (RealFieldElement)r.multiply(r2);
        T x = position.getX();
        RealFieldElement y = position.getY();
        RealFieldElement z = position.getZ();
        T vx = velocity.getX();
        T vy = velocity.getY();
        T vz = velocity.getZ();
        RealFieldElement mx = momentum.getX();
        RealFieldElement my = momentum.getY();
        RealFieldElement mz = momentum.getZ();
        Object mu = this.getMu();
        RealFieldElement absA = (RealFieldElement)this.a.negate();
        RealFieldElement sqrtMuA = (RealFieldElement)((RealFieldElement)absA.multiply(mu)).sqrt();
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement rOa = r.divide(absA);
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        Object pv = FieldVector3D.dotProduct(position, velocity);
        FieldVector3D<RealFieldElement> vectorAR = new FieldVector3D<RealFieldElement>(((RealFieldElement)a2.multiply(-2)).divide(r3), position);
        FieldVector3D<RealFieldElement> vectorARDot = velocity.scalarMultiply((RealFieldElement)((RealFieldElement)a2.multiply(-2)).divide(mu));
        this.fillHalfRow((RealFieldElement)this.one.negate(), vectorAR, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)this.one.negate(), vectorARDot, jacobian[0], 3);
        T m = momentum.getNorm();
        RealFieldElement oOm = (RealFieldElement)m.reciprocal();
        FieldVector3D<RealFieldElement> dcXP = new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero, (RealFieldElement)vz, (RealFieldElement)vy.negate());
        FieldVector3D<RealFieldElement> dcYP = new FieldVector3D<RealFieldElement>((RealFieldElement)vz.negate(), (RealFieldElement)this.zero, (RealFieldElement)vx);
        FieldVector3D<RealFieldElement> dcZP = new FieldVector3D<RealFieldElement>((RealFieldElement)vy, (RealFieldElement)vx.negate(), (RealFieldElement)this.zero);
        FieldVector3D<RealFieldElement> dcXV = new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero, (RealFieldElement)z.negate(), y);
        FieldVector3D<RealFieldElement> dcYV = new FieldVector3D<RealFieldElement>(z, (RealFieldElement)this.zero, (RealFieldElement)x.negate());
        FieldVector3D<RealFieldElement> dcZV = new FieldVector3D<RealFieldElement>((RealFieldElement)y.negate(), (RealFieldElement)x, (RealFieldElement)this.zero);
        FieldVector3D<RealFieldElement> dCP = new FieldVector3D<RealFieldElement>(mx.multiply((RealFieldElement)oOm), dcXP, my.multiply((RealFieldElement)oOm), dcYP, mz.multiply((RealFieldElement)oOm), dcZP);
        FieldVector3D<RealFieldElement> dCV = new FieldVector3D<RealFieldElement>(mx.multiply((RealFieldElement)oOm), dcXV, my.multiply((RealFieldElement)oOm), dcYV, mz.multiply((RealFieldElement)oOm), dcZV);
        RealFieldElement mOMu = (RealFieldElement)m.divide(mu);
        FieldVector3D<RealFieldElement> dpP = new FieldVector3D<RealFieldElement>((RealFieldElement)mOMu.multiply(2), dCP);
        FieldVector3D<RealFieldElement> dpV = new FieldVector3D<RealFieldElement>((RealFieldElement)mOMu.multiply(2), dCV);
        RealFieldElement p = m.multiply((RealFieldElement)mOMu);
        RealFieldElement moO2ae = (RealFieldElement)((RealFieldElement)((RealFieldElement)absA.multiply(2)).multiply(this.e)).reciprocal();
        RealFieldElement m2OaMu = ((RealFieldElement)p.negate()).divide(absA);
        this.fillHalfRow(moO2ae, dpP, m2OaMu.multiply(moO2ae), vectorAR, jacobian[1], 0);
        this.fillHalfRow(moO2ae, dpV, m2OaMu.multiply(moO2ae), vectorARDot, jacobian[1], 3);
        RealFieldElement cI1 = (RealFieldElement)m.multiply((RealFieldElement)sinI).reciprocal();
        RealFieldElement cI2 = cosI.multiply(cI1);
        this.fillHalfRow(cI2, dCP, (RealFieldElement)cI1.negate(), dcZP, jacobian[2], 0);
        this.fillHalfRow(cI2, dCV, (RealFieldElement)cI1.negate(), dcZV, jacobian[2], 3);
        RealFieldElement cP1 = y.multiply((RealFieldElement)oOm);
        RealFieldElement cP2 = ((RealFieldElement)x.negate()).multiply(oOm);
        RealFieldElement cP3 = (RealFieldElement)mx.multiply((RealFieldElement)cP1).add(my.multiply((RealFieldElement)cP2)).negate();
        RealFieldElement cP4 = cP3.multiply(oOm);
        RealFieldElement cP5 = (RealFieldElement)((RealFieldElement)r2.multiply((RealFieldElement)sinI).multiply(sinI).negate()).reciprocal();
        RealFieldElement cP6 = z.multiply((RealFieldElement)cP5);
        RealFieldElement cP7 = cP3.multiply(cP5);
        FieldVector3D<RealFieldElement> dacP = new FieldVector3D<RealFieldElement>(cP1, dcXP, cP2, dcYP, cP4, dCP, oOm, new FieldVector3D<RealFieldElement>((RealFieldElement)my.negate(), mx, (RealFieldElement)this.zero));
        FieldVector3D<RealFieldElement> dacV = new FieldVector3D<RealFieldElement>(cP1, dcXV, cP2, dcYV, cP4, dCV);
        FieldVector3D<RealFieldElement> dpoP = new FieldVector3D<RealFieldElement>(cP6, dacP, cP7, this.PLUS_K);
        FieldVector3D<RealFieldElement> dpoV = new FieldVector3D<RealFieldElement>(cP6, dacV);
        RealFieldElement re2 = (RealFieldElement)((RealFieldElement)r2.multiply(this.e)).multiply(this.e);
        RealFieldElement recOre2 = p.subtract(r).divide(re2);
        RealFieldElement resOre2 = pv.multiply((RealFieldElement)mOMu).divide(re2);
        FieldVector3D<RealFieldElement> dreP = new FieldVector3D<RealFieldElement>(mOMu, velocity, (RealFieldElement)pv.divide(mu), dCP);
        FieldVector3D<RealFieldElement> dreV = new FieldVector3D<RealFieldElement>(mOMu, position, (RealFieldElement)pv.divide(mu), dCV);
        FieldVector3D<RealFieldElement> davP = new FieldVector3D<RealFieldElement>((RealFieldElement)resOre2.negate(), dpP, recOre2, dreP, resOre2.divide(r), position);
        FieldVector3D<RealFieldElement> davV = new FieldVector3D<RealFieldElement>((RealFieldElement)resOre2.negate(), dpV, recOre2, dreV);
        this.fillHalfRow((RealFieldElement)this.one, dpoP, (RealFieldElement)this.one.negate(), davP, jacobian[3], 0);
        this.fillHalfRow((RealFieldElement)this.one, dpoV, (RealFieldElement)this.one.negate(), davV, jacobian[3], 3);
        RealFieldElement cO0 = cI1.multiply(cI1);
        RealFieldElement cO1 = mx.multiply((RealFieldElement)cO0);
        RealFieldElement cO2 = ((RealFieldElement)my.negate()).multiply(cO0);
        this.fillHalfRow(cO1, dcYP, cO2, dcXP, jacobian[4], 0);
        this.fillHalfRow(cO1, dcYV, cO2, dcXV, jacobian[4], 3);
        RealFieldElement s2a = (RealFieldElement)pv.divide(absA.multiply(2));
        RealFieldElement oObux = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m.multiply(m)).add(absA.multiply(mu))).sqrt()).reciprocal();
        RealFieldElement scasbu = pv.multiply((RealFieldElement)oObux);
        FieldVector3D<RealFieldElement> dauP = new FieldVector3D<RealFieldElement>((RealFieldElement)sqrtMuA.reciprocal(), velocity, ((RealFieldElement)s2a.negate()).divide(sqrtMuA), vectorAR);
        FieldVector3D<RealFieldElement> dauV = new FieldVector3D<RealFieldElement>((RealFieldElement)sqrtMuA.reciprocal(), position, ((RealFieldElement)s2a.negate()).divide(sqrtMuA), vectorARDot);
        FieldVector3D<RealFieldElement> dbuP = new FieldVector3D<RealFieldElement>((RealFieldElement)oObux.multiply(mu.divide(2.0)), vectorAR, m.multiply((RealFieldElement)oObux), dCP);
        FieldVector3D<RealFieldElement> dbuV = new FieldVector3D<RealFieldElement>((RealFieldElement)oObux.multiply(mu.divide(2.0)), vectorARDot, m.multiply((RealFieldElement)oObux), dCV);
        FieldVector3D<RealFieldElement> dcuP = new FieldVector3D<RealFieldElement>(oObux, velocity, ((RealFieldElement)scasbu.negate()).multiply(oObux), dbuP);
        FieldVector3D<RealFieldElement> dcuV = new FieldVector3D<RealFieldElement>(oObux, position, ((RealFieldElement)scasbu.negate()).multiply(oObux), dbuV);
        this.fillHalfRow((RealFieldElement)this.one, dauP, (RealFieldElement)((RealFieldElement)this.e.negate()).divide(rOa.add(1.0)), dcuP, jacobian[5], 0);
        this.fillHalfRow((RealFieldElement)this.one, dauV, (RealFieldElement)((RealFieldElement)this.e.negate()).divide(rOa.add(1.0)), dcuV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianEccentricWrtCartesianElliptical();
        }
        return this.computeJacobianEccentricWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianEccentricWrtCartesianElliptical() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianElliptical();
        T eccentricAnomaly = this.getEccentricAnomaly();
        RealFieldElement cosE = (RealFieldElement)eccentricAnomaly.cos();
        RealFieldElement sinE = (RealFieldElement)eccentricAnomaly.sin();
        RealFieldElement aOr = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.negate()).multiply(cosE).add(1.0)).reciprocal();
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = aOr.multiply(anomalyRow[j].add(sinE.multiply(eRow[j])));
        }
        return jacobian;
    }

    private T[][] computeJacobianEccentricWrtCartesianHyperbolic() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianHyperbolic();
        T H = this.getEccentricAnomaly();
        RealFieldElement coshH = (RealFieldElement)H.cosh();
        RealFieldElement sinhH = (RealFieldElement)H.sinh();
        RealFieldElement absaOr = (RealFieldElement)((RealFieldElement)this.e.multiply((RealFieldElement)coshH).subtract(1.0)).reciprocal();
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = absaOr.multiply(anomalyRow[j].subtract(sinhH.multiply(eRow[j])));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianTrueWrtCartesianElliptical();
        }
        return this.computeJacobianTrueWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianTrueWrtCartesianElliptical() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianElliptical();
        RealFieldElement e2 = (RealFieldElement)this.e.multiply(this.e);
        RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)e2.negate()).add(1.0);
        RealFieldElement epsilon = (RealFieldElement)oMe2.sqrt();
        T eccentricAnomaly = this.getEccentricAnomaly();
        RealFieldElement cosE = (RealFieldElement)eccentricAnomaly.cos();
        RealFieldElement sinE = (RealFieldElement)eccentricAnomaly.sin();
        RealFieldElement aOr = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply((RealFieldElement)cosE).negate()).add(1.0)).reciprocal();
        RealFieldElement aFactor = epsilon.multiply(aOr);
        RealFieldElement eFactor = sinE.multiply(aOr).divide(epsilon);
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = aFactor.multiply(anomalyRow[j]).add(eFactor.multiply(eRow[j]));
        }
        return jacobian;
    }

    private T[][] computeJacobianTrueWrtCartesianHyperbolic() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianHyperbolic();
        RealFieldElement e2 = (RealFieldElement)this.e.multiply(this.e);
        RealFieldElement e2Mo = (RealFieldElement)e2.subtract(1.0);
        RealFieldElement epsilon = (RealFieldElement)e2Mo.sqrt();
        T H = this.getEccentricAnomaly();
        RealFieldElement coshH = (RealFieldElement)H.cosh();
        RealFieldElement sinhH = (RealFieldElement)H.sinh();
        RealFieldElement aOr = (RealFieldElement)((RealFieldElement)this.e.multiply((RealFieldElement)coshH).subtract(1.0)).reciprocal();
        RealFieldElement aFactor = epsilon.multiply(aOr);
        RealFieldElement eFactor = sinhH.multiply(aOr).divide(epsilon);
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = aFactor.multiply(anomalyRow[j]).subtract(eFactor.multiply(eRow[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        RealFieldElement absA = (RealFieldElement)this.a.abs();
        RealFieldElement n = ((RealFieldElement)((RealFieldElement)((RealFieldElement)absA.reciprocal()).multiply(gm)).sqrt()).divide(absA);
        switch (type) {
            case MEAN: {
                pDot[5] = pDot[5].add((RealFieldElement)n);
                break;
            }
            case ECCENTRIC: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0)).abs();
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.e.multiply(this.v.cos())).add(1.0);
                pDot[5] = pDot[5].add((RealFieldElement)n.multiply(ksi).divide(oMe2));
                break;
            }
            case TRUE: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0)).abs();
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.e.multiply(this.v.cos())).add(1.0);
                pDot[5] = (RealFieldElement)pDot[5].add(n.multiply(ksi).multiply(ksi).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("Keplerian parameters: ").append('{').append("a: ").append(this.a.getReal()).append("; e: ").append(this.e.getReal()).append("; i: ").append(FastMath.toDegrees(this.i.getReal())).append("; pa: ").append(FastMath.toDegrees(this.pa.getReal())).append("; raan: ").append(FastMath.toDegrees(this.raan.getReal())).append("; v: ").append(FastMath.toDegrees(this.v.getReal())).append(";}").toString();
    }

    @Deprecated
    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2))));
    }

    @Override
    public KeplerianOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), this.v.getReal(), this.aDot.getReal(), this.eDot.getReal(), this.iDot.getReal(), this.paDot.getReal(), this.raanDot.getReal(), this.vDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), this.v.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

