/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.sampling.FieldOrekitFixedStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepNormalizer;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class FieldAbstractPropagator<T extends RealFieldElement<T>>
implements FieldPropagator<T> {
    private int mode = 0;
    private T fixedStepSize;
    private FieldOrekitStepHandler<T> stepHandler = null;
    private FieldAbsoluteDate<T> startDate;
    private AttitudeProvider attitudeProvider;
    private final List<FieldAdditionalStateProvider<T>> additionalStateProviders;
    private final Map<String, TimeSpanMap<T[]>> unmanagedStates;
    private final Field<T> field;
    private FieldSpacecraftState<T> initialState;

    protected FieldAbstractPropagator(Field<T> field) {
        this.field = field;
        this.fixedStepSize = (RealFieldElement)((RealFieldElement)field.getZero()).add(Double.NaN);
        this.additionalStateProviders = new ArrayList<FieldAdditionalStateProvider<T>>();
        this.unmanagedStates = new HashMap<String, TimeSpanMap<T[]>>();
    }

    protected void setStartDate(FieldAbsoluteDate<T> startDate) {
        this.startDate = startDate;
    }

    protected FieldAbsoluteDate<T> getStartDate() {
        return this.startDate;
    }

    @Override
    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attitudeProvider = attitudeProvider;
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldSpacecraftState<T> getInitialState() {
        return this.initialState;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public Frame getFrame() {
        return this.initialState.getFrame();
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        this.initialState = state;
        this.setStartDate(state.getDate());
    }

    @Override
    public void setSlaveMode() {
        this.mode = 0;
        this.stepHandler = null;
        this.fixedStepSize = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(Double.NaN);
    }

    @Override
    public void setMasterMode(T h, FieldOrekitFixedStepHandler<T> handler) {
        this.setMasterMode(new FieldOrekitStepNormalizer<T>(h, handler));
        this.fixedStepSize = h;
    }

    @Override
    public void setMasterMode(FieldOrekitStepHandler<T> handler) {
        this.mode = 1;
        this.stepHandler = handler;
        this.fixedStepSize = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(Double.NaN);
    }

    @Override
    public void setEphemerisMode() {
        this.mode = 2;
        this.stepHandler = null;
        this.fixedStepSize = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(Double.NaN);
    }

    @Override
    public void addAdditionalStateProvider(FieldAdditionalStateProvider<T> additionalStateProvider) {
        if (this.isAdditionalStateManaged(additionalStateProvider.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additionalStateProvider.getName());
        }
        this.additionalStateProviders.add(additionalStateProvider);
    }

    @Override
    public List<FieldAdditionalStateProvider<T>> getAdditionalStateProviders() {
        return Collections.unmodifiableList(this.additionalStateProviders);
    }

    protected FieldSpacecraftState<T> updateAdditionalStates(FieldSpacecraftState<T> original) {
        FieldSpacecraftState updated = original;
        for (Map.Entry<String, TimeSpanMap<T[]>> entry : this.unmanagedStates.entrySet()) {
            updated = updated.addAdditionalState(entry.getKey(), (RealFieldElement[])entry.getValue().get(original.getDate().toAbsoluteDate()));
        }
        for (FieldAdditionalStateProvider fieldAdditionalStateProvider : this.additionalStateProviders) {
            updated = updated.addAdditionalState(fieldAdditionalStateProvider.getName(), fieldAdditionalStateProvider.getAdditionalState(updated));
        }
        return updated;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        for (FieldAdditionalStateProvider<T> provider : this.additionalStateProviders) {
            if (!provider.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] managed = new String[this.additionalStateProviders.size()];
        for (int i = 0; i < managed.length; ++i) {
            managed[i] = this.additionalStateProviders.get(i).getName();
        }
        return managed;
    }

    protected T getFixedStepSize() {
        return this.fixedStepSize;
    }

    protected FieldOrekitStepHandler<T> getStepHandler() {
        return this.stepHandler;
    }

    @Override
    public abstract FieldBoundedPropagator<T> getGeneratedEphemeris();

    @Override
    public abstract <D extends FieldEventDetector<T>> void addEventDetector(D var1);

    @Override
    public abstract Collection<FieldEventDetector<T>> getEventsDetectors();

    @Override
    public abstract void clearEventsDetectors();

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> target) {
        if (this.startDate == null) {
            this.startDate = this.getInitialState().getDate();
        }
        return this.propagate(this.startDate, target);
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    protected void initializePropagation() {
        this.unmanagedStates.clear();
        if (this.initialState != null) {
            for (Map.Entry<String, T[]> initial : this.initialState.getAdditionalStates().entrySet()) {
                if (this.isAdditionalStateManaged(initial.getKey())) continue;
                this.unmanagedStates.put(initial.getKey(), new TimeSpanMap<T[]>(initial.getValue()));
            }
        }
    }

    protected void stateChanged(FieldSpacecraftState<T> state) {
        AbsoluteDate date = state.getDate().toAbsoluteDate();
        boolean forward = date.durationFrom(this.getStartDate().toAbsoluteDate()) >= 0.0;
        for (Map.Entry<String, T[]> changed : state.getAdditionalStates().entrySet()) {
            TimeSpanMap<T[]> tsm = this.unmanagedStates.get(changed.getKey());
            if (tsm == null) continue;
            if (forward) {
                tsm.addValidAfter(changed.getValue(), date);
                continue;
            }
            tsm.addValidBefore(changed.getValue(), date);
        }
    }
}

